/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ClusterStatusTracker
extends ZooKeeperNodeTracker {
    private static final Log LOG = LogFactory.getLog(ClusterStatusTracker.class);

    public ClusterStatusTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.znodePaths.clusterStateZNode, abortable);
    }

    public boolean isClusterUp() {
        return super.getData(false) != null;
    }

    public void setClusterUp() throws KeeperException {
        byte[] upData = ClusterStatusTracker.toByteArray();
        try {
            ZKUtil.createAndWatch((ZooKeeperWatcher)this.watcher, (String)this.watcher.znodePaths.clusterStateZNode, (byte[])upData);
        }
        catch (KeeperException.NodeExistsException nee) {
            ZKUtil.setData((ZooKeeperWatcher)this.watcher, (String)this.watcher.znodePaths.clusterStateZNode, (byte[])upData);
        }
    }

    public void setClusterDown() throws KeeperException {
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)this.watcher, (String)this.watcher.znodePaths.clusterStateZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.warn((Object)("Attempted to set cluster as down but already down, cluster state node (" + this.watcher.znodePaths.clusterStateZNode + ") not found"));
        }
    }

    static byte[] toByteArray() {
        ZooKeeperProtos.ClusterUp.Builder builder = ZooKeeperProtos.ClusterUp.newBuilder();
        builder.setStartDate(new Date().toString());
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }
}

