/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AssignmentVerificationReport {
    private static final Logger LOG = LoggerFactory.getLogger((String)AssignmentVerificationReport.class.getName());
    private TableName tableName = null;
    private boolean enforceLocality = false;
    private boolean isFilledUp = false;
    private int totalRegions = 0;
    private int totalRegionServers = 0;
    private List<RegionInfo> unAssignedRegionsList = new ArrayList<RegionInfo>();
    private List<RegionInfo> regionsWithoutValidFavoredNodes = new ArrayList<RegionInfo>();
    private List<RegionInfo> nonFavoredAssignedRegionList = new ArrayList<RegionInfo>();
    private int totalFavoredAssignments = 0;
    private int[] favoredNodes = new int[3];
    private float[] favoredNodesLocalitySummary = new float[3];
    private float actualLocalitySummary = 0.0f;
    private float avgRegionsOnRS = 0.0f;
    private int maxRegionsOnRS = 0;
    private int minRegionsOnRS = Integer.MAX_VALUE;
    private Set<ServerName> mostLoadedRSSet = new HashSet<ServerName>();
    private Set<ServerName> leastLoadedRSSet = new HashSet<ServerName>();
    private float avgDispersionScore = 0.0f;
    private float maxDispersionScore = 0.0f;
    private Set<ServerName> maxDispersionScoreServerSet = new HashSet<ServerName>();
    private float minDispersionScore = Float.MAX_VALUE;
    private Set<ServerName> minDispersionScoreServerSet = new HashSet<ServerName>();
    private float avgDispersionNum = 0.0f;
    private float maxDispersionNum = 0.0f;
    private Set<ServerName> maxDispersionNumServerSet = new HashSet<ServerName>();
    private float minDispersionNum = Float.MAX_VALUE;
    private Set<ServerName> minDispersionNumServerSet = new HashSet<ServerName>();

    public void fillUp(TableName tableName, SnapshotOfRegionAssignmentFromMeta snapshot, Map<String, Map<String, Float>> regionLocalityMap) {
        this.tableName = tableName;
        List<RegionInfo> regionInfoList = snapshot.getTableToRegionMap().get(tableName);
        this.totalRegions = regionInfoList.size();
        FavoredNodesPlan favoredNodesAssignment = snapshot.getExistingAssignmentPlan();
        Map<RegionInfo, ServerName> currentAssignment = snapshot.getRegionToRegionServerMap();
        HashMap<ServerName, Integer> serverToHostingRegionCounterMap = new HashMap<ServerName, Integer>();
        HashMap<ServerName, Integer> primaryRSToRegionCounterMap = new HashMap<ServerName, Integer>();
        HashMap<ServerName, HashSet<ServerName>> primaryToSecTerRSMap = new HashMap<ServerName, HashSet<ServerName>>();
        for (RegionInfo region : regionInfoList) {
            try {
                ServerName currentRS = currentAssignment.get(region);
                if (currentRS == null) {
                    this.unAssignedRegionsList.add(region);
                    continue;
                }
                Integer hostRegionCounter = (Integer)serverToHostingRegionCounterMap.get(currentRS);
                if (hostRegionCounter == null) {
                    hostRegionCounter = 0;
                }
                hostRegionCounter = hostRegionCounter + 1;
                serverToHostingRegionCounterMap.put(currentRS, hostRegionCounter);
                List<ServerName> favoredNodes = favoredNodesAssignment.getFavoredNodes(region);
                if (favoredNodes == null || favoredNodes.size() != 3) {
                    this.regionsWithoutValidFavoredNodes.add(region);
                    continue;
                }
                ServerName primaryRS = favoredNodes.get(FavoredNodesPlan.Position.PRIMARY.ordinal());
                ServerName secondaryRS = favoredNodes.get(FavoredNodesPlan.Position.SECONDARY.ordinal());
                ServerName tertiaryRS = favoredNodes.get(FavoredNodesPlan.Position.TERTIARY.ordinal());
                Integer regionCounter = (Integer)primaryRSToRegionCounterMap.get(primaryRS);
                if (regionCounter == null) {
                    regionCounter = 0;
                }
                regionCounter = regionCounter + 1;
                primaryRSToRegionCounterMap.put(primaryRS, regionCounter);
                HashSet<ServerName> secAndTerSet = (HashSet<ServerName>)primaryToSecTerRSMap.get(primaryRS);
                if (secAndTerSet == null) {
                    secAndTerSet = new HashSet<ServerName>();
                }
                secAndTerSet.add(secondaryRS);
                secAndTerSet.add(tertiaryRS);
                primaryToSecTerRSMap.put(primaryRS, secAndTerSet);
                FavoredNodesPlan.Position favoredNodePosition = FavoredNodesPlan.getFavoredServerPosition(favoredNodes, currentRS);
                if (favoredNodePosition == null) {
                    this.nonFavoredAssignedRegionList.add(region);
                    continue;
                }
                int n = favoredNodePosition.ordinal();
                this.favoredNodes[n] = this.favoredNodes[n] + 1;
                ++this.totalFavoredAssignments;
                if (regionLocalityMap == null) continue;
                this.enforceLocality = true;
                Map<String, Float> regionDegreeLocalityMap = regionLocalityMap.get(region.getEncodedName());
                if (regionDegreeLocalityMap == null) continue;
                for (FavoredNodesPlan.Position p : FavoredNodesPlan.Position.values()) {
                    ServerName favoredNode = favoredNodes.get(p.ordinal());
                    Float locality = regionDegreeLocalityMap.get(favoredNode.getHostname());
                    if (locality == null) continue;
                    int n2 = p.ordinal();
                    this.favoredNodesLocalitySummary[n2] = this.favoredNodesLocalitySummary[n2] + locality.floatValue();
                }
                Float actualLocality = regionDegreeLocalityMap.get(currentRS.getHostname());
                if (actualLocality == null) continue;
                this.actualLocalitySummary += actualLocality.floatValue();
            }
            catch (Exception e) {
                LOG.error("Cannot verify the region assignment for region " + (region == null ? " null " : region.getRegionNameAsString()) + "because of " + e);
            }
        }
        float dispersionScoreSummary = 0.0f;
        float dispersionNumSummary = 0.0f;
        for (Map.Entry entry : primaryRSToRegionCounterMap.entrySet()) {
            ServerName primaryRS = (ServerName)entry.getKey();
            Integer regionsOnPrimary = (Integer)entry.getValue();
            float dispersionScore = 0.0f;
            int dispersionNum = 0;
            if (primaryToSecTerRSMap.get(primaryRS) != null && regionsOnPrimary != 0) {
                dispersionNum = ((Set)primaryToSecTerRSMap.get(primaryRS)).size();
                dispersionScore = (float)dispersionNum / ((float)regionsOnPrimary.intValue() * 2.0f);
            }
            if (dispersionScore > this.maxDispersionScore) {
                this.maxDispersionScoreServerSet.clear();
                this.maxDispersionScoreServerSet.add(primaryRS);
                this.maxDispersionScore = dispersionScore;
            } else if (dispersionScore == this.maxDispersionScore) {
                this.maxDispersionScoreServerSet.add(primaryRS);
            }
            if ((float)dispersionNum > this.maxDispersionNum) {
                this.maxDispersionNumServerSet.clear();
                this.maxDispersionNumServerSet.add(primaryRS);
                this.maxDispersionNum = dispersionNum;
            } else if ((float)dispersionNum == this.maxDispersionNum) {
                this.maxDispersionNumServerSet.add(primaryRS);
            }
            if (dispersionScore < this.minDispersionScore) {
                this.minDispersionScoreServerSet.clear();
                this.minDispersionScoreServerSet.add(primaryRS);
                this.minDispersionScore = dispersionScore;
            } else if (dispersionScore == this.minDispersionScore) {
                this.minDispersionScoreServerSet.add(primaryRS);
            }
            if ((float)dispersionNum < this.minDispersionNum) {
                this.minDispersionNumServerSet.clear();
                this.minDispersionNumServerSet.add(primaryRS);
                this.minDispersionNum = dispersionNum;
            } else if ((float)dispersionNum == this.minDispersionNum) {
                this.minDispersionNumServerSet.add(primaryRS);
            }
            dispersionScoreSummary += dispersionScore;
            dispersionNumSummary += (float)dispersionNum;
        }
        if (primaryRSToRegionCounterMap.keySet().size() != 0) {
            this.avgDispersionScore = dispersionScoreSummary / (float)primaryRSToRegionCounterMap.keySet().size();
            this.avgDispersionNum = dispersionNumSummary / (float)primaryRSToRegionCounterMap.keySet().size();
        }
        for (Map.Entry entry : serverToHostingRegionCounterMap.entrySet()) {
            ServerName currentRS = (ServerName)entry.getKey();
            int hostRegionCounter = (Integer)entry.getValue();
            if (hostRegionCounter > this.maxRegionsOnRS) {
                this.maxRegionsOnRS = hostRegionCounter;
                this.mostLoadedRSSet.clear();
                this.mostLoadedRSSet.add(currentRS);
            } else if (hostRegionCounter == this.maxRegionsOnRS) {
                this.mostLoadedRSSet.add(currentRS);
            }
            if (hostRegionCounter < this.minRegionsOnRS) {
                this.minRegionsOnRS = hostRegionCounter;
                this.leastLoadedRSSet.clear();
                this.leastLoadedRSSet.add(currentRS);
                continue;
            }
            if (hostRegionCounter != this.minRegionsOnRS) continue;
            this.leastLoadedRSSet.add(currentRS);
        }
        this.totalRegionServers = serverToHostingRegionCounterMap.keySet().size();
        this.avgRegionsOnRS = this.totalRegionServers == 0 ? 0.0f : (float)this.totalRegions / (float)this.totalRegionServers;
        this.isFilledUp = true;
    }

    public void fillUpDispersion(TableName tableName, SnapshotOfRegionAssignmentFromMeta snapshot, FavoredNodesPlan newPlan) {
        this.tableName = tableName;
        List<RegionInfo> regionInfoList = snapshot.getTableToRegionMap().get(tableName);
        this.totalRegions = regionInfoList.size();
        FavoredNodesPlan plan = null;
        plan = newPlan == null ? snapshot.getExistingAssignmentPlan() : newPlan;
        HashMap<ServerName, Integer> primaryRSToRegionCounterMap = new HashMap<ServerName, Integer>();
        HashMap<ServerName, HashSet<ServerName>> primaryToSecTerRSMap = new HashMap<ServerName, HashSet<ServerName>>();
        for (RegionInfo region : regionInfoList) {
            try {
                List<ServerName> favoredNodes = plan.getFavoredNodes(region);
                if (favoredNodes == null || favoredNodes.size() != 3) {
                    this.regionsWithoutValidFavoredNodes.add(region);
                    continue;
                }
                ServerName primaryRS = favoredNodes.get(FavoredNodesPlan.Position.PRIMARY.ordinal());
                ServerName secondaryRS = favoredNodes.get(FavoredNodesPlan.Position.SECONDARY.ordinal());
                ServerName tertiaryRS = favoredNodes.get(FavoredNodesPlan.Position.TERTIARY.ordinal());
                Integer regionCounter = (Integer)primaryRSToRegionCounterMap.get(primaryRS);
                if (regionCounter == null) {
                    regionCounter = 0;
                }
                regionCounter = regionCounter + 1;
                primaryRSToRegionCounterMap.put(primaryRS, regionCounter);
                HashSet<ServerName> secAndTerSet = (HashSet<ServerName>)primaryToSecTerRSMap.get(primaryRS);
                if (secAndTerSet == null) {
                    secAndTerSet = new HashSet<ServerName>();
                }
                secAndTerSet.add(secondaryRS);
                secAndTerSet.add(tertiaryRS);
                primaryToSecTerRSMap.put(primaryRS, secAndTerSet);
            }
            catch (Exception e) {
                LOG.error("Cannot verify the region assignment for region " + (region == null ? " null " : region.getRegionNameAsString()) + "because of " + e);
            }
        }
        float dispersionScoreSummary = 0.0f;
        float dispersionNumSummary = 0.0f;
        for (Map.Entry entry : primaryRSToRegionCounterMap.entrySet()) {
            ServerName primaryRS = (ServerName)entry.getKey();
            Integer regionsOnPrimary = (Integer)entry.getValue();
            float dispersionScore = 0.0f;
            int dispersionNum = 0;
            if (primaryToSecTerRSMap.get(primaryRS) != null && regionsOnPrimary != 0) {
                dispersionNum = ((Set)primaryToSecTerRSMap.get(primaryRS)).size();
                dispersionScore = (float)dispersionNum / ((float)regionsOnPrimary.intValue() * 2.0f);
            }
            if ((float)dispersionNum > this.maxDispersionNum) {
                this.maxDispersionNumServerSet.clear();
                this.maxDispersionNumServerSet.add(primaryRS);
                this.maxDispersionNum = dispersionNum;
            } else if ((float)dispersionNum == this.maxDispersionNum) {
                this.maxDispersionNumServerSet.add(primaryRS);
            }
            if (dispersionScore < this.minDispersionScore) {
                this.minDispersionScoreServerSet.clear();
                this.minDispersionScoreServerSet.add(primaryRS);
                this.minDispersionScore = dispersionScore;
            } else if (dispersionScore == this.minDispersionScore) {
                this.minDispersionScoreServerSet.add(primaryRS);
            }
            if ((float)dispersionNum < this.minDispersionNum) {
                this.minDispersionNumServerSet.clear();
                this.minDispersionNumServerSet.add(primaryRS);
                this.minDispersionNum = dispersionNum;
            } else if ((float)dispersionNum == this.minDispersionNum) {
                this.minDispersionNumServerSet.add(primaryRS);
            }
            dispersionScoreSummary += dispersionScore;
            dispersionNumSummary += (float)dispersionNum;
        }
        if (primaryRSToRegionCounterMap.keySet().size() != 0) {
            this.avgDispersionScore = dispersionScoreSummary / (float)primaryRSToRegionCounterMap.keySet().size();
            this.avgDispersionNum = dispersionNumSummary / (float)primaryRSToRegionCounterMap.keySet().size();
        }
    }

    public List<Float> getDispersionInformation() {
        ArrayList<Float> dispersion = new ArrayList<Float>();
        dispersion.add(Float.valueOf(this.avgDispersionScore));
        dispersion.add(Float.valueOf(this.maxDispersionScore));
        dispersion.add(Float.valueOf(this.minDispersionScore));
        return dispersion;
    }

    public void print(boolean isDetailMode) {
        if (!this.isFilledUp) {
            System.err.println("[Error] Region assignment verification reporthasn't been filled up");
        }
        DecimalFormat df = new DecimalFormat("#.##");
        System.out.println("Region Assignment Verification for Table: " + this.tableName + "\n\tTotal regions : " + this.totalRegions);
        System.out.println("\tTotal regions on favored nodes " + this.totalFavoredAssignments);
        for (FavoredNodesPlan.Position p : FavoredNodesPlan.Position.values()) {
            System.out.println("\t\tTotal regions on " + p.toString() + " region servers: " + this.favoredNodes[p.ordinal()]);
        }
        System.out.println("\tTotal unassigned regions: " + this.unAssignedRegionsList.size());
        if (isDetailMode) {
            for (RegionInfo region : this.unAssignedRegionsList) {
                System.out.println("\t\t" + region.getRegionNameAsString());
            }
        }
        System.out.println("\tTotal regions NOT on favored nodes: " + this.nonFavoredAssignedRegionList.size());
        if (isDetailMode) {
            for (RegionInfo region : this.nonFavoredAssignedRegionList) {
                System.out.println("\t\t" + region.getRegionNameAsString());
            }
        }
        System.out.println("\tTotal regions without favored nodes: " + this.regionsWithoutValidFavoredNodes.size());
        if (isDetailMode) {
            for (RegionInfo region : this.regionsWithoutValidFavoredNodes) {
                System.out.println("\t\t" + region.getRegionNameAsString());
            }
        }
        if (this.enforceLocality && this.totalRegions != 0) {
            float actualLocality = 100.0f * this.actualLocalitySummary / (float)this.totalRegions;
            System.out.println("\n\tThe actual avg locality is " + df.format(actualLocality) + " %");
            for (FavoredNodesPlan.Position p : FavoredNodesPlan.Position.values()) {
                float avgLocality = 100.0f * (this.favoredNodesLocalitySummary[p.ordinal()] / (float)this.totalRegions);
                System.out.println("\t\tThe expected avg locality if all regions on the " + p.toString() + " region servers: " + df.format(avgLocality) + " %");
            }
        }
        System.out.println("\n\tTotal hosting region servers: " + this.totalRegionServers);
        if (this.totalRegionServers != 0) {
            System.out.println("\tAvg dispersion num: " + df.format(this.avgDispersionNum) + " hosts;\tMax dispersion num: " + df.format(this.maxDispersionNum) + " hosts;\tMin dispersion num: " + df.format(this.minDispersionNum) + " hosts;");
            System.out.println("\t\tThe number of the region servers with the max dispersion num: " + this.maxDispersionNumServerSet.size());
            if (isDetailMode) {
                this.printHServerAddressSet(this.maxDispersionNumServerSet);
            }
            System.out.println("\t\tThe number of the region servers with the min dispersion num: " + this.minDispersionNumServerSet.size());
            if (isDetailMode) {
                this.printHServerAddressSet(this.maxDispersionNumServerSet);
            }
            System.out.println("\tAvg dispersion score: " + df.format(this.avgDispersionScore) + ";\tMax dispersion score: " + df.format(this.maxDispersionScore) + ";\tMin dispersion score: " + df.format(this.minDispersionScore) + ";");
            System.out.println("\t\tThe number of the region servers with the max dispersion score: " + this.maxDispersionScoreServerSet.size());
            if (isDetailMode) {
                this.printHServerAddressSet(this.maxDispersionScoreServerSet);
            }
            System.out.println("\t\tThe number of the region servers with the min dispersion score: " + this.minDispersionScoreServerSet.size());
            if (isDetailMode) {
                this.printHServerAddressSet(this.minDispersionScoreServerSet);
            }
            System.out.println("\tAvg regions/region server: " + df.format(this.avgRegionsOnRS) + ";\tMax regions/region server: " + this.maxRegionsOnRS + ";\tMin regions/region server: " + this.minRegionsOnRS + ";");
            System.out.println("\t\tThe number of the most loaded region servers: " + this.mostLoadedRSSet.size());
            if (isDetailMode) {
                this.printHServerAddressSet(this.mostLoadedRSSet);
            }
            System.out.println("\t\tThe number of the least loaded region servers: " + this.leastLoadedRSSet.size());
            if (isDetailMode) {
                this.printHServerAddressSet(this.leastLoadedRSSet);
            }
        }
        System.out.println("==============================");
    }

    List<RegionInfo> getUnassignedRegions() {
        return this.unAssignedRegionsList;
    }

    List<RegionInfo> getRegionsWithoutValidFavoredNodes() {
        return this.regionsWithoutValidFavoredNodes;
    }

    List<RegionInfo> getNonFavoredAssignedRegions() {
        return this.nonFavoredAssignedRegionList;
    }

    int getTotalFavoredAssignments() {
        return this.totalFavoredAssignments;
    }

    int getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position position) {
        return this.favoredNodes[position.ordinal()];
    }

    private void printHServerAddressSet(Set<ServerName> serverSet) {
        if (serverSet == null) {
            return;
        }
        int i = 0;
        for (ServerName addr : serverSet) {
            if (i++ % 3 == 0) {
                System.out.print("\n\t\t\t");
            }
            System.out.print(addr.getHostAndPort() + " ; ");
        }
        System.out.println("\n");
    }
}

