/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.CompletionException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableAdminApi4
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableAdminApi4.class);

    @Test
    public void testCloneTableSchema() throws Exception {
        TableName newTableName = TableName.valueOf((String)(this.tableName.getNameAsString() + "_new"));
        this.testCloneTableSchema(this.tableName, newTableName, false);
    }

    @Test
    public void testCloneTableSchemaPreservingSplits() throws Exception {
        TableName newTableName = TableName.valueOf((String)(this.tableName.getNameAsString() + "_new"));
        this.testCloneTableSchema(this.tableName, newTableName, true);
    }

    private void testCloneTableSchema(TableName tableName, TableName newTableName, boolean preserveSplits) throws Exception {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        int NUM_FAMILYS = 2;
        int NUM_REGIONS = 3;
        int BLOCK_SIZE = 1024;
        int TTL = 86400;
        boolean BLOCK_CACHE = false;
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_1).setBlocksize(BLOCK_SIZE).setBlockCacheEnabled(BLOCK_CACHE).setTimeToLive(TTL).build()).build();
        this.admin.createTable(tableDesc, (byte[][])splitKeys).join();
        Assert.assertEquals((long)NUM_REGIONS, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)((Boolean)this.admin.isTableAvailable(tableName, (byte[][])splitKeys).get()));
        this.admin.cloneTableSchema(tableName, newTableName, preserveSplits).join();
        TableDescriptor newTableDesc = (TableDescriptor)this.admin.getDescriptor(newTableName).get();
        Assert.assertEquals((long)NUM_FAMILYS, (long)newTableDesc.getColumnFamilyCount());
        Assert.assertEquals((long)BLOCK_SIZE, (long)newTableDesc.getColumnFamily(FAMILY_1).getBlocksize());
        Assert.assertEquals((Object)BLOCK_CACHE, (Object)newTableDesc.getColumnFamily(FAMILY_1).isBlockCacheEnabled());
        Assert.assertEquals((long)TTL, (long)newTableDesc.getColumnFamily(FAMILY_1).getTimeToLive());
        TEST_UTIL.verifyTableDescriptorIgnoreTableName(tableDesc, newTableDesc);
        if (preserveSplits) {
            Assert.assertEquals((long)NUM_REGIONS, (long)TEST_UTIL.getHBaseCluster().getRegions(newTableName).size());
            Assert.assertTrue((String)"New table should be created with splitKyes + 1 rows in META", (boolean)((Boolean)this.admin.isTableAvailable(newTableName, (byte[][])splitKeys).get()));
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(newTableName).size());
        }
    }

    @Test
    public void testCloneTableSchemaWithNonExistentSourceTable() throws Exception {
        TableName newTableName = TableName.valueOf((String)(this.tableName.getNameAsString() + "_new"));
        try {
            this.admin.cloneTableSchema(this.tableName, newTableName, false).join();
            Assert.fail((String)"Should have failed when source table doesn't exist.");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TableNotFoundException));
        }
    }

    @Test
    public void testCloneTableSchemaWithExistentDestinationTable() throws Exception {
        TableName newTableName = TableName.valueOf((String)(this.tableName.getNameAsString() + "_new"));
        byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
        TEST_UTIL.createTable(this.tableName, FAMILY_0);
        TEST_UTIL.createTable(newTableName, FAMILY_0);
        try {
            this.admin.cloneTableSchema(this.tableName, newTableName, false).join();
            Assert.fail((String)"Should have failed when destination table exists.");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TableExistsException));
        }
    }

    @Test
    public void testIsTableAvailableWithInexistantTable() throws Exception {
        TableName newTableName = TableName.valueOf((String)(this.tableName.getNameAsString() + "_new"));
        Assert.assertFalse((boolean)((Boolean)this.admin.isTableAvailable(newTableName).get()));
    }
}

