/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestAppendTimeRange {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAppendTimeRange.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility util = new HBaseTestingUtility();
    private static final ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] ROW = Bytes.toBytes((String)"aaa");
    private static final byte[] QUAL = Bytes.toBytes((String)"col1");
    private static final byte[] VALUE = Bytes.toBytes((String)"1");

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", MyObserver.class.getName());
        util.getConfiguration().setInt("hbase.procedure.remote.dispatcher.delay.msec", 0);
        util.startMiniCluster();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)mee);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testHTableInterfaceMethods() throws Exception {
        try (Table table = util.createTable(TableName.valueOf((String)this.name.getMethodName()), TEST_FAMILY);){
            table.put(new Put(ROW).addColumn(TEST_FAMILY, QUAL, VALUE));
            long time = EnvironmentEdgeManager.currentTime();
            mee.setValue(time);
            table.put(new Put(ROW).addColumn(TEST_FAMILY, QUAL, Bytes.toBytes((String)"a")));
            this.checkRowValue(table, ROW, Bytes.toBytes((String)"a"));
            time = EnvironmentEdgeManager.currentTime();
            mee.setValue(time);
            TimeRange range10 = new TimeRange(1L, time + 10L);
            Result r = table.append(new Append(ROW).addColumn(TEST_FAMILY, QUAL, Bytes.toBytes((String)"b")).setTimeRange(range10.getMin(), range10.getMax()));
            this.checkRowValue(table, ROW, Bytes.toBytes((String)"ab"));
            Assert.assertEquals((long)MyObserver.tr10.getMin(), (long)range10.getMin());
            Assert.assertEquals((long)MyObserver.tr10.getMax(), (long)range10.getMax());
            time = EnvironmentEdgeManager.currentTime();
            mee.setValue(time);
            TimeRange range2 = new TimeRange(1L, time + 20L);
            List<Row> actions = Arrays.asList(new Append(ROW).addColumn(TEST_FAMILY, QUAL, Bytes.toBytes((String)"c")).setTimeRange(range2.getMin(), range2.getMax()), new Append(ROW).addColumn(TEST_FAMILY, QUAL, Bytes.toBytes((String)"c")).setTimeRange(range2.getMin(), range2.getMax()));
            Object[] results1 = new Object[actions.size()];
            table.batch(actions, results1);
            Assert.assertEquals((long)MyObserver.tr2.getMin(), (long)range2.getMin());
            Assert.assertEquals((long)MyObserver.tr2.getMax(), (long)range2.getMax());
            for (Object r2 : results1) {
                Assert.assertTrue((boolean)(r2 instanceof Result));
            }
            this.checkRowValue(table, ROW, Bytes.toBytes((String)"abcc"));
        }
    }

    private void checkRowValue(Table table, byte[] row, byte[] expectedValue) throws IOException {
        Get get = new Get(row).addColumn(TEST_FAMILY, QUAL);
        Result result = table.get(get);
        byte[] actualValue = result.getValue(TEST_FAMILY, QUAL);
        Assert.assertArrayEquals((byte[])expectedValue, (byte[])actualValue);
    }

    public static class MyObserver
    implements RegionCoprocessor,
    RegionObserver {
        private static TimeRange tr10 = null;
        private static TimeRange tr2 = null;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
            NavigableMap map = append.getFamilyCellMap();
            for (Map.Entry entry : map.entrySet()) {
                for (Cell cell : (List)entry.getValue()) {
                    String appendStr = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                    if (appendStr.equals("b")) {
                        tr10 = append.getTimeRange();
                        continue;
                    }
                    if (!appendStr.equals("c") || append.getTimeRange().isAllTime()) continue;
                    tr2 = append.getTimeRange();
                }
            }
            return null;
        }
    }
}

