/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSink;
import org.apache.hadoop.hbase.replication.regionserver.TestReplicationSink;
import org.apache.hadoop.hbase.replication.regionserver.WALEntrySinkFilter;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestWALEntrySinkFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALEntrySinkFilter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationSink.class);
    @Rule
    public TestName name = new TestName();
    static final int BOUNDARY = 5;
    static final AtomicInteger UNFILTERED = new AtomicInteger();
    static final AtomicInteger FILTERED = new AtomicInteger();
    private static Stoppable STOPPABLE = new Stoppable(){
        private final AtomicBoolean stop = new AtomicBoolean(false);

        public boolean isStopped() {
            return this.stop.get();
        }

        public void stop(String why) {
            LOG.info("STOPPING BECAUSE: " + why);
            this.stop.set(true);
        }
    };

    @Test
    public void testWALEntryFilter() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.replication.sink.walentrysinkfilter", IfTimeIsGreaterThanBOUNDARYWALEntrySinkFilterImpl.class, WALEntrySinkFilter.class);
        conf.setClass("hbase.client.connection.impl", DevNullConnection.class, Connection.class);
        ReplicationSink sink = new ReplicationSink(conf);
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>();
        AdminProtos.WALEntry.Builder entryBuilder = AdminProtos.WALEntry.newBuilder();
        ByteString tableName = ByteString.copyFromUtf8((String)TableName.valueOf((String)this.name.getMethodName()).toString());
        final ArrayList<Cell> cells = new ArrayList<Cell>();
        int count = 10;
        for (int i = 0; i < count; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            entryBuilder.clear();
            entryBuilder.setKey(entryBuilder.getKeyBuilder().setLogSequenceNumber((long)i).setEncodedRegionName(ByteString.copyFrom((byte[])bytes)).setWriteTime((long)i).setTableName(tableName).build());
            entryBuilder.setAssociatedCellCount(1);
            entries.add(entryBuilder.build());
            CellBuilder cellBuilder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY);
            Cell cell = cellBuilder.setRow(bytes).setFamily(bytes).setQualifier(bytes).setType(Cell.Type.Put).setTimestamp((long)i).setValue(bytes).build();
            cells.add(cell);
        }
        CellScanner cellScanner = new CellScanner(){
            int index = -1;

            public Cell current() {
                return (Cell)cells.get(this.index);
            }

            public boolean advance() throws IOException {
                ++this.index;
                return this.index < cells.size();
            }
        };
        sink.replicateEntries(entries, cellScanner, null, null, null);
        Assert.assertTrue((FILTERED.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((UNFILTERED.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)count, (long)(FILTERED.get() + UNFILTERED.get()));
    }

    public static class DevNullConnection
    implements Connection {
        private final Configuration configuration;

        DevNullConnection(Configuration configuration, ExecutorService es, User user) {
            this.configuration = configuration;
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
            return null;
        }

        public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
            return null;
        }

        public RegionLocator getRegionLocator(TableName tableName) throws IOException {
            return null;
        }

        public Admin getAdmin() throws IOException {
            return null;
        }

        public void close() throws IOException {
        }

        public boolean isClosed() {
            return false;
        }

        public TableBuilder getTableBuilder(final TableName tableName, ExecutorService pool) {
            return new TableBuilder(){

                public TableBuilder setOperationTimeout(int timeout) {
                    return this;
                }

                public TableBuilder setRpcTimeout(int timeout) {
                    return this;
                }

                public TableBuilder setReadRpcTimeout(int timeout) {
                    return this;
                }

                public TableBuilder setWriteRpcTimeout(int timeout) {
                    return this;
                }

                public Table build() {
                    return new Table(){

                        public TableName getName() {
                            return tableName;
                        }

                        public Configuration getConfiguration() {
                            return configuration;
                        }

                        public HTableDescriptor getTableDescriptor() throws IOException {
                            return null;
                        }

                        public TableDescriptor getDescriptor() throws IOException {
                            return null;
                        }

                        public boolean exists(Get get) throws IOException {
                            return false;
                        }

                        public boolean[] exists(List<Get> gets) throws IOException {
                            return new boolean[0];
                        }

                        public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
                            for (Row row : actions) {
                                int row2 = Bytes.toInt((byte[])row.getRow());
                                Assert.assertTrue((String)("" + row2), (row2 > 5 ? 1 : 0) != 0);
                                UNFILTERED.incrementAndGet();
                            }
                        }

                        public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
                        }

                        public Result get(Get get) throws IOException {
                            return null;
                        }

                        public Result[] get(List<Get> gets) throws IOException {
                            return new Result[0];
                        }

                        public ResultScanner getScanner(Scan scan) throws IOException {
                            return null;
                        }

                        public ResultScanner getScanner(byte[] family) throws IOException {
                            return null;
                        }

                        public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
                            return null;
                        }

                        public void put(Put put) throws IOException {
                        }

                        public void put(List<Put> puts) throws IOException {
                        }

                        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
                            return false;
                        }

                        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
                            return false;
                        }

                        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put) throws IOException {
                            return false;
                        }

                        public void delete(Delete delete) throws IOException {
                        }

                        public void delete(List<Delete> deletes) throws IOException {
                        }

                        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
                            return false;
                        }

                        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
                            return false;
                        }

                        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
                            return false;
                        }

                        public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
                            return null;
                        }

                        public void mutateRow(RowMutations rm) throws IOException {
                        }

                        public Result append(Append append) throws IOException {
                            return null;
                        }

                        public Result increment(Increment increment) throws IOException {
                            return null;
                        }

                        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
                            return 0L;
                        }

                        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
                            return 0L;
                        }

                        public void close() throws IOException {
                        }

                        public CoprocessorRpcChannel coprocessorService(byte[] row) {
                            return null;
                        }

                        public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
                            return null;
                        }

                        public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
                        }

                        public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
                            return null;
                        }

                        public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
                        }

                        public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
                            return false;
                        }

                        public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations mutation) throws IOException {
                            return false;
                        }

                        public long getRpcTimeout(TimeUnit unit) {
                            return 0L;
                        }

                        public int getRpcTimeout() {
                            return 0;
                        }

                        public void setRpcTimeout(int rpcTimeout) {
                        }

                        public long getReadRpcTimeout(TimeUnit unit) {
                            return 0L;
                        }

                        public int getReadRpcTimeout() {
                            return 0;
                        }

                        public void setReadRpcTimeout(int readRpcTimeout) {
                        }

                        public long getWriteRpcTimeout(TimeUnit unit) {
                            return 0L;
                        }

                        public int getWriteRpcTimeout() {
                            return 0;
                        }

                        public void setWriteRpcTimeout(int writeRpcTimeout) {
                        }

                        public long getOperationTimeout(TimeUnit unit) {
                            return 0L;
                        }

                        public int getOperationTimeout() {
                            return 0;
                        }

                        public void setOperationTimeout(int operationTimeout) {
                        }
                    };
                }
            };
        }

        public void clearRegionLocationCache() {
        }
    }

    public static class IfTimeIsGreaterThanBOUNDARYWALEntrySinkFilterImpl
    implements WALEntrySinkFilter {
        public void init(Connection connection) {
        }

        public boolean filter(TableName table, long writeTime) {
            boolean b;
            boolean bl = b = writeTime <= 5L;
            if (b) {
                FILTERED.incrementAndGet();
            }
            return b;
        }
    }
}

