/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.tool.TestLoadIncrementalHFilesBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, LargeTests.class})
public class TestLoadIncrementalHFiles2
extends TestLoadIncrementalHFilesBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLoadIncrementalHFiles2.class);

    @Test
    public void testRegionCrossingHFileSplit() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.NONE);
    }

    @Test
    public void testRegionCrossingHFileSplitRowBloom() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.ROW);
    }

    @Test
    public void testRegionCrossingHFileSplitRowColBloom() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.ROWCOL);
    }

    private void testRegionCrossingHFileSplit(BloomType bloomType) throws Exception {
        this.runTest("testHFileSplit" + bloomType + "Bloom", bloomType, new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testRegionCrossingLoad() throws Exception {
        this.runTest("testRegionCrossingLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testRegionCrossingRowBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowBloom", BloomType.ROW, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testRegionCrossingRowColBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowColBloom", BloomType.ROWCOL, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }
}

