/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.favored.FavoredNodesPromoter;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FavoredStochasticBalancer
extends StochasticLoadBalancer
implements FavoredNodesPromoter {
    private static final Logger LOG = LoggerFactory.getLogger(FavoredStochasticBalancer.class);
    private FavoredNodesManager fnm;

    @Override
    public void initialize() throws HBaseIOException {
        this.configureGenerators();
        super.initialize();
    }

    protected void configureGenerators() {
        ArrayList<StochasticLoadBalancer.CandidateGenerator> fnPickers = new ArrayList<StochasticLoadBalancer.CandidateGenerator>(2);
        fnPickers.add(new FavoredNodeLoadPicker());
        fnPickers.add(new FavoredNodeLocalityPicker());
        this.setCandidateGenerators(fnPickers);
    }

    @Override
    public synchronized void setMasterServices(MasterServices masterServices) {
        super.setMasterServices(masterServices);
        this.fnm = masterServices.getFavoredNodesManager();
    }

    @Override
    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        this.metricsBalancer.incrMiscInvocations();
        HashSet regionSet = Sets.newHashSet(regions);
        Map<ServerName, List<RegionInfo>> assignmentMap = this.assignMasterSystemRegions(regions, servers);
        if (assignmentMap != null && !assignmentMap.isEmpty()) {
            servers = new ArrayList<ServerName>(servers);
            servers.remove(this.masterServerName);
            List<RegionInfo> masterRegions = assignmentMap.get(this.masterServerName);
            if (!masterRegions.isEmpty()) {
                for (RegionInfo region : masterRegions) {
                    regionSet.remove(region);
                }
            }
        }
        if (regionSet.isEmpty()) {
            return assignmentMap;
        }
        try {
            FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.fnm.getRackManager());
            helper.initialize();
            Set<RegionInfo> systemRegions = FavoredNodesManager.filterNonFNApplicableRegions(regionSet);
            regionSet.removeAll(systemRegions);
            Map<ServerName, List<RegionInfo>> systemAssignments = super.roundRobinAssignment(Lists.newArrayList(systemRegions), servers);
            Pair<Map<ServerName, List<RegionInfo>>, List<RegionInfo>> segregatedRegions = this.segregateRegionsAndAssignRegionsWithFavoredNodes(regionSet, servers);
            Map regionsWithFavoredNodesMap = (Map)segregatedRegions.getFirst();
            Map<ServerName, List<RegionInfo>> regionsWithoutFN = this.generateFNForRegionsWithoutFN(helper, (List)segregatedRegions.getSecond());
            this.mergeAssignmentMaps(assignmentMap, systemAssignments);
            this.mergeAssignmentMaps(assignmentMap, regionsWithFavoredNodesMap);
            this.mergeAssignmentMaps(assignmentMap, regionsWithoutFN);
        }
        catch (Exception ex) {
            throw new HBaseIOException("Encountered exception while doing favored-nodes assignment " + ex + " Falling back to regular assignment", (Throwable)ex);
        }
        return assignmentMap;
    }

    private void mergeAssignmentMaps(Map<ServerName, List<RegionInfo>> assignmentMap, Map<ServerName, List<RegionInfo>> otherAssignments) {
        if (otherAssignments == null || otherAssignments.isEmpty()) {
            return;
        }
        for (Map.Entry<ServerName, List<RegionInfo>> entry : otherAssignments.entrySet()) {
            ServerName sn = entry.getKey();
            List<RegionInfo> regionsList = entry.getValue();
            if (assignmentMap.get(sn) == null) {
                assignmentMap.put(sn, Lists.newArrayList(regionsList));
                continue;
            }
            assignmentMap.get(sn).addAll(regionsList);
        }
    }

    private Map<ServerName, List<RegionInfo>> generateFNForRegionsWithoutFN(FavoredNodeAssignmentHelper helper, List<RegionInfo> regions) throws IOException {
        HashMap assignmentMap = Maps.newHashMap();
        if (regions.size() > 0) {
            Map<RegionInfo, List<ServerName>> regionsNoFNMap = helper.generateFavoredNodesRoundRobin(assignmentMap, regions);
            this.fnm.updateFavoredNodes(regionsNoFNMap);
        }
        return assignmentMap;
    }

    private Pair<Map<ServerName, List<RegionInfo>>, List<RegionInfo>> segregateRegionsAndAssignRegionsWithFavoredNodes(Collection<RegionInfo> regions, List<ServerName> onlineServers) throws HBaseIOException {
        HashMap<ServerName, List<RegionInfo>> assignmentMapForFavoredNodes = new HashMap<ServerName, List<RegionInfo>>(onlineServers.size());
        ArrayList<RegionInfo> regionsWithNoFavoredNodes = new ArrayList<RegionInfo>();
        for (RegionInfo region : regions) {
            List<ServerName> favoredNodes = this.fnm.getFavoredNodes(region);
            ServerName primaryHost = null;
            ServerName secondaryHost = null;
            ServerName tertiaryHost = null;
            if (favoredNodes != null && !favoredNodes.isEmpty()) {
                for (ServerName s : favoredNodes) {
                    ServerName serverWithLegitStartCode = this.getServerFromFavoredNode(onlineServers, s);
                    if (serverWithLegitStartCode == null) continue;
                    FavoredNodesPlan.Position position = FavoredNodesPlan.getFavoredServerPosition(favoredNodes, s);
                    if (FavoredNodesPlan.Position.PRIMARY.equals((Object)position)) {
                        primaryHost = serverWithLegitStartCode;
                        continue;
                    }
                    if (FavoredNodesPlan.Position.SECONDARY.equals((Object)position)) {
                        secondaryHost = serverWithLegitStartCode;
                        continue;
                    }
                    if (!FavoredNodesPlan.Position.TERTIARY.equals((Object)position)) continue;
                    tertiaryHost = serverWithLegitStartCode;
                }
                this.assignRegionToAvailableFavoredNode(assignmentMapForFavoredNodes, region, primaryHost, secondaryHost, tertiaryHost);
                continue;
            }
            regionsWithNoFavoredNodes.add(region);
        }
        return new Pair(assignmentMapForFavoredNodes, regionsWithNoFavoredNodes);
    }

    private void addRegionToMap(Map<ServerName, List<RegionInfo>> assignmentMapForFavoredNodes, RegionInfo region, ServerName host) {
        ArrayList regionsOnServer = assignmentMapForFavoredNodes.get(host);
        if (regionsOnServer == null) {
            regionsOnServer = Lists.newArrayList();
            assignmentMapForFavoredNodes.put(host, regionsOnServer);
        }
        regionsOnServer.add(region);
    }

    private ServerName getServerFromFavoredNode(List<ServerName> servers, ServerName fn) {
        for (ServerName server : servers) {
            if (!ServerName.isSameAddress((ServerName)fn, (ServerName)server)) continue;
            return server;
        }
        return null;
    }

    private void assignRegionToAvailableFavoredNode(Map<ServerName, List<RegionInfo>> assignmentMapForFavoredNodes, RegionInfo region, ServerName primaryHost, ServerName secondaryHost, ServerName tertiaryHost) {
        if (primaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, primaryHost);
        } else if (secondaryHost != null && tertiaryHost != null) {
            ServerMetrics tertiaryLoad = this.services.getServerManager().getLoad(tertiaryHost);
            ServerMetrics secondaryLoad = this.services.getServerManager().getLoad(secondaryHost);
            ServerName s = secondaryLoad != null && tertiaryLoad != null ? (secondaryLoad.getRegionMetrics().size() < tertiaryLoad.getRegionMetrics().size() ? secondaryHost : tertiaryHost) : (RANDOM.nextBoolean() ? secondaryHost : tertiaryHost);
            this.addRegionToMap(assignmentMapForFavoredNodes, region, s);
        } else if (secondaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, secondaryHost);
        } else if (tertiaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, tertiaryHost);
        } else {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, BOGUS_SERVER_NAME);
        }
    }

    @Override
    public ServerName randomAssignment(RegionInfo regionInfo, List<ServerName> servers) throws HBaseIOException {
        List<ServerName> onlineServers;
        if (servers != null && servers.contains(this.masterServerName)) {
            if (this.shouldBeOnMaster(regionInfo)) {
                this.metricsBalancer.incrMiscInvocations();
                return this.masterServerName;
            }
            if (!LoadBalancer.isTablesOnMaster(this.getConf())) {
                servers = new ArrayList<ServerName>(servers);
                servers.remove(this.masterServerName);
            }
        }
        ServerName destination = null;
        if (!FavoredNodesManager.isFavoredNodeApplicable(regionInfo)) {
            return super.randomAssignment(regionInfo, servers);
        }
        this.metricsBalancer.incrMiscInvocations();
        List<ServerName> favoredNodes = this.fnm.getFavoredNodes(regionInfo);
        if (favoredNodes == null || favoredNodes.isEmpty()) {
            FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.getConf());
            helper.initialize();
            try {
                favoredNodes = helper.generateFavoredNodes(regionInfo);
                this.updateFavoredNodesForRegion(regionInfo, favoredNodes);
            }
            catch (IOException e) {
                LOG.warn("Encountered exception while doing favored-nodes (random)assignment " + e);
                throw new HBaseIOException((Throwable)e);
            }
        }
        if ((onlineServers = this.getOnlineFavoredNodes(servers, favoredNodes)).size() > 0) {
            destination = onlineServers.get(RANDOM.nextInt(onlineServers.size()));
        }
        boolean alwaysAssign = this.getConf().getBoolean("hbase.favored.assignment.always.assign", true);
        if (destination == null && alwaysAssign) {
            LOG.warn("Can't generate FN for region: " + regionInfo + " falling back");
            destination = super.randomAssignment(regionInfo, servers);
        }
        return destination;
    }

    private void updateFavoredNodesForRegion(RegionInfo regionInfo, List<ServerName> newFavoredNodes) throws IOException {
        HashMap regionFNMap = Maps.newHashMap();
        regionFNMap.put(regionInfo, newFavoredNodes);
        this.fnm.updateFavoredNodes(regionFNMap);
    }

    @Override
    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
        HashMap assignmentMap = Maps.newHashMap();
        Map<ServerName, List<RegionInfo>> result = super.retainAssignment(regions, servers);
        if (result == null || result.isEmpty()) {
            LOG.warn("Nothing to assign to, probably no servers or no regions");
            return null;
        }
        if (servers != null && servers.contains(this.masterServerName)) {
            servers = new ArrayList<ServerName>(servers);
            servers.remove(this.masterServerName);
        }
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.getConf());
        helper.initialize();
        LOG.debug("Generating favored nodes for regions missing them.");
        HashMap regionFNMap = Maps.newHashMap();
        try {
            for (Map.Entry<ServerName, List<RegionInfo>> entry : result.entrySet()) {
                ServerName sn = entry.getKey();
                ServerName primary = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)-1L);
                for (RegionInfo hri : entry.getValue()) {
                    if (FavoredNodesManager.isFavoredNodeApplicable(hri)) {
                        List<ServerName> favoredNodes = this.fnm.getFavoredNodes(hri);
                        if (favoredNodes == null || favoredNodes.size() < 3) {
                            LOG.debug("Generating favored nodes for: " + hri + " with primary: " + primary);
                            ServerName[] secondaryAndTertiaryNodes = helper.getSecondaryAndTertiary(hri, primary);
                            if (secondaryAndTertiaryNodes != null && secondaryAndTertiaryNodes.length == 2) {
                                ArrayList newFavoredNodes = Lists.newArrayList();
                                newFavoredNodes.add(primary);
                                newFavoredNodes.add(ServerName.valueOf((String)secondaryAndTertiaryNodes[0].getHostname(), (int)secondaryAndTertiaryNodes[0].getPort(), (long)-1L));
                                newFavoredNodes.add(ServerName.valueOf((String)secondaryAndTertiaryNodes[1].getHostname(), (int)secondaryAndTertiaryNodes[1].getPort(), (long)-1L));
                                regionFNMap.put(hri, newFavoredNodes);
                                this.addRegionToMap(assignmentMap, hri, sn);
                                continue;
                            }
                            throw new HBaseIOException("Cannot generate secondary/tertiary FN for " + hri + " generated " + (secondaryAndTertiaryNodes != null ? secondaryAndTertiaryNodes : " nothing"));
                        }
                        List<ServerName> onlineFN = this.getOnlineFavoredNodes(servers, favoredNodes);
                        if (onlineFN.isEmpty()) {
                            this.addRegionToMap(assignmentMap, hri, BOGUS_SERVER_NAME);
                            continue;
                        }
                        if (FavoredNodesPlan.getFavoredServerPosition(favoredNodes, sn) != null) {
                            this.addRegionToMap(assignmentMap, hri, sn);
                            continue;
                        }
                        ServerName destination = onlineFN.get(RANDOM.nextInt(onlineFN.size()));
                        LOG.warn("Region: " + hri + " not hosted on favored nodes: " + favoredNodes + " current: " + sn + " moving to: " + destination);
                        this.addRegionToMap(assignmentMap, hri, destination);
                        continue;
                    }
                    this.addRegionToMap(assignmentMap, hri, sn);
                }
            }
            if (!regionFNMap.isEmpty()) {
                LOG.debug("Updating FN in meta for missing regions, count: " + regionFNMap.size());
                this.fnm.updateFavoredNodes(regionFNMap);
            }
        }
        catch (IOException e) {
            throw new HBaseIOException("Cannot generate/update FN for regions: " + regionFNMap.keySet());
        }
        return assignmentMap;
    }

    private List<ServerName> getOnlineFavoredNodes(List<ServerName> onlineServers, List<ServerName> serversWithoutStartCodes) {
        if (serversWithoutStartCodes == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (ServerName sn : serversWithoutStartCodes) {
            for (ServerName online : onlineServers) {
                if (!ServerName.isSameAddress((ServerName)sn, (ServerName)online)) continue;
                result.add(online);
            }
        }
        return result;
    }

    public synchronized List<ServerName> getFavoredNodes(RegionInfo regionInfo) {
        return this.fnm.getFavoredNodes(regionInfo);
    }

    @Override
    public void generateFavoredNodesForDaughter(List<ServerName> servers, RegionInfo parent, RegionInfo regionA, RegionInfo regionB) throws IOException {
        HashMap<RegionInfo, List<ServerName>> result = new HashMap<RegionInfo, List<ServerName>>();
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.rackManager);
        helper.initialize();
        List<ServerName> parentFavoredNodes = this.fnm.getFavoredNodes(parent);
        if (parentFavoredNodes == null) {
            LOG.debug("Unable to find favored nodes for parent, " + parent + " generating new favored nodes for daughter");
            result.put(regionA, helper.generateFavoredNodes(regionA));
            result.put(regionB, helper.generateFavoredNodes(regionB));
        } else {
            Set<ServerName> regionAFN = this.getInheritedFNForDaughter(helper, parentFavoredNodes, FavoredNodesPlan.Position.PRIMARY, FavoredNodesPlan.Position.SECONDARY);
            result.put(regionA, Lists.newArrayList(regionAFN));
            Set<ServerName> regionBFN = this.getInheritedFNForDaughter(helper, parentFavoredNodes, FavoredNodesPlan.Position.PRIMARY, FavoredNodesPlan.Position.TERTIARY);
            result.put(regionB, Lists.newArrayList(regionBFN));
        }
        this.fnm.updateFavoredNodes(result);
    }

    private Set<ServerName> getInheritedFNForDaughter(FavoredNodeAssignmentHelper helper, List<ServerName> parentFavoredNodes, FavoredNodesPlan.Position primary, FavoredNodesPlan.Position secondary) throws IOException {
        LinkedHashSet daughterFN = Sets.newLinkedHashSet();
        if (parentFavoredNodes.size() >= primary.ordinal()) {
            daughterFN.add(parentFavoredNodes.get(primary.ordinal()));
        }
        if (parentFavoredNodes.size() >= secondary.ordinal()) {
            daughterFN.add(parentFavoredNodes.get(secondary.ordinal()));
        }
        while (daughterFN.size() < 3) {
            ServerName newNode = helper.generateMissingFavoredNode(Lists.newArrayList((Iterable)daughterFN));
            daughterFN.add(newNode);
        }
        return daughterFN;
    }

    @Override
    public void generateFavoredNodesForMergedRegion(RegionInfo merged, RegionInfo[] mergeParents) throws IOException {
        this.updateFavoredNodesForRegion(merged, this.fnm.getFavoredNodes(mergeParents[0]));
    }

    @Override
    public synchronized List<RegionPlan> balanceTable(TableName tableName, Map<ServerName, List<RegionInfo>> loadOfOneTable) {
        if (this.services != null) {
            ArrayList regionPlans = Lists.newArrayList();
            HashMap<ServerName, List<RegionInfo>> correctAssignments = new HashMap<ServerName, List<RegionInfo>>();
            int misplacedRegions = 0;
            for (Map.Entry<ServerName, List<RegionInfo>> entry : loadOfOneTable.entrySet()) {
                ServerName current = entry.getKey();
                ArrayList regions = Lists.newArrayList();
                correctAssignments.put(current, regions);
                for (RegionInfo hri : entry.getValue()) {
                    List<ServerName> favoredNodes = this.fnm.getFavoredNodes(hri);
                    if (FavoredNodesPlan.getFavoredServerPosition(favoredNodes, current) != null || !FavoredNodesManager.isFavoredNodeApplicable(hri)) {
                        regions.add(hri);
                        continue;
                    }
                    LOG.warn("Region not on favored nodes, unassign. Region: " + hri + " current: " + current + " favored nodes: " + favoredNodes);
                    try {
                        this.services.getAssignmentManager().unassign(hri);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed unassign", (Throwable)e);
                        continue;
                    }
                    RegionPlan rp = new RegionPlan(hri, null, null);
                    regionPlans.add(rp);
                    ++misplacedRegions;
                }
            }
            LOG.debug("Found misplaced regions: " + misplacedRegions + ", not on favored nodes.");
            List<RegionPlan> regionPlansFromBalance = super.balanceTable(tableName, correctAssignments);
            if (regionPlansFromBalance != null) {
                regionPlans.addAll(regionPlansFromBalance);
            }
            return regionPlans;
        }
        return super.balanceTable(tableName, loadOfOneTable);
    }

    class FavoredNodeLoadPicker
    extends StochasticLoadBalancer.CandidateGenerator {
        FavoredNodeLoadPicker() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int otherServer;
            cluster.sortServersByRegionCount();
            int thisServer = this.pickMostLoadedServer(cluster);
            int thisRegion = this.pickRandomRegion(cluster, thisServer, 0.0);
            RegionInfo hri = cluster.regions[thisRegion];
            List<ServerName> favoredNodes = FavoredStochasticBalancer.this.fnm.getFavoredNodes(hri);
            if (favoredNodes == null) {
                if (FavoredNodesManager.isFavoredNodeApplicable(hri)) return BaseLoadBalancer.Cluster.NullAction;
                otherServer = this.pickLeastLoadedServer(cluster, thisServer);
                return this.getAction(thisServer, thisRegion, otherServer, -1);
            } else {
                otherServer = this.pickLeastLoadedFNServer(cluster, favoredNodes, thisServer);
            }
            return this.getAction(thisServer, thisRegion, otherServer, -1);
        }

        private int pickLeastLoadedServer(BaseLoadBalancer.Cluster cluster, int thisServer) {
            int index;
            Integer[] servers = cluster.serverIndicesSortedByRegionCount;
            for (index = 0; index < servers.length && (servers[index] == null || servers[index] == thisServer); ++index) {
            }
            return servers[index];
        }

        private int pickLeastLoadedFNServer(BaseLoadBalancer.Cluster cluster, List<ServerName> favoredNodes, int currentServerIndex) {
            ArrayList<Integer> fnIndex = new ArrayList<Integer>();
            for (ServerName sn : favoredNodes) {
                if (!cluster.serversToIndex.containsKey(sn.getHostAndPort())) continue;
                fnIndex.add(cluster.serversToIndex.get(sn.getHostAndPort()));
            }
            int leastLoadedFN = -1;
            int load = Integer.MAX_VALUE;
            for (Integer index : fnIndex) {
                int temp;
                if (index == currentServerIndex || (temp = cluster.getNumRegions(index)) >= load) continue;
                load = temp;
                leastLoadedFN = index;
            }
            return leastLoadedFN;
        }

        private int pickMostLoadedServer(BaseLoadBalancer.Cluster cluster) {
            int index;
            Integer[] servers = cluster.serverIndicesSortedByRegionCount;
            for (index = servers.length - 1; index > 0 && servers[index] == null; --index) {
            }
            return servers[index];
        }
    }

    private class FavoredNodeLocalityPicker
    extends StochasticLoadBalancer.CandidateGenerator {
        private FavoredNodeLocalityPicker() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int otherServer;
            int thisServer = this.pickRandomServer(cluster);
            if (thisServer == -1) {
                LOG.trace("Could not pick lowest local region server");
                return BaseLoadBalancer.Cluster.NullAction;
            }
            int thisRegion = this.pickLowestLocalRegionOnServer(cluster, thisServer);
            if (thisRegion == -1) {
                if (cluster.regionsPerServer[thisServer].length <= 0) return BaseLoadBalancer.Cluster.NullAction;
                LOG.trace("Could not pick lowest local region even when region server held " + cluster.regionsPerServer[thisServer].length + " regions");
                return BaseLoadBalancer.Cluster.NullAction;
            }
            RegionInfo hri = cluster.regions[thisRegion];
            List<ServerName> favoredNodes = FavoredStochasticBalancer.this.fnm.getFavoredNodes(hri);
            if (favoredNodes != null) {
                otherServer = this.getDifferentFavoredNode(cluster, favoredNodes, thisServer);
                return this.getAction(thisServer, thisRegion, otherServer, -1);
            }
            if (!FavoredNodesManager.isFavoredNodeApplicable(hri)) {
                otherServer = this.pickOtherRandomServer(cluster, thisServer);
                return this.getAction(thisServer, thisRegion, otherServer, -1);
            }
            LOG.trace("Ignoring, no favored nodes for region: " + hri);
            return BaseLoadBalancer.Cluster.NullAction;
        }

        private int getDifferentFavoredNode(BaseLoadBalancer.Cluster cluster, List<ServerName> favoredNodes, int currentServer) {
            ArrayList<Integer> fnIndex = new ArrayList<Integer>();
            for (ServerName sn : favoredNodes) {
                if (!cluster.serversToIndex.containsKey(sn.getHostAndPort())) continue;
                fnIndex.add(cluster.serversToIndex.get(sn.getHostAndPort()));
            }
            float locality = 0.0f;
            int highestLocalRSIndex = -1;
            for (Integer index : fnIndex) {
                float temp;
                if (index == currentServer || !((temp = cluster.localityPerServer[index]) >= locality)) continue;
                locality = temp;
                highestLocalRSIndex = index;
            }
            return highestLocalRSIndex;
        }

        private int pickLowestLocalRegionOnServer(BaseLoadBalancer.Cluster cluster, int server) {
            return cluster.getLowestLocalityRegionOnServer(server);
        }
    }
}

