/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.io.HiveContextAwareRecordReader;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveRecordReader;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.DelegatedObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class FetchOperator
implements Serializable {
    static Log LOG = LogFactory.getLog((String)FetchOperator.class.getName());
    static SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private boolean isNativeTable;
    private FetchWork work;
    protected Operator<?> operator;
    private int splitNum;
    private PartitionDesc currPart;
    private TableDesc currTbl;
    private boolean tblDataDone;
    private boolean hasVC;
    private boolean isPartitioned;
    private StructObjectInspector vcsOI;
    private List<VirtualColumn> vcCols;
    private ExecMapperContext context;
    private transient RecordReader<WritableComparable, Writable> currRecReader;
    private transient FetchInputFormatSplit[] inputSplits;
    private transient InputFormat inputFormat;
    private transient JobConf job;
    private transient WritableComparable key;
    private transient Writable value;
    private transient Writable[] vcValues;
    private transient Deserializer serde;
    private transient Deserializer tblSerde;
    private transient ObjectInspectorConverters.Converter partTblObjectInspectorConverter;
    private transient Iterator<Path> iterPath;
    private transient Iterator<PartitionDesc> iterPartDesc;
    private transient Path currPath;
    private transient StructObjectInspector objectInspector;
    private transient StructObjectInspector rowObjectInspector;
    private transient ObjectInspector partitionedTableOI;
    private transient Object[] row;
    private static Map<Class, InputFormat<WritableComparable, Writable>> inputFormats = new HashMap<Class, InputFormat<WritableComparable, Writable>>();
    private final transient InspectableObject inspectable = new InspectableObject();

    public FetchOperator() {
    }

    public FetchOperator(FetchWork work, JobConf job) {
        this.job = job;
        this.work = work;
        this.initialize();
    }

    public FetchOperator(FetchWork work, JobConf job, Operator<?> operator, List<VirtualColumn> vcCols) {
        this.job = job;
        this.work = work;
        this.operator = operator;
        this.vcCols = vcCols;
        this.initialize();
    }

    private void initialize() {
        this.hasVC = this.vcCols != null && !this.vcCols.isEmpty();
        if (this.hasVC) {
            ArrayList<String> names = new ArrayList<String>(this.vcCols.size());
            ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>(this.vcCols.size());
            for (VirtualColumn vc : this.vcCols) {
                inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(vc.getTypeInfo()));
                names.add(vc.getName());
            }
            this.vcsOI = ObjectInspectorFactory.getStandardStructObjectInspector(names, inspectors);
            this.vcValues = new Writable[this.vcCols.size()];
        }
        this.isPartitioned = this.work.isPartitioned();
        this.tblDataDone = false;
        this.row = this.hasVC && this.isPartitioned ? new Object[3] : (this.hasVC || this.isPartitioned ? new Object[2] : new Object[1]);
        this.isNativeTable = this.work.getTblDesc() != null ? !this.work.getTblDesc().isNonNative() : true;
        this.setupExecContext();
    }

    private void setupExecContext() {
        if (this.hasVC || this.work.getSplitSample() != null) {
            this.context = new ExecMapperContext();
            if (this.operator != null) {
                this.operator.setExecContext(this.context);
            }
        }
    }

    public FetchWork getWork() {
        return this.work;
    }

    public void setWork(FetchWork work) {
        this.work = work;
    }

    public int getSplitNum() {
        return this.splitNum;
    }

    public void setSplitNum(int splitNum) {
        this.splitNum = splitNum;
    }

    public PartitionDesc getCurrPart() {
        return this.currPart;
    }

    public void setCurrPart(PartitionDesc currPart) {
        this.currPart = currPart;
    }

    public TableDesc getCurrTbl() {
        return this.currTbl;
    }

    public void setCurrTbl(TableDesc currTbl) {
        this.currTbl = currTbl;
    }

    public boolean isTblDataDone() {
        return this.tblDataDone;
    }

    public void setTblDataDone(boolean tblDataDone) {
        this.tblDataDone = tblDataDone;
    }

    public boolean isEmptyTable() {
        return this.work.getTblDir() == null && (this.work.getPartDir() == null || this.work.getPartDir().isEmpty());
    }

    static InputFormat<WritableComparable, Writable> getInputFormatFromCache(Class inputFormatClass, Configuration conf) throws IOException {
        if (!inputFormats.containsKey(inputFormatClass)) {
            try {
                InputFormat newInstance = (InputFormat)ReflectionUtils.newInstance((Class)inputFormatClass, (Configuration)conf);
                inputFormats.put(inputFormatClass, (InputFormat<WritableComparable, Writable>)newInstance);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputFormat class " + inputFormatClass.getName() + " as specified in mapredWork!", e);
            }
        }
        return inputFormats.get(inputFormatClass);
    }

    private StructObjectInspector getRowInspectorFromTable(TableDesc table) throws Exception {
        Deserializer serde = table.getDeserializerClass().newInstance();
        serde.initialize((Configuration)this.job, table.getProperties());
        return this.createRowInspector(this.getStructOIFrom(serde.getObjectInspector()));
    }

    private StructObjectInspector getRowInspectorFromPartition(PartitionDesc partition, ObjectInspector partitionOI) throws Exception {
        String pcols = partition.getTableDesc().getProperties().getProperty("partition_columns");
        String[] partKeys = pcols.trim().split("/");
        this.row[1] = this.createPartValue(partKeys, partition.getPartSpec());
        return this.createRowInspector(this.getStructOIFrom(partitionOI), partKeys);
    }

    private StructObjectInspector getRowInspectorFromPartitionedTable(TableDesc table) throws Exception {
        Deserializer serde = table.getDeserializerClass().newInstance();
        serde.initialize((Configuration)this.job, table.getProperties());
        String pcols = table.getProperties().getProperty("partition_columns");
        String[] partKeys = pcols.trim().split("/");
        this.row[1] = null;
        return this.createRowInspector(this.getStructOIFrom(serde.getObjectInspector()), partKeys);
    }

    private StructObjectInspector getStructOIFrom(ObjectInspector current) throws SerDeException {
        current = this.objectInspector != null ? DelegatedObjectInspectorFactory.reset(this.objectInspector, current) : DelegatedObjectInspectorFactory.wrap(current);
        this.objectInspector = (StructObjectInspector)current;
        return this.objectInspector;
    }

    private StructObjectInspector createRowInspector(StructObjectInspector current) throws SerDeException {
        return this.hasVC ? ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(current, this.vcsOI)) : current;
    }

    private StructObjectInspector createRowInspector(StructObjectInspector current, String[] partKeys) throws SerDeException {
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>();
        for (String key : partKeys) {
            partNames.add(key);
            partObjectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        return ObjectInspectorFactory.getUnionStructObjectInspector(this.hasVC ? Arrays.asList(current, partObjectInspector, this.vcsOI) : Arrays.asList(current, partObjectInspector));
    }

    private List<String> createPartValue(String[] partKeys, Map<String, String> partSpec) {
        ArrayList<String> partValues = new ArrayList<String>();
        for (String key : partKeys) {
            partValues.add(partSpec.get(key));
        }
        return partValues;
    }

    private void getNextPath() throws Exception {
        if (this.iterPath == null) {
            if (this.work.isNotPartitioned()) {
                if (!this.tblDataDone) {
                    this.currPath = this.work.getTblDirPath();
                    this.currTbl = this.work.getTblDesc();
                    if (this.isNativeTable) {
                        FileSystem fs = this.currPath.getFileSystem((Configuration)this.job);
                        if (fs.exists(this.currPath)) {
                            FileStatus[] fStats;
                            for (FileStatus fStat : fStats = this.listStatusUnderPath(fs, this.currPath)) {
                                if (fStat.getLen() <= 0L) continue;
                                this.tblDataDone = true;
                                break;
                            }
                        }
                    } else {
                        this.tblDataDone = true;
                    }
                    if (!this.tblDataDone) {
                        this.currPath = null;
                    }
                    return;
                }
                this.currTbl = null;
                this.currPath = null;
                return;
            }
            this.iterPath = FetchWork.convertStringToPathArray(this.work.getPartDir()).iterator();
            this.iterPartDesc = this.work.getPartDesc().iterator();
        }
        while (this.iterPath.hasNext()) {
            FileStatus[] fStats;
            FileSystem fs;
            Path nxt = this.iterPath.next();
            PartitionDesc prt = null;
            if (this.iterPartDesc != null) {
                prt = this.iterPartDesc.next();
            }
            if (!(fs = nxt.getFileSystem((Configuration)this.job)).exists(nxt)) continue;
            for (FileStatus fStat : fStats = this.listStatusUnderPath(fs, nxt)) {
                if (fStat.getLen() <= 0L) continue;
                this.currPath = nxt;
                if (this.iterPartDesc != null) {
                    this.currPart = prt;
                }
                return;
            }
        }
    }

    private RecordReader<WritableComparable, Writable> getRecordReader() throws Exception {
        if (this.currPath == null) {
            this.getNextPath();
            if (this.currPath == null) {
                return null;
            }
            this.job.set("mapred.input.dir", StringUtils.escapeString((String)this.currPath.toString()));
            PartitionDesc partDesc = this.currTbl == null ? this.currPart : new PartitionDesc(this.currTbl, null);
            Class<? extends InputFormat> formatter = partDesc.getInputFileFormatClass();
            this.inputFormat = FetchOperator.getInputFormatFromCache(formatter, (Configuration)this.job);
            Utilities.copyTableJobPropertiesToConf(partDesc.getTableDesc(), this.job);
            InputSplit[] splits = this.inputFormat.getSplits(this.job, 1);
            FetchInputFormatSplit[] inputSplits = new FetchInputFormatSplit[splits.length];
            for (int i = 0; i < splits.length; ++i) {
                inputSplits[i] = new FetchInputFormatSplit(splits[i], formatter.getName());
            }
            if (this.work.getSplitSample() != null) {
                inputSplits = this.splitSampling(this.work.getSplitSample(), inputSplits);
            }
            this.inputSplits = inputSplits;
            this.splitNum = 0;
            this.serde = partDesc.getDeserializerClass().newInstance();
            this.serde.initialize((Configuration)this.job, partDesc.getOverlayedProperties());
            if (this.currTbl != null) {
                this.tblSerde = this.serde;
            } else {
                this.tblSerde = this.currPart.getTableDesc().getDeserializerClass().newInstance();
                this.tblSerde.initialize((Configuration)this.job, this.currPart.getTableDesc().getProperties());
            }
            ObjectInspector outputOI = ObjectInspectorConverters.getConvertedOI(this.serde.getObjectInspector(), this.partitionedTableOI == null ? this.tblSerde.getObjectInspector() : this.partitionedTableOI, true);
            this.partTblObjectInspectorConverter = ObjectInspectorConverters.getConverter(this.serde.getObjectInspector(), outputOI);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating fetchTask with deserializer typeinfo: " + this.serde.getObjectInspector().getTypeName()));
                LOG.debug((Object)("deserializer properties: " + partDesc.getOverlayedProperties()));
            }
            if (this.currPart != null) {
                this.getRowInspectorFromPartition(this.currPart, outputOI);
            }
        }
        if (this.splitNum >= this.inputSplits.length) {
            if (this.currRecReader != null) {
                this.currRecReader.close();
                this.currRecReader = null;
            }
            this.currPath = null;
            return this.getRecordReader();
        }
        final FetchInputFormatSplit target = this.inputSplits[this.splitNum];
        RecordReader reader = this.inputFormat.getRecordReader(target.getInputSplit(), this.job, Reporter.NULL);
        if (this.hasVC || this.work.getSplitSample() != null) {
            this.currRecReader = new HiveRecordReader<WritableComparable, Writable>(reader, this.job){

                @Override
                public boolean doNext(WritableComparable key, Writable value) throws IOException {
                    if (target.shrinkedLength > 0L && FetchOperator.this.context.getIoCxt().getCurrentBlockStart() > target.shrinkedLength) {
                        return false;
                    }
                    return super.doNext(key, value);
                }
            };
            ((HiveContextAwareRecordReader)this.currRecReader).initIOContext(target, this.job, this.inputFormat.getClass(), reader);
        } else {
            this.currRecReader = reader;
        }
        ++this.splitNum;
        this.key = (WritableComparable)this.currRecReader.createKey();
        this.value = (Writable)this.currRecReader.createValue();
        return this.currRecReader;
    }

    private FetchInputFormatSplit[] splitSampling(SplitSample splitSample, FetchInputFormatSplit[] splits) {
        long totalSize = 0L;
        for (FetchInputFormatSplit split : splits) {
            totalSize += split.getLength();
        }
        ArrayList<FetchInputFormatSplit> result = new ArrayList<FetchInputFormatSplit>();
        long targetSize = splitSample.getTargetSize(totalSize);
        int startIndex = splitSample.getSeedNum() % splits.length;
        long size = 0L;
        for (int i = 0; i < splits.length; ++i) {
            FetchInputFormatSplit split = splits[(startIndex + i) % splits.length];
            result.add(split);
            long splitgLength = split.getLength();
            if (size + splitgLength >= targetSize) {
                if (size + splitgLength <= targetSize) break;
                split.shrinkedLength = targetSize - size;
                break;
            }
            size += splitgLength;
        }
        return result.toArray(new FetchInputFormatSplit[result.size()]);
    }

    public boolean pushRow() throws IOException, HiveException {
        InspectableObject row = this.getNextRow();
        if (row != null) {
            this.pushRow(row);
        } else {
            this.operator.flush();
        }
        return row != null;
    }

    protected void pushRow(InspectableObject row) throws HiveException {
        this.operator.process(row.o, 0);
    }

    public InspectableObject getNextRow() throws IOException {
        try {
            while (true) {
                boolean ret;
                if (this.context != null) {
                    this.context.resetRow();
                }
                if (this.currRecReader == null) {
                    this.currRecReader = this.getRecordReader();
                    if (this.currRecReader == null) {
                        return null;
                    }
                }
                if (ret = this.currRecReader.next((Object)this.key, (Object)this.value)) {
                    if (this.operator != null && this.context != null && this.context.inputFileChanged()) {
                        try {
                            this.operator.cleanUpInputFileChanged();
                        }
                        catch (HiveException e) {
                            throw new IOException(e);
                        }
                    }
                    if (this.hasVC) {
                        this.vcValues = MapOperator.populateVirtualColumnValues(this.context, this.vcCols, this.vcValues, this.serde);
                        this.row[this.isPartitioned ? 2 : 1] = this.vcValues;
                    }
                    this.row[0] = this.partTblObjectInspectorConverter.convert(this.serde.deserialize(this.value));
                    if (this.hasVC || this.isPartitioned) {
                        this.inspectable.o = this.row;
                        this.inspectable.oi = this.rowObjectInspector;
                        return this.inspectable;
                    }
                    this.inspectable.o = this.row[0];
                    this.inspectable.oi = this.tblSerde.getObjectInspector();
                    return this.inspectable;
                }
                this.currRecReader.close();
                this.currRecReader = null;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void clearFetchContext() throws HiveException {
        try {
            if (this.currRecReader != null) {
                this.currRecReader.close();
                this.currRecReader = null;
            }
            if (this.operator != null) {
                this.operator.close(false);
                this.operator = null;
            }
            if (this.context != null) {
                this.context.clear();
                this.context = null;
            }
            this.currTbl = null;
            this.currPath = null;
            this.iterPath = null;
            this.iterPartDesc = null;
        }
        catch (Exception e) {
            throw new HiveException("Failed with exception " + e.getMessage() + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void setupContext(List<Path> paths) {
        this.iterPath = paths.iterator();
        if (this.work.isNotPartitioned()) {
            this.currTbl = this.work.getTblDesc();
        } else {
            this.iterPartDesc = this.work.getPartDescs(paths).iterator();
        }
        this.setupExecContext();
    }

    public ObjectInspector getOutputObjectInspector() throws HiveException {
        try {
            if (this.work.isNotPartitioned()) {
                StructObjectInspector structObjectInspector = this.getRowInspectorFromTable(this.work.getTblDesc());
                return structObjectInspector;
            }
            ArrayList<PartitionDesc> listParts = this.work.getPartDesc();
            if (listParts == null || listParts.isEmpty()) {
                StructObjectInspector structObjectInspector = this.getRowInspectorFromPartitionedTable(this.work.getTblDesc());
                return structObjectInspector;
            }
            PartitionDesc partition = (PartitionDesc)listParts.get(0);
            Deserializer tblSerde = partition.getTableDesc().getDeserializerClass().newInstance();
            tblSerde.initialize((Configuration)this.job, partition.getTableDesc().getProperties());
            this.partitionedTableOI = null;
            ObjectInspector tableOI = tblSerde.getObjectInspector();
            Iterator i$ = listParts.iterator();
            while (i$.hasNext()) {
                PartitionDesc listPart;
                partition = listPart = (PartitionDesc)i$.next();
                Deserializer partSerde = listPart.getDeserializerClass().newInstance();
                partSerde.initialize((Configuration)this.job, listPart.getOverlayedProperties());
                this.partitionedTableOI = ObjectInspectorConverters.getConvertedOI(partSerde.getObjectInspector(), tableOI, true);
                if (this.partitionedTableOI.equals(tableOI)) continue;
                break;
            }
            StructObjectInspector structObjectInspector = this.getRowInspectorFromPartition(partition, this.partitionedTableOI);
            return structObjectInspector;
        }
        catch (Exception e) {
            throw new HiveException("Failed with exception " + e.getMessage() + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            this.currPart = null;
        }
    }

    private FileStatus[] listStatusUnderPath(FileSystem fs, Path p) throws IOException {
        boolean recursive = HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.HADOOPMAPREDINPUTDIRRECURSIVE);
        if (!recursive) {
            return fs.listStatus(p);
        }
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (FileStatus stat : fs.listStatus(p)) {
            FileUtils.listStatusRecursively(fs, stat, results);
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    private static class FetchInputFormatSplit
    extends HiveInputFormat.HiveInputSplit {
        private long shrinkedLength = -1L;

        public FetchInputFormatSplit(InputSplit split, String name) {
            super(split, name);
        }
    }
}

