/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.apache.hadoop.hive.ql.io.orc.InStream;

final class SerializationUtils {
    private SerializationUtils() {
    }

    static void writeVulong(OutputStream output, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.write((byte)value);
                return;
            }
            output.write((byte)(0x80L | value & 0x7FL));
            value >>>= 7;
        }
    }

    static void writeVslong(OutputStream output, long value) throws IOException {
        SerializationUtils.writeVulong(output, value << 1 ^ value >> 63);
    }

    static long readVulong(InputStream in) throws IOException {
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)in.read()) == -1L) {
                throw new EOFException("Reading Vulong past EOF");
            }
            result |= (0x7FL & b) << offset;
            offset += 7;
        } while (b >= 128L);
        return result;
    }

    static long readVslong(InputStream in) throws IOException {
        long result = SerializationUtils.readVulong(in);
        return result >>> 1 ^ -(result & 1L);
    }

    static float readFloat(InputStream in) throws IOException {
        int ser = in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
        return Float.intBitsToFloat(ser);
    }

    static void writeFloat(OutputStream output, float value) throws IOException {
        int ser = Float.floatToIntBits(value);
        output.write(ser & 0xFF);
        output.write(ser >> 8 & 0xFF);
        output.write(ser >> 16 & 0xFF);
        output.write(ser >> 24 & 0xFF);
    }

    static double readDouble(InputStream in) throws IOException {
        long ser = (long)in.read() | (long)in.read() << 8 | (long)in.read() << 16 | (long)in.read() << 24 | (long)in.read() << 32 | (long)in.read() << 40 | (long)in.read() << 48 | (long)in.read() << 56;
        return Double.longBitsToDouble(ser);
    }

    static void writeDouble(OutputStream output, double value) throws IOException {
        long ser = Double.doubleToLongBits(value);
        output.write((int)ser & 0xFF);
        output.write((int)(ser >> 8) & 0xFF);
        output.write((int)(ser >> 16) & 0xFF);
        output.write((int)(ser >> 24) & 0xFF);
        output.write((int)(ser >> 32) & 0xFF);
        output.write((int)(ser >> 40) & 0xFF);
        output.write((int)(ser >> 48) & 0xFF);
        output.write((int)(ser >> 56) & 0xFF);
    }

    static void writeBigInteger(OutputStream output, BigInteger value) throws IOException {
        int sign = (value = value.shiftLeft(1)).signum();
        if (sign < 0) {
            value = value.negate();
            value = value.subtract(BigInteger.ONE);
        }
        int length = value.bitLength();
        while (true) {
            long lowBits = value.longValue() & Long.MAX_VALUE;
            length -= 63;
            for (int i = 0; i < 9; ++i) {
                if (length <= 0 && (lowBits & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    output.write((byte)lowBits);
                    return;
                }
                output.write((byte)(0x80L | lowBits & 0x7FL));
                lowBits >>>= 7;
            }
            value = value.shiftRight(63);
        }
    }

    static BigInteger readBigInteger(InputStream input) throws IOException {
        boolean isNegative;
        long b;
        BigInteger result = BigInteger.ZERO;
        long work = 0L;
        int offset = 0;
        do {
            if ((b = (long)input.read()) == -1L) {
                throw new EOFException("Reading BigInteger past EOF from " + input);
            }
            work |= (0x7FL & b) << offset % 63;
            if ((offset += 7) == 63) {
                result = BigInteger.valueOf(work);
                work = 0L;
                continue;
            }
            if (offset % 63 != 0) continue;
            result = result.or(BigInteger.valueOf(work).shiftLeft(offset - 63));
            work = 0L;
        } while (b >= 128L);
        if (work != 0L) {
            result = result.or(BigInteger.valueOf(work).shiftLeft(offset / 63 * 63));
        }
        if (isNegative = result.testBit(0)) {
            result = result.add(BigInteger.ONE);
            result = result.negate();
        }
        result = result.shiftRight(1);
        return result;
    }

    static int findClosestNumBits(long value) {
        int count = 0;
        while (value > 0L) {
            ++count;
            value >>>= 1;
        }
        return SerializationUtils.getClosestFixedBits(count);
    }

    static long zigzagEncode(long val) {
        return val << 1 ^ val >> 63;
    }

    static long zigzagDecode(long val) {
        return val >>> 1 ^ -(val & 1L);
    }

    static int percentileBits(long[] data, double p) {
        if (p > 1.0 || p <= 0.0) {
            return -1;
        }
        int[] hist = new int[32];
        for (long l : data) {
            int idx;
            int n = idx = SerializationUtils.encodeBitWidth(SerializationUtils.findClosestNumBits(l));
            hist[n] = hist[n] + 1;
        }
        int len = data.length;
        int perLen = (int)((double)len * (1.0 - p));
        for (int i = hist.length - 1; i >= 0; --i) {
            if ((perLen -= hist[i]) >= 0) continue;
            return SerializationUtils.decodeBitWidth(i);
        }
        return 0;
    }

    static long bytesToLongBE(InStream input, int n) throws IOException {
        long out = 0L;
        long val = 0L;
        while (n > 0) {
            val = input.read();
            out |= val << --n * 8;
        }
        return out;
    }

    static int getTotalBytesRequired(int n, int numBits) {
        return (n * numBits + 7) / 8;
    }

    static int getClosestFixedBits(int n) {
        if (n == 0) {
            return 1;
        }
        if (n >= 1 && n <= 24) {
            return n;
        }
        if (n > 24 && n <= 26) {
            return 26;
        }
        if (n > 26 && n <= 28) {
            return 28;
        }
        if (n > 28 && n <= 30) {
            return 30;
        }
        if (n > 30 && n <= 32) {
            return 32;
        }
        if (n > 32 && n <= 40) {
            return 40;
        }
        if (n > 40 && n <= 48) {
            return 48;
        }
        if (n > 48 && n <= 56) {
            return 56;
        }
        return 64;
    }

    static int encodeBitWidth(int n) {
        if ((n = SerializationUtils.getClosestFixedBits(n)) >= 1 && n <= 24) {
            return n - 1;
        }
        if (n > 24 && n <= 26) {
            return FixedBitSizes.TWENTYSIX.ordinal();
        }
        if (n > 26 && n <= 28) {
            return FixedBitSizes.TWENTYEIGHT.ordinal();
        }
        if (n > 28 && n <= 30) {
            return FixedBitSizes.THIRTY.ordinal();
        }
        if (n > 30 && n <= 32) {
            return FixedBitSizes.THIRTYTWO.ordinal();
        }
        if (n > 32 && n <= 40) {
            return FixedBitSizes.FORTY.ordinal();
        }
        if (n > 40 && n <= 48) {
            return FixedBitSizes.FORTYEIGHT.ordinal();
        }
        if (n > 48 && n <= 56) {
            return FixedBitSizes.FIFTYSIX.ordinal();
        }
        return FixedBitSizes.SIXTYFOUR.ordinal();
    }

    static int decodeBitWidth(int n) {
        if (n >= FixedBitSizes.ONE.ordinal() && n <= FixedBitSizes.TWENTYFOUR.ordinal()) {
            return n + 1;
        }
        if (n == FixedBitSizes.TWENTYSIX.ordinal()) {
            return 26;
        }
        if (n == FixedBitSizes.TWENTYEIGHT.ordinal()) {
            return 28;
        }
        if (n == FixedBitSizes.THIRTY.ordinal()) {
            return 30;
        }
        if (n == FixedBitSizes.THIRTYTWO.ordinal()) {
            return 32;
        }
        if (n == FixedBitSizes.FORTY.ordinal()) {
            return 40;
        }
        if (n == FixedBitSizes.FORTYEIGHT.ordinal()) {
            return 48;
        }
        if (n == FixedBitSizes.FIFTYSIX.ordinal()) {
            return 56;
        }
        return 64;
    }

    static void writeInts(long[] input, int offset, int len, int bitSize, OutputStream output) throws IOException {
        if (input == null || input.length < 1 || offset < 0 || len < 1 || bitSize < 1) {
            return;
        }
        int bitsLeft = 8;
        int current = 0;
        for (int i = offset; i < offset + len; ++i) {
            long value = input[i];
            int bitsToWrite = bitSize;
            while (bitsToWrite > bitsLeft) {
                current = (byte)((long)current | value >>> bitsToWrite - bitsLeft);
                value &= (1L << (bitsToWrite -= bitsLeft)) - 1L;
                output.write(current);
                current = 0;
                bitsLeft = 8;
            }
            current = (byte)((long)current | value << (bitsLeft -= bitsToWrite));
            if (bitsLeft != 0) continue;
            output.write(current);
            current = 0;
            bitsLeft = 8;
        }
        if (bitsLeft != 8) {
            output.write(current);
            current = 0;
            bitsLeft = 8;
        }
    }

    static void readInts(long[] buffer, int offset, int len, int bitSize, InStream input) throws IOException {
        int bitsLeft = 0;
        int current = 0;
        for (int i = offset; i < offset + len; ++i) {
            int bitsLeftToRead;
            long result = 0L;
            for (bitsLeftToRead = bitSize; bitsLeftToRead > bitsLeft; bitsLeftToRead -= bitsLeft) {
                result <<= bitsLeft;
                result |= (long)(current & (1 << bitsLeft) - 1);
                current = input.read();
                bitsLeft = 8;
            }
            if (bitsLeftToRead > 0) {
                result <<= bitsLeftToRead;
                result |= (long)(current >> (bitsLeft -= bitsLeftToRead) & (1 << bitsLeftToRead) - 1);
            }
            buffer[i] = result;
        }
    }

    static enum FixedBitSizes {
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        SEVEN,
        EIGHT,
        NINE,
        TEN,
        ELEVEN,
        TWELVE,
        THIRTEEN,
        FOURTEEN,
        FIFTEEN,
        SIXTEEN,
        SEVENTEEN,
        EIGHTEEN,
        NINETEEN,
        TWENTY,
        TWENTYONE,
        TWENTYTWO,
        TWENTYTHREE,
        TWENTYFOUR,
        TWENTYSIX,
        TWENTYEIGHT,
        THIRTY,
        THIRTYTWO,
        FORTY,
        FORTYEIGHT,
        FIFTYSIX,
        SIXTYFOUR;

    }
}

