/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.AbstractBucketJoinProc;
import org.apache.hadoop.hive.ql.optimizer.BucketJoinProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class BucketMapjoinProc
extends AbstractBucketJoinProc
implements NodeProcessor {
    public BucketMapjoinProc(ParseContext pGraphContext) {
        super(pGraphContext);
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        BucketJoinProcCtx context = (BucketJoinProcCtx)procCtx;
        MapJoinOperator mapJoinOperator = (MapJoinOperator)nd;
        boolean convert = this.canConvertMapJoinToBucketMapJoin(mapJoinOperator, this.pGraphContext, context);
        HiveConf conf = context.getConf();
        if (!convert && conf.getBoolVar(HiveConf.ConfVars.HIVEENFORCEBUCKETMAPJOIN)) {
            throw new SemanticException(ErrorMsg.BUCKET_MAPJOIN_NOT_POSSIBLE.getMsg());
        }
        if (convert) {
            this.convertMapJoinToBucketMapJoin(mapJoinOperator, context);
        }
        return null;
    }
}

