/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class RowResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RowSchema rowSchema = new RowSchema();
    private HashMap<String, LinkedHashMap<String, ColumnInfo>> rslvMap = new HashMap();
    private HashMap<String, String[]> invRslvMap = new HashMap();
    private Map<String, ASTNode> expressionMap = new HashMap<String, ASTNode>();
    private boolean isExprResolver = false;
    private static final Log LOG = LogFactory.getLog((String)RowResolver.class.getName());

    public void putExpression(ASTNode node, ColumnInfo colInfo) {
        String treeAsString = node.toStringTree();
        this.expressionMap.put(treeAsString, node);
        this.put("", treeAsString, colInfo);
    }

    public ColumnInfo getExpression(ASTNode node) throws SemanticException {
        return this.get("", node.toStringTree());
    }

    public ASTNode getExpressionSource(ASTNode node) {
        return this.expressionMap.get(node.toStringTree());
    }

    public void put(String tab_alias, String col_alias, ColumnInfo colInfo) {
        if (tab_alias != null) {
            tab_alias = tab_alias.toLowerCase();
        }
        col_alias = col_alias.toLowerCase();
        if (this.rowSchema.getSignature() == null) {
            this.rowSchema.setSignature(new ArrayList<ColumnInfo>());
        }
        this.rowSchema.getSignature().add(colInfo);
        LinkedHashMap<String, ColumnInfo> f_map = this.rslvMap.get(tab_alias);
        if (f_map == null) {
            f_map = new LinkedHashMap();
            this.rslvMap.put(tab_alias, f_map);
        }
        f_map.put(col_alias, colInfo);
        String[] qualifiedAlias = new String[]{tab_alias, col_alias};
        this.invRslvMap.put(colInfo.getInternalName(), qualifiedAlias);
    }

    public boolean hasTableAlias(String tab_alias) {
        return this.rslvMap.get(tab_alias.toLowerCase()) != null;
    }

    public ColumnInfo get(String tab_alias, String col_alias) throws SemanticException {
        col_alias = col_alias.toLowerCase();
        ColumnInfo ret = null;
        if (tab_alias != null) {
            HashMap f_map = this.rslvMap.get(tab_alias = tab_alias.toLowerCase());
            if (f_map == null) {
                return null;
            }
            ret = (ColumnInfo)f_map.get(col_alias);
        } else {
            boolean found = false;
            for (LinkedHashMap<String, ColumnInfo> cmap : this.rslvMap.values()) {
                for (Map.Entry<String, ColumnInfo> cmapEnt : cmap.entrySet()) {
                    if (!col_alias.equalsIgnoreCase(cmapEnt.getKey())) continue;
                    if (found) {
                        throw new SemanticException("Column " + col_alias + " Found in more than One Tables/Subqueries");
                    }
                    found = true;
                    ret = cmapEnt.getValue();
                }
            }
        }
        return ret;
    }

    public void checkColumn(String tableAlias, String columnAlias) throws SemanticException {
        ColumnInfo prev = this.get(null, columnAlias);
        if (!(prev == null || tableAlias != null && tableAlias.equalsIgnoreCase(prev.getTabAlias()))) {
            throw new SemanticException(ErrorMsg.AMBIGUOUS_COLUMN.getMsg(columnAlias));
        }
    }

    public ArrayList<ColumnInfo> getColumnInfos() {
        return this.rowSchema.getSignature();
    }

    public List<String> getReferenceableColumnAliases(String tableAlias, int max) {
        int count = 0;
        LinkedHashSet<Object> columnNames = new LinkedHashSet<Object>();
        int tables = this.rslvMap.size();
        Map mapping = this.rslvMap.get(tableAlias);
        if (mapping != null) {
            for (Map.Entry entry : mapping.entrySet()) {
                if (max <= 0 || count < max) {
                    ColumnInfo columnInfo = (ColumnInfo)entry.getValue();
                    if (columnInfo.isHiddenVirtualCol()) continue;
                    columnNames.add(entry.getKey());
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            for (ColumnInfo columnInfo : this.getColumnInfos()) {
                if (max <= 0 || count < max) {
                    String[] inverse;
                    if (columnInfo.isHiddenVirtualCol()) continue;
                    String[] stringArray = inverse = !this.isExprResolver ? this.reverseLookup(columnInfo.getInternalName()) : null;
                    if (inverse != null) {
                        columnNames.add(inverse[0] == null || tables <= 1 ? inverse[1] : inverse[0] + "." + inverse[1]);
                    } else {
                        columnNames.add(columnInfo.getAlias());
                    }
                    ++count;
                    continue;
                }
                break;
            }
        }
        return new ArrayList<String>(columnNames);
    }

    public HashMap<String, ColumnInfo> getFieldMap(String tabAlias) {
        if (tabAlias == null) {
            return this.rslvMap.get(null);
        }
        return this.rslvMap.get(tabAlias.toLowerCase());
    }

    public int getPosition(String internalName) {
        int pos = -1;
        for (ColumnInfo var : this.rowSchema.getSignature()) {
            ++pos;
            if (!var.getInternalName().equals(internalName)) continue;
            return pos;
        }
        return -1;
    }

    public Set<String> getTableNames() {
        return this.rslvMap.keySet();
    }

    public String[] reverseLookup(String internalName) {
        return this.invRslvMap.get(internalName);
    }

    public void setIsExprResolver(boolean isExprResolver) {
        this.isExprResolver = isExprResolver;
    }

    public boolean getIsExprResolver() {
        return this.isExprResolver;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, LinkedHashMap<String, ColumnInfo>> e : this.rslvMap.entrySet()) {
            String tab = e.getKey();
            sb.append(tab + "{");
            HashMap f_map = e.getValue();
            if (f_map != null) {
                for (Map.Entry entry : f_map.entrySet()) {
                    sb.append("(" + (String)entry.getKey() + "," + ((ColumnInfo)entry.getValue()).toString() + ")");
                }
            }
            sb.append("} ");
        }
        return sb.toString();
    }

    public RowSchema getRowSchema() {
        return this.rowSchema;
    }

    public HashMap<String, LinkedHashMap<String, ColumnInfo>> getRslvMap() {
        return this.rslvMap;
    }

    public HashMap<String, String[]> getInvRslvMap() {
        return this.invRslvMap;
    }

    public Map<String, ASTNode> getExpressionMap() {
        return this.expressionMap;
    }

    public void setExprResolver(boolean isExprResolver) {
        this.isExprResolver = isExprResolver;
    }

    public void setRowSchema(RowSchema rowSchema) {
        this.rowSchema = rowSchema;
    }

    public void setRslvMap(HashMap<String, LinkedHashMap<String, ColumnInfo>> rslvMap) {
        this.rslvMap = rslvMap;
    }

    public void setInvRslvMap(HashMap<String, String[]> invRslvMap) {
        this.invRslvMap = invRslvMap;
    }

    public void setExpressionMap(Map<String, ASTNode> expressionMap) {
        this.expressionMap = expressionMap;
    }

    public String[] toColumnDesc() {
        StringBuilder cols = new StringBuilder();
        StringBuilder colTypes = new StringBuilder();
        for (ColumnInfo colInfo : this.getColumnInfos()) {
            if (cols.length() > 0) {
                cols.append(',');
                colTypes.append(':');
            }
            cols.append(colInfo.getInternalName());
            colTypes.append(colInfo.getType().getTypeName());
        }
        return new String[]{cols.toString(), colTypes.toString()};
    }
}

