/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HivePartitioner;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveFatalException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SkewedColumnPositionPair;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SubStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class FileSinkOperator
extends TerminalOperator<FileSinkDesc>
implements Serializable {
    public static final Log LOG = LogFactory.getLog(FileSinkOperator.class);
    private static final boolean isInfoEnabled = LOG.isInfoEnabled();
    private static final boolean isDebugEnabled = LOG.isDebugEnabled();
    protected transient HashMap<String, FSPaths> valToPaths;
    protected transient int numDynParts;
    protected transient List<String> dpColNames;
    protected transient DynamicPartitionCtx dpCtx;
    protected transient boolean isCompressed;
    protected transient boolean isTemporary;
    protected transient Path parent;
    protected transient HiveOutputFormat<?, ?> hiveOutputFormat;
    protected transient Path specPath;
    protected transient String childSpecPathDynLinkedPartitions;
    protected transient int dpStartCol;
    protected transient List<String> dpVals;
    protected transient List<Object> dpWritables;
    protected transient RecordWriter[] rowOutWriters;
    protected transient int maxPartitions;
    protected transient ListBucketingCtx lbCtx;
    protected transient boolean isSkewedStoredAsSubDirectories;
    protected transient boolean statsCollectRawDataSize;
    protected transient boolean[] statsFromRecordWriter;
    protected transient boolean isCollectRWStats;
    private transient FSPaths prevFsp;
    private transient FSPaths fpaths;
    private StructField recIdField;
    private StructField bucketField;
    private StructObjectInspector recIdInspector;
    private IntObjectInspector bucketInspector;
    protected transient long numRows = 0L;
    protected transient long cntr = 1L;
    private static final long serialVersionUID = 1L;
    protected transient FileSystem fs;
    protected transient Serializer serializer;
    protected final transient LongWritable row_count = new LongWritable();
    private transient boolean isNativeTable = true;
    private transient ExprNodeEvaluator[] partitionEval;
    protected transient int totalFiles;
    private transient int numFiles;
    protected transient boolean multiFileSpray;
    protected final transient Map<Integer, Integer> bucketMap = new HashMap<Integer, Integer>();
    private transient ObjectInspector[] partitionObjectInspectors;
    protected transient HivePartitioner<HiveKey, Object> prtner;
    protected final transient HiveKey key = new HiveKey();
    private transient Configuration hconf;
    protected transient FSPaths fsp;
    protected transient boolean bDynParts;
    private transient SubStructObjectInspector subSetOI;
    private transient int timeOut;
    private transient long lastProgressReport = System.currentTimeMillis();
    protected transient boolean autoDelete = false;
    protected transient JobConf jc;
    Class<? extends Writable> outputClass;
    String taskId;
    protected boolean filesCreated = false;
    protected Writable recordValue;

    private void initializeSpecPath() {
        if (!((FileSinkDesc)this.conf).isLinkedFileSink() || this.dpCtx == null) {
            this.specPath = ((FileSinkDesc)this.conf).getDirName();
            this.childSpecPathDynLinkedPartitions = null;
            return;
        }
        this.specPath = ((FileSinkDesc)this.conf).getParentDir();
        this.childSpecPathDynLinkedPartitions = ((FileSinkDesc)this.conf).getDirName().getName();
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.hconf = hconf;
            this.filesCreated = false;
            this.isNativeTable = !((FileSinkDesc)this.conf).getTableInfo().isNonNative();
            this.isTemporary = ((FileSinkDesc)this.conf).isTemporary();
            this.multiFileSpray = ((FileSinkDesc)this.conf).isMultiFileSpray();
            this.totalFiles = ((FileSinkDesc)this.conf).getTotalFiles();
            this.numFiles = ((FileSinkDesc)this.conf).getNumFiles();
            this.dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
            this.lbCtx = ((FileSinkDesc)this.conf).getLbCtx();
            this.prevFsp = null;
            this.fsp = null;
            this.valToPaths = new HashMap();
            this.taskId = Utilities.getTaskId(hconf);
            this.initializeSpecPath();
            this.fs = this.specPath.getFileSystem(hconf);
            this.hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat(hconf, ((FileSinkDesc)this.conf).getTableInfo());
            this.isCompressed = ((FileSinkDesc)this.conf).getCompressed();
            this.parent = Utilities.toTempPath(((FileSinkDesc)this.conf).getDirName());
            this.statsCollectRawDataSize = ((FileSinkDesc)this.conf).isStatsCollectRawDataSize();
            this.statsFromRecordWriter = new boolean[this.numFiles];
            this.serializer = (Serializer)((Object)((FileSinkDesc)this.conf).getTableInfo().getDeserializerClass().newInstance());
            this.serializer.initialize(hconf, ((FileSinkDesc)this.conf).getTableInfo().getProperties());
            this.outputClass = this.serializer.getSerializedClass();
            if (this.isLogInfoEnabled) {
                LOG.info((Object)("Using serializer : " + this.serializer + " and formatter : " + this.hiveOutputFormat + (this.isCompressed ? " with compression" : "")));
            }
            this.timeOut = hconf.getInt("mapred.healthChecker.script.timeout", 600000) / 2;
            this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf);
            if (this.multiFileSpray) {
                this.partitionEval = new ExprNodeEvaluator[((FileSinkDesc)this.conf).getPartitionCols().size()];
                int i = 0;
                for (ExprNodeDesc e : ((FileSinkDesc)this.conf).getPartitionCols()) {
                    this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
                }
                this.partitionObjectInspectors = FileSinkOperator.initEvaluators(this.partitionEval, this.outputObjInspector);
                this.prtner = (HivePartitioner)ReflectionUtils.newInstance((Class)this.jc.getPartitionerClass(), null);
            }
            if (this.dpCtx != null) {
                this.dpSetup();
            }
            if (this.lbCtx != null) {
                this.lbSetup();
            }
            if (!this.bDynParts) {
                this.fsp = new FSPaths(this.specPath);
                if (!this.isSkewedStoredAsSubDirectories) {
                    this.valToPaths.put("", this.fsp);
                }
            }
            HadoopShims.StoragePolicyValue tmpStorage = HadoopShims.StoragePolicyValue.lookup(HiveConf.getVar(hconf, HiveConf.ConfVars.HIVE_TEMPORARY_TABLE_STORAGE));
            if (this.isTemporary && this.fsp != null && tmpStorage != HadoopShims.StoragePolicyValue.DEFAULT) {
                Path outputPath = this.fsp.taskOutputTempPath;
                HadoopShims.StoragePolicyShim shim = ShimLoader.getHadoopShims().getStoragePolicyShim(this.fs);
                if (shim != null) {
                    this.fs.mkdirs(outputPath);
                    shim.setStoragePolicy(outputPath, tmpStorage);
                }
            }
            if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE || ((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                this.recIdField = ((StructObjectInspector)this.outputObjInspector).getAllStructFieldRefs().get(0);
                this.recIdInspector = (StructObjectInspector)this.recIdField.getFieldObjectInspector();
                this.bucketField = this.recIdInspector.getAllStructFieldRefs().get(1);
                this.bucketInspector = (IntObjectInspector)this.bucketField.getFieldObjectInspector();
            }
            this.numRows = 0L;
            String context = this.jc.get("__hive.context.name", "");
            if (context != null && !context.isEmpty()) {
                context = "_" + context.replace(" ", "_");
            }
            this.statsMap.put((Object)((Object)Counter.RECORDS_OUT) + context, this.row_count);
            this.initializeChildren(hconf);
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    private void lbSetup() {
        this.isSkewedStoredAsSubDirectories = this.lbCtx == null ? false : this.lbCtx.isSkewedStoredAsDir();
    }

    private void dpSetup() {
        this.bDynParts = false;
        this.numDynParts = this.dpCtx.getNumDPCols();
        this.dpColNames = this.dpCtx.getDPColNames();
        this.maxPartitions = this.dpCtx.getMaxPartitionsPerNode();
        assert (this.numDynParts == this.dpColNames.size()) : "number of dynamic paritions should be the same as the size of DP mapping";
        if (this.dpColNames != null && this.dpColNames.size() > 0) {
            this.bDynParts = true;
            assert (this.inputObjInspectors.length == 1) : "FileSinkOperator should have 1 parent, but it has " + this.inputObjInspectors.length;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            List<? extends StructField> fieldOI = soi.getAllStructFieldRefs();
            ArrayList<ObjectInspector> newFieldsOI = new ArrayList<ObjectInspector>();
            ArrayList<String> newFieldsName = new ArrayList<String>();
            this.dpStartCol = 0;
            for (StructField structField : fieldOI) {
                String fn = structField.getFieldName();
                if (this.dpCtx.getInputToDPCols().containsKey(fn)) break;
                newFieldsOI.add(structField.getFieldObjectInspector());
                newFieldsName.add(structField.getFieldName());
                ++this.dpStartCol;
            }
            assert (newFieldsOI.size() > 0) : "new Fields ObjectInspector is empty";
            this.subSetOI = new SubStructObjectInspector(soi, 0, this.dpStartCol);
            this.dpVals = new ArrayList<String>(this.numDynParts);
            this.dpWritables = new ArrayList<Object>(this.numDynParts);
        }
    }

    protected void createBucketFiles(FSPaths fsp) throws HiveException {
        try {
            int filesIdx = 0;
            HashSet<Integer> seenBuckets = new HashSet<Integer>();
            for (int idx = 0; idx < this.totalFiles; ++idx) {
                if (this.getExecContext() != null && this.getExecContext().getFileId() != null) {
                    if (isInfoEnabled) {
                        LOG.info((Object)"replace taskId from execContext ");
                    }
                    this.taskId = Utilities.replaceTaskIdFromFilename(this.taskId, this.getExecContext().getFileId());
                    if (isInfoEnabled) {
                        LOG.info((Object)("new taskId: FS " + this.taskId));
                    }
                    assert (!this.multiFileSpray);
                    assert (this.totalFiles == 1);
                }
                int bucketNum = 0;
                if (this.multiFileSpray) {
                    int reducerIdx;
                    int currReducer;
                    this.key.setHashCode(idx);
                    int numReducers = this.totalFiles / this.numFiles;
                    if (numReducers > 1 && (currReducer = Integer.valueOf(Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf))).intValue()) != (reducerIdx = this.prtner.getPartition((Object)this.key, null, numReducers)) || seenBuckets.contains(bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles))) continue;
                    seenBuckets.add(bucketNum);
                    this.bucketMap.put(bucketNum, filesIdx);
                    this.taskId = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(this.hconf), bucketNum);
                }
                this.createBucketForFileIdx(fsp, filesIdx);
                ++filesIdx;
            }
            assert (filesIdx == this.numFiles);
            if (this.isNativeTable) {
                this.autoDelete = this.fs.deleteOnExit(fsp.outPaths[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
        this.filesCreated = true;
    }

    protected void createBucketForFileIdx(FSPaths fsp, int filesIdx) throws HiveException {
        try {
            if (this.isNativeTable) {
                fsp.finalPaths[filesIdx] = fsp.getFinalPath(this.taskId, fsp.tmpPath, null);
                if (isInfoEnabled) {
                    LOG.info((Object)("Final Path: FS " + fsp.finalPaths[filesIdx]));
                }
                fsp.outPaths[filesIdx] = fsp.getTaskOutPath(this.taskId);
                if (isInfoEnabled) {
                    LOG.info((Object)("Writing to temp file: FS " + fsp.outPaths[filesIdx]));
                }
            } else {
                fsp.finalPaths[filesIdx] = fsp.outPaths[filesIdx] = this.specPath;
            }
            String extension = Utilities.getFileExtension(this.jc, this.isCompressed, this.hiveOutputFormat);
            fsp.finalPaths[filesIdx] = !this.bDynParts && !this.isSkewedStoredAsSubDirectories ? fsp.getFinalPath(this.taskId, this.parent, extension) : fsp.getFinalPath(this.taskId, fsp.tmpPath, extension);
            if (isInfoEnabled) {
                LOG.info((Object)("New Final Path: FS " + fsp.finalPaths[filesIdx]));
            }
            if (this.isNativeTable) {
                this.autoDelete = this.fs.deleteOnExit(fsp.outPaths[filesIdx]);
            }
            Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), this.jc);
            if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID) {
                fsp.outWriters[filesIdx] = HiveFileFormatUtils.getHiveRecordWriter(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), this.outputClass, (FileSinkDesc)this.conf, fsp.outPaths[filesIdx], this.reporter);
                this.statsFromRecordWriter[filesIdx] = fsp.outWriters[filesIdx] instanceof StatsProvidingRecordWriter;
            } else if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.INSERT) {
                ObjectInspector inspector = this.bDynParts ? this.subSetOI : this.outputObjInspector;
                int acidBucketNum = Integer.valueOf(Utilities.getTaskIdFromFilename(this.taskId));
                fsp.updaters[filesIdx] = HiveFileFormatUtils.getAcidRecordUpdater(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), acidBucketNum, (FileSinkDesc)this.conf, fsp.outPaths[filesIdx], inspector, this.reporter, -1);
            }
            if (this.reporter != null) {
                this.reporter.incrCounter(HiveConf.getVar(this.hconf, HiveConf.ConfVars.HIVECOUNTERGROUP), "CREATED_FILES", 1L);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    protected boolean updateProgress() {
        if (this.reporter != null && System.currentTimeMillis() - this.lastProgressReport > (long)this.timeOut) {
            this.reporter.progress();
            this.lastProgressReport = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        block21: {
            String lbDirName = null;
            String string = lbDirName = this.lbCtx == null ? null : this.generateListBucketingDirName(row);
            if (!this.bDynParts && !this.filesCreated) {
                if (lbDirName != null) {
                    FSPaths fsp2 = this.lookupListBucketingPaths(lbDirName);
                } else {
                    this.createBucketFiles(this.fsp);
                }
            }
            try {
                this.updateProgress();
                assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
                if (this.bDynParts) {
                    if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                        ++this.numDynParts;
                    }
                    this.dpVals.clear();
                    this.dpWritables.clear();
                    ObjectInspectorUtils.partialCopyToStandardObject(this.dpWritables, row, this.dpStartCol, this.numDynParts, (StructObjectInspector)this.inputObjInspectors[0], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                    for (Object o : this.dpWritables) {
                        if (o == null || o.toString().length() == 0) {
                            this.dpVals.add(this.dpCtx.getDefaultPartitionName());
                            continue;
                        }
                        this.dpVals.add(o.toString());
                    }
                    this.fpaths = this.getDynOutPaths(this.dpVals, lbDirName);
                    this.recordValue = this.serializer.serialize(row, this.subSetOI);
                } else {
                    this.fpaths = lbDirName != null ? this.lookupListBucketingPaths(lbDirName) : this.fsp;
                    this.recordValue = this.serializer.serialize(row, this.inputObjInspectors[0]);
                }
                this.rowOutWriters = this.fpaths.outWriters;
                this.isCollectRWStats = this.areAllTrue(this.statsFromRecordWriter);
                if (((FileSinkDesc)this.conf).isGatherStats() && !this.isCollectRWStats) {
                    SerDeStats stats;
                    if (this.statsCollectRawDataSize && (stats = this.serializer.getSerDeStats()) != null) {
                        this.fpaths.stat.addToStat("rawDataSize", stats.getRawDataSize());
                    }
                    this.fpaths.stat.addToStat("numRows", 1L);
                }
                if (++this.numRows == this.cntr) {
                    this.cntr *= 10L;
                    LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
                }
                int writerOffset = this.findWriterOffset(row);
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID) {
                    this.rowOutWriters[writerOffset].write(this.recordValue);
                    break block21;
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.INSERT) {
                    this.fpaths.updaters[writerOffset].insert(((FileSinkDesc)this.conf).getTransactionId(), row);
                    break block21;
                }
                ObjectInspector rowInspector = this.bDynParts ? this.subSetOI : this.outputObjInspector;
                Object recId = ((StructObjectInspector)rowInspector).getStructFieldData(row, this.recIdField);
                int bucketNum = this.bucketInspector.get(this.recIdInspector.getStructFieldData(recId, this.bucketField));
                if (this.fpaths.acidLastBucket != bucketNum) {
                    this.fpaths.acidLastBucket = bucketNum;
                    this.fpaths.updaters[++this.fpaths.acidFileOffset] = HiveFileFormatUtils.getAcidRecordUpdater(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), bucketNum, (FileSinkDesc)this.conf, this.fpaths.outPaths[this.fpaths.acidFileOffset], rowInspector, this.reporter, 0);
                    if (isDebugEnabled) {
                        LOG.debug((Object)("Created updater for bucket number " + bucketNum + " using file " + this.fpaths.outPaths[this.fpaths.acidFileOffset]));
                    }
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE) {
                    this.fpaths.updaters[this.fpaths.acidFileOffset].update(((FileSinkDesc)this.conf).getTransactionId(), row);
                    break block21;
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                    this.fpaths.updaters[this.fpaths.acidFileOffset].delete(((FileSinkDesc)this.conf).getTransactionId(), row);
                    break block21;
                }
                throw new HiveException("Unknown write type " + ((FileSinkDesc)this.conf).getWriteType().toString());
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            catch (SerDeException e) {
                throw new HiveException(e);
            }
        }
    }

    protected boolean areAllTrue(boolean[] statsFromRW) {
        if (((FileSinkDesc)this.conf).getWriteType() != AcidUtils.Operation.NOT_ACID) {
            return true;
        }
        for (boolean b : statsFromRW) {
            if (b) continue;
            return false;
        }
        return true;
    }

    private int findWriterOffset(Object row) throws HiveException {
        if (!this.multiFileSpray) {
            return 0;
        }
        int keyHashCode = 0;
        for (int i = 0; i < this.partitionEval.length; ++i) {
            Object o = this.partitionEval[i].evaluate(row);
            keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode(o, this.partitionObjectInspectors[i]);
        }
        this.key.setHashCode(keyHashCode);
        int bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles);
        return this.bucketMap.get(bucketNum);
    }

    protected FSPaths lookupListBucketingPaths(String lbDirName) throws HiveException {
        FSPaths fsp2 = this.valToPaths.get(lbDirName);
        if (fsp2 == null) {
            fsp2 = this.createNewPaths(lbDirName);
        }
        return fsp2;
    }

    private FSPaths createNewPaths(String dirName) throws HiveException {
        FSPaths fsp2 = new FSPaths(this.specPath);
        if (this.childSpecPathDynLinkedPartitions != null) {
            fsp2.tmpPath = new Path(fsp2.tmpPath, dirName + "/" + this.childSpecPathDynLinkedPartitions);
            fsp2.taskOutputTempPath = new Path(fsp2.taskOutputTempPath, dirName + "/" + this.childSpecPathDynLinkedPartitions);
        } else {
            fsp2.tmpPath = new Path(fsp2.tmpPath, dirName);
            fsp2.taskOutputTempPath = new Path(fsp2.taskOutputTempPath, dirName);
        }
        if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
            this.createBucketFiles(fsp2);
            this.valToPaths.put(dirName, fsp2);
        }
        return fsp2;
    }

    protected String generateListBucketingDirName(Object row) {
        if (!this.isSkewedStoredAsSubDirectories) {
            return null;
        }
        String lbDirName = null;
        ArrayList<Object> standObjs = new ArrayList<Object>();
        List<String> skewedCols = this.lbCtx.getSkewedColNames();
        List<List<String>> allSkewedVals = this.lbCtx.getSkewedColValues();
        ArrayList<String> skewedValsCandidate = null;
        Map<List<String>, String> locationMap = this.lbCtx.getLbLocationMap();
        ObjectInspectorUtils.copyToStandardObject(standObjs, row, (StructObjectInspector)this.inputObjInspectors[0], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        assert (standObjs.size() >= skewedCols.size()) : "The row has less number of columns than no. of skewed column.";
        skewedValsCandidate = new ArrayList<String>(skewedCols.size());
        for (SkewedColumnPositionPair posPair : this.lbCtx.getRowSkewedIndex()) {
            skewedValsCandidate.add(posPair.getSkewColPosition(), standObjs.get(posPair.getTblColPosition()).toString());
        }
        if (allSkewedVals.contains(skewedValsCandidate)) {
            lbDirName = FileUtils.makeListBucketingDirName(skewedCols, skewedValsCandidate);
            locationMap.put(skewedValsCandidate, lbDirName);
        } else {
            lbDirName = FileUtils.makeDefaultListBucketingDirName(skewedCols, this.lbCtx.getDefaultDirName());
            List<String> defaultKey = Arrays.asList(this.lbCtx.getDefaultKey());
            if (!locationMap.containsKey(defaultKey)) {
                locationMap.put(defaultKey, lbDirName);
            }
        }
        return lbDirName;
    }

    protected FSPaths getDynOutPaths(List<String> row, String lbDirName) throws HiveException {
        FSPaths fp;
        String dpDir = this.getDynPartDirectory(row, this.dpColNames);
        String pathKey = null;
        if (dpDir != null) {
            FSPaths fsp2;
            pathKey = dpDir = this.appendToSource(lbDirName, dpDir);
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                String buckNum = row.get(row.size() - 1);
                this.taskId = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(this.hconf), buckNum);
                pathKey = this.appendToSource(this.taskId, dpDir);
            }
            if ((fsp2 = this.valToPaths.get(pathKey)) == null) {
                if (this.valToPaths.size() > this.maxPartitions) {
                    throw new HiveFatalException(ErrorMsg.DYNAMIC_PARTITIONS_TOO_MANY_PER_NODE_ERROR.getErrorCodedMsg() + "Maximum was set to: " + this.maxPartitions);
                }
                if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.NONE) && this.prevFsp != null) {
                    this.prevFsp.closeWriters(false);
                    if (((FileSinkDesc)this.conf).isGatherStats() && this.isCollectRWStats) {
                        SerDeStats stats = null;
                        if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID) {
                            RecordWriter outWriter = this.prevFsp.outWriters[0];
                            if (outWriter != null) {
                                stats = ((StatsProvidingRecordWriter)outWriter).getStats();
                            }
                        } else if (this.prevFsp.updaters[0] != null) {
                            stats = this.prevFsp.updaters[0].getStats();
                        }
                        if (stats != null) {
                            this.prevFsp.stat.addToStat("rawDataSize", stats.getRawDataSize());
                            this.prevFsp.stat.addToStat("numRows", stats.getRowCount());
                        }
                    }
                    this.prevFsp.outWriters[0] = null;
                    this.prevFsp = null;
                }
                fsp2 = this.createNewPaths(dpDir);
                if (this.prevFsp == null) {
                    this.prevFsp = fsp2;
                }
                if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                    this.createBucketForFileIdx(fsp2, 0);
                    this.valToPaths.put(pathKey, fsp2);
                }
            }
            fp = fsp2;
        } else {
            fp = this.fsp;
        }
        return fp;
    }

    private String appendToSource(String appendDir, String srcDir) {
        StringBuilder builder = new StringBuilder(srcDir);
        srcDir = appendDir == null ? srcDir : builder.append("/").append(appendDir).toString();
        return srcDir;
    }

    private String getDynPartDirectory(List<String> row, List<String> dpColNames) {
        return FileUtils.makePartName(dpColNames, row);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        this.row_count.set(this.numRows);
        LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
        if (!this.bDynParts && !this.filesCreated) {
            this.createBucketFiles(this.fsp);
        }
        this.lastProgressReport = System.currentTimeMillis();
        if (!abort) {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.closeWriters(abort);
                if (((FileSinkDesc)this.conf).isGatherStats() && this.isCollectRWStats) {
                    if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID) {
                        for (int idx = 0; idx < fsp.outWriters.length; ++idx) {
                            SerDeStats stats;
                            RecordWriter outWriter = fsp.outWriters[idx];
                            if (outWriter == null || (stats = ((StatsProvidingRecordWriter)outWriter).getStats()) == null) continue;
                            fsp.stat.addToStat("rawDataSize", stats.getRawDataSize());
                            fsp.stat.addToStat("numRows", stats.getRowCount());
                        }
                    } else {
                        for (int i = 0; i < fsp.updaters.length; ++i) {
                            SerDeStats stats;
                            if (fsp.updaters[i] == null || (stats = fsp.updaters[i].getStats()) == null) continue;
                            fsp.stat.addToStat("rawDataSize", stats.getRawDataSize());
                            fsp.stat.addToStat("numRows", stats.getRowCount());
                        }
                    }
                }
                if (!this.isNativeTable) continue;
                fsp.commit(this.fs);
            }
            if (((FileSinkDesc)this.conf).isGatherStats()) {
                this.publishStats();
            }
        } else {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.abortWriters(this.fs, abort, !this.autoDelete && this.isNativeTable);
            }
        }
        this.prevFsp = null;
        this.fsp = null;
    }

    @Override
    public String getName() {
        return FileSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "FS";
    }

    @Override
    public void jobCloseOp(Configuration hconf, boolean success) throws HiveException {
        try {
            if (this.conf != null && this.isNativeTable) {
                Path specPath = ((FileSinkDesc)this.conf).getDirName();
                DynamicPartitionCtx dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
                if (((FileSinkDesc)this.conf).isLinkedFileSink() && dpCtx != null) {
                    specPath = ((FileSinkDesc)this.conf).getParentDir();
                }
                Utilities.mvFileToFinalPath(specPath, hconf, success, LOG, dpCtx, (FileSinkDesc)this.conf, this.reporter);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        super.jobCloseOp(hconf, success);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILESINK;
    }

    @Override
    public void augmentPlan() {
        PlanUtils.configureOutputJobPropertiesForStorageHandler(((FileSinkDesc)this.getConf()).getTableInfo());
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (this.hiveOutputFormat == null) {
            Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), job);
            try {
                this.hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)job, ((FileSinkDesc)this.getConf()).getTableInfo());
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        if (((FileSinkDesc)this.conf).getTableInfo().isNonNative()) {
            try {
                this.hiveOutputFormat.checkOutputSpecs(ignored, job);
            }
            catch (NoSuchMethodError e) {
                LOG.warn((Object)"HiveOutputFormat should implement checkOutputSpecs() method`");
            }
        }
    }

    private void publishStats() throws HiveException {
        boolean isStatsReliable = ((FileSinkDesc)this.conf).isStatsReliable();
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (statsPublisher == null) {
            LOG.error((Object)"StatsPublishing error: StatsPublisher is not initialized.");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
            }
            return;
        }
        if (!statsPublisher.connect(this.hconf)) {
            LOG.error((Object)"StatsPublishing error: cannot connect to database");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
            }
            return;
        }
        String taskID = Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf));
        String spSpec = ((FileSinkDesc)this.conf).getStaticSpec();
        int maxKeyLength = ((FileSinkDesc)this.conf).getMaxStatsKeyPrefixLength();
        boolean taskIndependent = statsPublisher instanceof StatsCollectionTaskIndependent;
        for (Map.Entry<String, FSPaths> entry : this.valToPaths.entrySet()) {
            String prefix;
            String fspKey = entry.getKey();
            FSPaths fspValue = entry.getValue();
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                taskID = Utilities.getTaskIdFromFilename(fspKey);
                fspKey = fspKey.split(taskID)[0];
            }
            String[] split = this.splitKey(fspKey);
            String dpSpec = split[0];
            String lbSpec = split[1];
            String postfix = null;
            if (taskIndependent) {
                prefix = ((FileSinkDesc)this.conf).getTableInfo().getTableName().toLowerCase();
            } else {
                prefix = ((FileSinkDesc)this.conf).getStatsAggPrefix();
                postfix = Utilities.join(lbSpec, taskID);
            }
            prefix = Utilities.join(prefix, spSpec, dpSpec);
            prefix = Utilities.getHashedStatsPrefix(prefix, maxKeyLength);
            String key = Utilities.join(prefix, postfix);
            HashMap<String, String> statsToPublish = new HashMap<String, String>();
            for (String statType : fspValue.stat.getStoredStats()) {
                statsToPublish.put(statType, Long.toString(fspValue.stat.getStat(statType)));
            }
            if (statsPublisher.publishStat(key, statsToPublish) || !isStatsReliable) continue;
            throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
        }
        if (!statsPublisher.closeConnection() && isStatsReliable) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
        }
    }

    private String[] splitKey(String fspKey) {
        if (!fspKey.isEmpty() && this.isSkewedStoredAsSubDirectories) {
            for (String dir : this.lbCtx.getSkewedValuesDirNames()) {
                int index = fspKey.indexOf(dir);
                if (index < 0) continue;
                return new String[]{fspKey.substring(0, index), fspKey.substring(index + 1)};
            }
        }
        return new String[]{fspKey, null};
    }

    public class FSPaths
    implements Cloneable {
        Path tmpPath;
        Path taskOutputTempPath;
        Path[] outPaths;
        Path[] finalPaths;
        RecordWriter[] outWriters;
        RecordUpdater[] updaters;
        Stat stat;
        int acidLastBucket = -1;
        int acidFileOffset = -1;

        public FSPaths(Path specPath) {
            this.tmpPath = Utilities.toTempPath(specPath);
            this.taskOutputTempPath = Utilities.toTaskTempPath(specPath);
            this.outPaths = new Path[FileSinkOperator.this.numFiles];
            this.finalPaths = new Path[FileSinkOperator.this.numFiles];
            this.outWriters = new RecordWriter[FileSinkOperator.this.numFiles];
            this.updaters = new RecordUpdater[FileSinkOperator.this.numFiles];
            if (isDebugEnabled) {
                LOG.debug((Object)("Created slots for  " + FileSinkOperator.this.numFiles));
            }
            this.stat = new Stat();
        }

        public Path getTaskOutPath(String taskId) {
            return new Path(this.taskOutputTempPath, Utilities.toTempPath(taskId));
        }

        public Path getFinalPath(String taskId, Path tmpPath, String extension) {
            if (extension != null) {
                return new Path(tmpPath, taskId + extension);
            }
            return new Path(tmpPath, taskId);
        }

        public void setOutWriters(RecordWriter[] out) {
            this.outWriters = out;
        }

        public RecordWriter[] getOutWriters() {
            return this.outWriters;
        }

        public void closeWriters(boolean abort) throws HiveException {
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
            try {
                for (int i = 0; i < this.updaters.length; ++i) {
                    if (this.updaters[i] == null) continue;
                    this.updaters[i].close(abort);
                }
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }

        private void commit(FileSystem fs) throws HiveException {
            for (int idx = 0; idx < this.outPaths.length; ++idx) {
                try {
                    if ((FileSinkOperator.this.bDynParts || FileSinkOperator.this.isSkewedStoredAsSubDirectories) && !fs.exists(this.finalPaths[idx].getParent())) {
                        fs.mkdirs(this.finalPaths[idx].getParent());
                    }
                    boolean needToRename = true;
                    if (((FileSinkDesc)FileSinkOperator.this.conf).getWriteType() == AcidUtils.Operation.UPDATE || ((FileSinkDesc)FileSinkOperator.this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                        try {
                            FileStatus stat = fs.getFileStatus(this.outPaths[idx]);
                        }
                        catch (FileNotFoundException fnfe) {
                            needToRename = false;
                        }
                    }
                    if (needToRename && !fs.rename(this.outPaths[idx], this.finalPaths[idx])) {
                        throw new HiveException("Unable to rename output from: " + this.outPaths[idx] + " to: " + this.finalPaths[idx]);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException("Unable to rename output from: " + this.outPaths[idx] + " to: " + this.finalPaths[idx], e);
                }
            }
        }

        public void abortWriters(FileSystem fs, boolean abort, boolean delete) throws HiveException {
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    if (delete) {
                        fs.delete(this.outPaths[idx], true);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }

        public Stat getStat() {
            return this.stat;
        }
    }

    public static interface RecordWriter {
        public void write(Writable var1) throws IOException;

        public void close(boolean var1) throws IOException;
    }

    public static enum Counter {
        RECORDS_OUT;

    }
}

