/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;

abstract class SparkJobMonitor {
    protected static final String CLASS_NAME = SparkJobMonitor.class.getName();
    protected static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected static SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    protected final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    protected final int checkInterval = 1000;
    protected final long monitorTimeoutInteval;
    private Set<String> completed = new HashSet<String>();
    private final int printInterval = 3000;
    private long lastPrintTime;

    protected SparkJobMonitor(HiveConf hiveConf) {
        this.monitorTimeoutInteval = hiveConf.getTimeVar(HiveConf.ConfVars.SPARK_JOB_MONITOR_TIMEOUT, TimeUnit.SECONDS);
    }

    public abstract int startMonitor();

    protected void printStatus(Map<String, SparkStageProgress> progressMap, Map<String, SparkStageProgress> lastProgressMap) {
        boolean isPassedInterval;
        boolean isDuplicateState = this.isSameAsPreviousProgress(progressMap, lastProgressMap);
        boolean bl = isPassedInterval = System.currentTimeMillis() <= this.lastPrintTime + 3000L;
        if (isDuplicateState && isPassedInterval) {
            return;
        }
        StringBuffer reportBuffer = new StringBuffer();
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        String currentDate = dt.format(new Date());
        reportBuffer.append(currentDate + "\t");
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        for (String s : keys) {
            SparkStageProgress progress = progressMap.get(s);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            int running = progress.getRunningTaskCount();
            int failed = progress.getFailedTaskCount();
            String stageName = "Stage-" + s;
            if (total <= 0) {
                reportBuffer.append(String.format("%s: -/-\t", stageName, complete, total));
                continue;
            }
            if (complete == total && !this.completed.contains(s)) {
                this.completed.add(s);
                if (!this.perfLogger.startTimeHasMethod("SparkRunStage." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkRunStage.");
                }
                this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkRunStage.");
            }
            if (complete < total && (complete > 0 || running > 0 || failed > 0)) {
                if (!this.perfLogger.startTimeHasMethod("SparkRunStage." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkRunStage." + s);
                }
                if (failed > 0) {
                    reportBuffer.append(String.format("%s: %d(+%d,-%d)/%d\t", stageName, complete, running, failed, total));
                    continue;
                }
                reportBuffer.append(String.format("%s: %d(+%d)/%d\t", stageName, complete, running, total));
                continue;
            }
            if (failed > 0) {
                reportBuffer.append(String.format("%s: %d(-%d)/%d Finished with failed tasks\t", stageName, complete, failed, total));
                continue;
            }
            if (complete == total) {
                reportBuffer.append(String.format("%s: %d/%d Finished\t", stageName, complete, total));
                continue;
            }
            reportBuffer.append(String.format("%s: %d/%d\t", stageName, complete, total));
        }
        this.lastPrintTime = System.currentTimeMillis();
        console.printInfo(reportBuffer.toString());
    }

    private boolean isSameAsPreviousProgress(Map<String, SparkStageProgress> progressMap, Map<String, SparkStageProgress> lastProgressMap) {
        if (lastProgressMap == null) {
            return false;
        }
        if (progressMap.isEmpty()) {
            return lastProgressMap.isEmpty();
        }
        if (lastProgressMap.isEmpty()) {
            return false;
        }
        if (progressMap.size() != lastProgressMap.size()) {
            return false;
        }
        for (String key : progressMap.keySet()) {
            if (lastProgressMap.containsKey(key) && progressMap.get(key).equals(lastProgressMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

