/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.ETypeConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveCollectionConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveStructConverter;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.schema.GroupType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public abstract class HiveGroupConverter
extends GroupConverter
implements ConverterParent {
    protected static PrimitiveConverter getConverterFromDescription(PrimitiveType type, int index, ConverterParent parent) {
        if (type == null) {
            return null;
        }
        return ETypeConverter.getNewConverter(type, index, parent);
    }

    protected static HiveGroupConverter getConverterFromDescription(GroupType type, int index, ConverterParent parent) {
        if (type == null) {
            return null;
        }
        OriginalType annotation = type.getOriginalType();
        if (annotation == OriginalType.LIST) {
            return HiveCollectionConverter.forList(type, parent, index);
        }
        if (annotation == OriginalType.MAP || annotation == OriginalType.MAP_KEY_VALUE) {
            return HiveCollectionConverter.forMap(type, parent, index);
        }
        return new HiveStructConverter(type, parent, index);
    }

    protected static Converter getConverterFromDescription(Type type, int index, ConverterParent parent) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            return HiveGroupConverter.getConverterFromDescription(type.asPrimitiveType(), index, parent);
        }
        return HiveGroupConverter.getConverterFromDescription(type.asGroupType(), index, parent);
    }

    static ArrayWritable wrapList(ArrayWritable list) {
        return new ArrayWritable(Writable.class, new Writable[]{list});
    }

    @Override
    public abstract void set(int var1, Writable var2);
}

