/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class JoinReorder
implements Transform {
    private int getOutputSize(Operator<? extends OperatorDesc> operator, Set<String> bigTables) {
        String alias;
        if (operator instanceof JoinOperator) {
            for (Operator<OperatorDesc> o : operator.getParentOperators()) {
                if (this.getOutputSize(o, bigTables) == 0) continue;
                return 1;
            }
        }
        if (operator instanceof TableScanOperator && bigTables.contains(alias = ((TableScanDesc)((TableScanOperator)operator).getConf()).getAlias())) {
            return 2;
        }
        int maxSize = 0;
        if (operator.getParentOperators() != null) {
            for (Operator<OperatorDesc> o : operator.getParentOperators()) {
                int current = this.getOutputSize(o, bigTables);
                if (current <= maxSize) continue;
                maxSize = current;
            }
        }
        return maxSize;
    }

    private Set<String> getBigTables(ParseContext joinCtx) {
        HashSet<String> bigTables = new HashSet<String>();
        for (JoinOperator joinOp : joinCtx.getJoinOps()) {
            if (((JoinDesc)joinOp.getConf()).getStreamAliases() == null) continue;
            bigTables.addAll(((JoinDesc)joinOp.getConf()).getStreamAliases());
        }
        return bigTables;
    }

    private void reorder(JoinOperator joinOp, Set<String> bigTables) {
        int count = joinOp.getParentOperators().size();
        int biggestPos = count - 1;
        int biggestSize = this.getOutputSize(joinOp.getParentOperators().get(biggestPos), bigTables);
        for (int i = 0; i < count - 1; ++i) {
            int currSize = this.getOutputSize(joinOp.getParentOperators().get(i), bigTables);
            if (currSize <= biggestSize) continue;
            biggestSize = currSize;
            biggestPos = i;
        }
        if (biggestPos != count - 1) {
            Byte[] tagOrder = ((JoinDesc)joinOp.getConf()).getTagOrder();
            Byte temp = tagOrder[biggestPos];
            tagOrder[biggestPos] = tagOrder[count - 1];
            tagOrder[count - 1] = temp;
            ((ReduceSinkDesc)((ReduceSinkOperator)joinOp.getParentOperators().get(biggestPos)).getConf()).setTag(count - 1);
            ((ReduceSinkDesc)((ReduceSinkOperator)joinOp.getParentOperators().get(count - 1)).getConf()).setTag(biggestPos);
        }
    }

    @Override
    public ParseContext transform(ParseContext pactx) throws SemanticException {
        Set<String> bigTables = this.getBigTables(pactx);
        for (JoinOperator joinOp : pactx.getJoinOps()) {
            this.reorder(joinOp, bigTables);
        }
        return pactx;
    }
}

