/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ExprNodeConverter
extends RexVisitorImpl<ExprNodeDesc> {
    RelDataType rType;
    String tabAlias;
    boolean partitioningExpr;
    private final RelDataTypeFactory dTFactory;

    public ExprNodeConverter(String tabAlias, RelDataType rType, boolean partitioningExpr, RelDataTypeFactory dTFactory) {
        super(true);
        assert (partitioningExpr);
        this.tabAlias = tabAlias;
        this.rType = rType;
        this.partitioningExpr = partitioningExpr;
        this.dTFactory = dTFactory;
    }

    public ExprNodeDesc visitInputRef(RexInputRef inputRef) {
        RelDataTypeField f = (RelDataTypeField)this.rType.getFieldList().get(inputRef.getIndex());
        return new ExprNodeColumnDesc(TypeConverter.convert(f.getType()), f.getName(), this.tabAlias, this.partitioningExpr);
    }

    public ExprNodeDesc visitCall(RexCall call) {
        ExprNodeGenericFuncDesc gfDesc = null;
        if (!this.deep) {
            return null;
        }
        LinkedList<ExprNodeDesc> args = new LinkedList<ExprNodeDesc>();
        for (RexNode operand : call.operands) {
            args.add((ExprNodeDesc)operand.accept((RexVisitor)this));
        }
        if (call.isA(SqlKind.CAST) && call.operands.size() == 1 && SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.dTFactory, (RelDataType)call.getType(), (RelDataType)((RexNode)call.operands.get(0)).getType())) {
            return (ExprNodeDesc)args.get(0);
        }
        if (ASTConverter.isFlat(call)) {
            ArrayList<ExprNodeDesc> tmpExprArgs = new ArrayList<ExprNodeDesc>();
            tmpExprArgs.addAll(args.subList(0, 2));
            gfDesc = new ExprNodeGenericFuncDesc(TypeConverter.convert(call.getType()), SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), 2), tmpExprArgs);
            for (int i = 2; i < call.operands.size(); ++i) {
                tmpExprArgs = new ArrayList();
                tmpExprArgs.add(gfDesc);
                tmpExprArgs.add((ExprNodeDesc)args.get(i));
                gfDesc = new ExprNodeGenericFuncDesc(TypeConverter.convert(call.getType()), SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), 2), tmpExprArgs);
            }
        } else {
            GenericUDF hiveUdf = SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), args.size());
            if (hiveUdf == null) {
                throw new RuntimeException("Cannot find UDF for " + call.getType() + " " + call.getOperator() + "[" + call.getOperator().getKind() + "]/" + args.size());
            }
            gfDesc = new ExprNodeGenericFuncDesc(TypeConverter.convert(call.getType()), hiveUdf, args);
        }
        return gfDesc;
    }

    public ExprNodeDesc visitLiteral(RexLiteral literal) {
        RelDataType lType = literal.getType();
        switch (literal.getType().getSqlTypeName()) {
            case BOOLEAN: {
                return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, RexLiteral.booleanValue((RexNode)literal));
            }
            case TINYINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.byteTypeInfo, ((Number)literal.getValue3()).byteValue());
            }
            case SMALLINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.shortTypeInfo, ((Number)literal.getValue3()).shortValue());
            }
            case INTEGER: {
                return new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ((Number)literal.getValue3()).intValue());
            }
            case BIGINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.longTypeInfo, ((Number)literal.getValue3()).longValue());
            }
            case FLOAT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.floatTypeInfo, Float.valueOf(((Number)literal.getValue3()).floatValue()));
            }
            case DOUBLE: {
                return new ExprNodeConstantDesc(TypeInfoFactory.doubleTypeInfo, ((Number)literal.getValue3()).doubleValue());
            }
            case DATE: {
                return new ExprNodeConstantDesc(TypeInfoFactory.dateTypeInfo, new Date(((Calendar)literal.getValue()).getTimeInMillis()));
            }
            case TIMESTAMP: {
                Object value = literal.getValue3();
                if (value instanceof Long) {
                    value = new Timestamp((Long)value);
                }
                return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, value);
            }
            case BINARY: {
                return new ExprNodeConstantDesc(TypeInfoFactory.binaryTypeInfo, literal.getValue3());
            }
            case DECIMAL: {
                return new ExprNodeConstantDesc(TypeInfoFactory.getDecimalTypeInfo(lType.getPrecision(), lType.getScale()), literal.getValue3());
            }
            case VARCHAR: {
                return new ExprNodeConstantDesc(TypeInfoFactory.getVarcharTypeInfo(lType.getPrecision()), new HiveVarchar((String)literal.getValue3(), lType.getPrecision()));
            }
            case CHAR: {
                return new ExprNodeConstantDesc(TypeInfoFactory.getCharTypeInfo(lType.getPrecision()), new HiveChar((String)literal.getValue3(), lType.getPrecision()));
            }
        }
        return new ExprNodeConstantDesc(TypeInfoFactory.voidTypeInfo, literal.getValue3());
    }
}

