/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;

public class GenericUDAFMkCollectionEvaluator
extends GenericUDAFEvaluator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient PrimitiveObjectInspector inputOI;
    private transient StandardListObjectInspector loi;
    private transient StandardListObjectInspector internalMergeOI;
    private BufferType bufferType;

    public GenericUDAFMkCollectionEvaluator() {
    }

    public GenericUDAFMkCollectionEvaluator(BufferType bufferType) {
        this.bufferType = bufferType;
    }

    @Override
    public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
        super.init(m, parameters);
        if (m == GenericUDAFEvaluator.Mode.PARTIAL1) {
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            return ObjectInspectorFactory.getStandardListObjectInspector((PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(this.inputOI));
        }
        if (!(parameters[0] instanceof StandardListObjectInspector)) {
            this.inputOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(parameters[0]);
            return ObjectInspectorFactory.getStandardListObjectInspector(this.inputOI);
        }
        this.internalMergeOI = (StandardListObjectInspector)parameters[0];
        this.inputOI = (PrimitiveObjectInspector)this.internalMergeOI.getListElementObjectInspector();
        this.loi = (StandardListObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(this.internalMergeOI);
        return this.loi;
    }

    @Override
    public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        ((MkArrayAggregationBuffer)agg).container.clear();
    }

    @Override
    public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        MkArrayAggregationBuffer ret = new MkArrayAggregationBuffer();
        return ret;
    }

    @Override
    public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
        assert (parameters.length == 1);
        Object p = parameters[0];
        if (p != null) {
            MkArrayAggregationBuffer myagg = (MkArrayAggregationBuffer)agg;
            this.putIntoCollection(p, myagg);
        }
    }

    @Override
    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        MkArrayAggregationBuffer myagg = (MkArrayAggregationBuffer)agg;
        ArrayList ret = new ArrayList(myagg.container.size());
        ret.addAll(myagg.container);
        return ret;
    }

    @Override
    public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
        MkArrayAggregationBuffer myagg = (MkArrayAggregationBuffer)agg;
        ArrayList partialResult = (ArrayList)this.internalMergeOI.getList(partial);
        if (partialResult != null) {
            for (Object i : partialResult) {
                this.putIntoCollection(i, myagg);
            }
        }
    }

    @Override
    public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        MkArrayAggregationBuffer myagg = (MkArrayAggregationBuffer)agg;
        ArrayList ret = new ArrayList(myagg.container.size());
        ret.addAll(myagg.container);
        return ret;
    }

    private void putIntoCollection(Object p, MkArrayAggregationBuffer myagg) {
        Object pCopy = ObjectInspectorUtils.copyToStandardObject(p, this.inputOI);
        myagg.container.add(pCopy);
    }

    public BufferType getBufferType() {
        return this.bufferType;
    }

    public void setBufferType(BufferType bufferType) {
        this.bufferType = bufferType;
    }

    class MkArrayAggregationBuffer
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        private Collection<Object> container;

        public MkArrayAggregationBuffer() {
            if (GenericUDAFMkCollectionEvaluator.this.bufferType == BufferType.LIST) {
                this.container = new ArrayList<Object>();
            } else if (GenericUDAFMkCollectionEvaluator.this.bufferType == BufferType.SET) {
                this.container = new LinkedHashSet<Object>();
            } else {
                throw new RuntimeException("Buffer type unknown");
            }
        }
    }

    static enum BufferType {
        SET,
        LIST;

    }
}

