/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.mapred.InputSplitWithLocationInfo;
import org.apache.hadoop.mapred.SplitLocationInfo;

public class LlapInputSplit
implements InputSplitWithLocationInfo {
    int splitNum;
    byte[] planBytes;
    byte[] fragmentBytes;
    SplitLocationInfo[] locations;
    Schema schema;
    String llapUser;

    public LlapInputSplit() {
    }

    public LlapInputSplit(int splitNum, byte[] planBytes, byte[] fragmentBytes, SplitLocationInfo[] locations, Schema schema, String llapUser) {
        this.planBytes = planBytes;
        this.fragmentBytes = fragmentBytes;
        this.locations = locations;
        this.schema = schema;
        this.splitNum = splitNum;
        this.llapUser = llapUser;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getLength() throws IOException {
        return 0L;
    }

    public String[] getLocations() throws IOException {
        String[] locs = new String[this.locations.length];
        for (int i = 0; i < this.locations.length; ++i) {
            locs[i] = this.locations[i].getLocation();
        }
        return locs;
    }

    public int getSplitNum() {
        return this.splitNum;
    }

    public byte[] getPlanBytes() {
        return this.planBytes;
    }

    public byte[] getFragmentBytes() {
        return this.fragmentBytes;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.splitNum);
        out.writeInt(this.planBytes.length);
        out.write(this.planBytes);
        out.writeInt(this.fragmentBytes.length);
        out.write(this.fragmentBytes);
        out.writeInt(this.locations.length);
        for (int i = 0; i < this.locations.length; ++i) {
            out.writeUTF(this.locations[i].getLocation());
        }
        this.schema.write(out);
        out.writeUTF(this.llapUser);
    }

    public void readFields(DataInput in) throws IOException {
        this.splitNum = in.readInt();
        int length = in.readInt();
        this.planBytes = new byte[length];
        in.readFully(this.planBytes);
        length = in.readInt();
        this.fragmentBytes = new byte[length];
        in.readFully(this.fragmentBytes);
        length = in.readInt();
        this.locations = new SplitLocationInfo[length];
        for (int i = 0; i < length; ++i) {
            this.locations[i] = new SplitLocationInfo(in.readUTF(), false);
        }
        this.schema = new Schema();
        this.schema.readFields(in);
        this.llapUser = in.readUTF();
    }

    public SplitLocationInfo[] getLocationInfo() throws IOException {
        return this.locations;
    }

    public String getLlapUser() {
        return this.llapUser;
    }
}

