/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.StreamUtils;
import org.apache.orc.CompressionCodec;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.SettableUncompressedStream;
import org.apache.orc.impl.TreeReaderFactory;

public class EncodedTreeReaderFactory
extends TreeReaderFactory {
    public static TreeReaderFactory.TreeReader[] createEncodedTreeReader(int numCols, List<OrcProto.Type> types, List<OrcProto.ColumnEncoding> encodings, EncodedColumnBatch<OrcBatchKey> batch, CompressionCodec codec, boolean skipCorrupt, String writerTimezone) throws IOException {
        TreeReaderFactory.TreeReader[] treeReaders = new TreeReaderFactory.TreeReader[numCols];
        block16: for (int i = 0; i < numCols; ++i) {
            int columnIndex = batch.getColumnIxs()[i];
            EncodedColumnBatch.ColumnStreamData[] streamBuffers = batch.getColumnData()[i];
            OrcProto.Type columnType = types.get(columnIndex);
            OrcProto.ColumnEncoding columnEncoding = encodings.get(columnIndex);
            EncodedColumnBatch.ColumnStreamData present = streamBuffers[0];
            EncodedColumnBatch.ColumnStreamData data = streamBuffers[1];
            EncodedColumnBatch.ColumnStreamData dictionary = streamBuffers[3];
            EncodedColumnBatch.ColumnStreamData lengths = streamBuffers[2];
            EncodedColumnBatch.ColumnStreamData secondary = streamBuffers[5];
            switch (columnType.getKind()) {
                case BINARY: {
                    treeReaders[i] = BinaryStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setLengthStream(lengths).setCompressionCodec(codec).setColumnEncoding(columnEncoding).build();
                    continue block16;
                }
                case BOOLEAN: {
                    treeReaders[i] = BooleanStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).build();
                    continue block16;
                }
                case BYTE: {
                    treeReaders[i] = ByteStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).build();
                    continue block16;
                }
                case SHORT: {
                    treeReaders[i] = ShortStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).build();
                    continue block16;
                }
                case INT: {
                    treeReaders[i] = IntStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).build();
                    continue block16;
                }
                case LONG: {
                    treeReaders[i] = LongStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).skipCorrupt(skipCorrupt).build();
                    continue block16;
                }
                case FLOAT: {
                    treeReaders[i] = FloatStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).build();
                    continue block16;
                }
                case DOUBLE: {
                    treeReaders[i] = DoubleStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).build();
                    continue block16;
                }
                case CHAR: {
                    treeReaders[i] = CharStreamReader.builder().setColumnIndex(columnIndex).setMaxLength(columnType.getMaximumLength()).setPresentStream(present).setDataStream(data).setLengthStream(lengths).setDictionaryStream(dictionary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).build();
                    continue block16;
                }
                case VARCHAR: {
                    treeReaders[i] = VarcharStreamReader.builder().setColumnIndex(columnIndex).setMaxLength(columnType.getMaximumLength()).setPresentStream(present).setDataStream(data).setLengthStream(lengths).setDictionaryStream(dictionary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).build();
                    continue block16;
                }
                case STRING: {
                    treeReaders[i] = StringStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setLengthStream(lengths).setDictionaryStream(dictionary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).build();
                    continue block16;
                }
                case DECIMAL: {
                    treeReaders[i] = DecimalStreamReader.builder().setColumnIndex(columnIndex).setPrecision(columnType.getPrecision()).setScale(columnType.getScale()).setPresentStream(present).setValueStream(data).setScaleStream(secondary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).build();
                    continue block16;
                }
                case TIMESTAMP: {
                    treeReaders[i] = TimestampStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setSecondsStream(data).setNanosStream(secondary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setWriterTimezone(writerTimezone).skipCorrupt(skipCorrupt).build();
                    continue block16;
                }
                case DATE: {
                    treeReaders[i] = DateStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).build();
                    continue block16;
                }
                default: {
                    throw new UnsupportedOperationException("Data type not supported yet! " + columnType);
                }
            }
        }
        return treeReaders;
    }

    protected static class BooleanStreamReader
    extends TreeReaderFactory.BooleanTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        private BooleanStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed) throws IOException {
            super(columnId, present, data);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public BooleanStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new BooleanStreamReader(this.columnIndex, present, data, isFileCompressed);
            }
        }
    }

    protected static class BinaryStreamReader
    extends TreeReaderFactory.BinaryTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private SettableUncompressedStream _lengthsStream;

        private BinaryStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream length, boolean isFileCompressed, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, length, encoding);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this._lengthsStream = length;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.stream.seek(index);
            }
            if (this.lengths != null && this._lengthsStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.lengths.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (this._lengthsStream != null) {
                this._lengthsStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData secondaryStream) {
                this.lengthStream = secondaryStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public BinaryStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new BinaryStreamReader(this.columnIndex, present, data, length, isFileCompressed, this.columnEncoding);
            }
        }
    }

    protected static class ByteStreamReader
    extends TreeReaderFactory.ByteTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        private ByteStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed) throws IOException {
            super(columnId, present, data);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public ByteStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new ByteStreamReader(this.columnIndex, present, data, isFileCompressed);
            }
        }
    }

    protected static class VarcharStreamReader
    extends TreeReaderFactory.VarcharTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private boolean _isDictionaryEncoding;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private SettableUncompressedStream _lengthStream;
        private SettableUncompressedStream _dictionaryStream;

        private VarcharStreamReader(int columnId, int maxLength, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream length, SettableUncompressedStream dictionary, boolean isFileCompressed, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, maxLength, present, data, length, dictionary, encoding);
            this._isDictionaryEncoding = dictionary != null;
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this._lengthStream = length;
            this._dictionaryStream = dictionary;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.getPresent().seek(index);
            }
            if (this._isDictionaryEncoding) {
                if (this._dataStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDictionaryTreeReader)this.reader).getReader().seek(index);
                }
            } else {
                if (this._dataStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getStream().seek(index);
                }
                if (this._lengthStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getLengths().seek(index);
                }
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (!this._isDictionaryEncoding && this._lengthStream != null) {
                this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
            if (!sameStripe && this._isDictionaryEncoding) {
                if (this._lengthStream != null) {
                    this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
                }
                if (this._dictionaryStream != null) {
                    this._dictionaryStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[3]));
                }
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private int maxLength;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData dictionaryStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setMaxLength(int maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData lengthStream) {
                this.lengthStream = lengthStream;
                return this;
            }

            public StreamReaderBuilder setDictionaryStream(EncodedColumnBatch.ColumnStreamData dictStream) {
                this.dictionaryStream = dictStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public VarcharStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                SettableUncompressedStream dictionary = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DICTIONARY_DATA.name(), this.dictionaryStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new VarcharStreamReader(this.columnIndex, this.maxLength, present, data, length, dictionary, isFileCompressed, this.columnEncoding);
            }
        }
    }

    protected static class CharStreamReader
    extends TreeReaderFactory.CharTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private boolean _isDictionaryEncoding;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private SettableUncompressedStream _lengthStream;
        private SettableUncompressedStream _dictionaryStream;

        private CharStreamReader(int columnId, int maxLength, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream length, SettableUncompressedStream dictionary, boolean isFileCompressed, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, maxLength, present, data, length, dictionary, encoding);
            this._isDictionaryEncoding = dictionary != null;
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this._lengthStream = length;
            this._dictionaryStream = dictionary;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.getPresent().seek(index);
            }
            if (this._isDictionaryEncoding) {
                if (this._dataStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDictionaryTreeReader)this.reader).getReader().seek(index);
                }
            } else {
                if (this._dataStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getStream().seek(index);
                }
                if (this._lengthStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getLengths().seek(index);
                }
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (!this._isDictionaryEncoding && this._lengthStream != null) {
                this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
            if (!sameStripe && this._isDictionaryEncoding) {
                if (this._lengthStream != null) {
                    this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
                }
                if (this._dictionaryStream != null) {
                    this._dictionaryStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[3]));
                }
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private int maxLength;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData dictionaryStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setMaxLength(int maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData lengthStream) {
                this.lengthStream = lengthStream;
                return this;
            }

            public StreamReaderBuilder setDictionaryStream(EncodedColumnBatch.ColumnStreamData dictStream) {
                this.dictionaryStream = dictStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public CharStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                SettableUncompressedStream dictionary = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DICTIONARY_DATA.name(), this.dictionaryStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new CharStreamReader(this.columnIndex, this.maxLength, present, data, length, dictionary, isFileCompressed, this.columnEncoding);
            }
        }
    }

    protected static class DateStreamReader
    extends TreeReaderFactory.DateTreeReader
    implements SettableTreeReader {
        private boolean isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        private DateStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, encoding);
            this.isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public DateStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new DateStreamReader(this.columnIndex, present, data, isFileCompressed, this.columnEncoding);
            }
        }
    }

    protected static class DecimalStreamReader
    extends TreeReaderFactory.DecimalTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _valueStream;
        private SettableUncompressedStream _scaleStream;

        private DecimalStreamReader(int columnId, int precision, int scale, SettableUncompressedStream presentStream, SettableUncompressedStream valueStream, SettableUncompressedStream scaleStream, boolean isFileCompressed, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, precision, scale, presentStream, valueStream, scaleStream, encoding);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = presentStream;
            this._valueStream = valueStream;
            this._scaleStream = scaleStream;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._valueStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.valueStream.seek(index);
            }
            if (this._scaleStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.scaleReader.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._valueStream != null) {
                this._valueStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (this._scaleStream != null) {
                this._scaleStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[5]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData valueStream;
            private EncodedColumnBatch.ColumnStreamData scaleStream;
            private int scale;
            private int precision;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPrecision(int precision) {
                this.precision = precision;
                return this;
            }

            public StreamReaderBuilder setScale(int scale) {
                this.scale = scale;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setValueStream(EncodedColumnBatch.ColumnStreamData valueStream) {
                this.valueStream = valueStream;
                return this;
            }

            public StreamReaderBuilder setScaleStream(EncodedColumnBatch.ColumnStreamData scaleStream) {
                this.scaleStream = scaleStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public DecimalStreamReader build() throws IOException {
                SettableUncompressedStream presentInStream = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream valueInStream = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.valueStream);
                SettableUncompressedStream scaleInStream = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.SECONDARY.name(), this.scaleStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new DecimalStreamReader(this.columnIndex, this.precision, this.scale, presentInStream, valueInStream, scaleInStream, isFileCompressed, this.columnEncoding);
            }
        }
    }

    protected static class DoubleStreamReader
    extends TreeReaderFactory.DoubleTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        private DoubleStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed) throws IOException {
            super(columnId, present, data);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.stream.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public DoubleStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new DoubleStreamReader(this.columnIndex, present, data, isFileCompressed);
            }
        }
    }

    protected static class FloatStreamReader
    extends TreeReaderFactory.FloatTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        private FloatStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed) throws IOException {
            super(columnId, present, data);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.stream.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public FloatStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new FloatStreamReader(this.columnIndex, present, data, isFileCompressed);
            }
        }
    }

    protected static class IntStreamReader
    extends TreeReaderFactory.IntTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        private IntStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, encoding);
            this._isFileCompressed = isFileCompressed;
            this._dataStream = data;
            this._presentStream = present;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public IntStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new IntStreamReader(this.columnIndex, present, data, isFileCompressed, this.columnEncoding);
            }
        }
    }

    protected static class LongStreamReader
    extends TreeReaderFactory.LongTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        private LongStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, boolean skipCorrupt) throws IOException {
            super(columnId, present, data, encoding, skipCorrupt);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private boolean skipCorrupt;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder skipCorrupt(boolean skipCorrupt) {
                this.skipCorrupt = skipCorrupt;
                return this;
            }

            public LongStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new LongStreamReader(this.columnIndex, present, data, isFileCompressed, this.columnEncoding, this.skipCorrupt);
            }
        }
    }

    protected static class ShortStreamReader
    extends TreeReaderFactory.ShortTreeReader
    implements SettableTreeReader {
        private boolean isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        private ShortStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, encoding);
            this.isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public ShortStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new ShortStreamReader(this.columnIndex, present, data, isFileCompressed, this.columnEncoding);
            }
        }
    }

    protected static class StringStreamReader
    extends TreeReaderFactory.StringTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private boolean _isDictionaryEncoding;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private SettableUncompressedStream _lengthStream;
        private SettableUncompressedStream _dictionaryStream;

        private StringStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream length, SettableUncompressedStream dictionary, boolean isFileCompressed, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, length, dictionary, encoding);
            this._isDictionaryEncoding = dictionary != null;
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this._lengthStream = length;
            this._dictionaryStream = dictionary;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.getPresent().seek(index);
            }
            if (this._isDictionaryEncoding) {
                if (this._dataStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDictionaryTreeReader)this.reader).getReader().seek(index);
                }
            } else {
                if (this._dataStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getStream().seek(index);
                }
                if (this._lengthStream.available() > 0) {
                    if (this._isFileCompressed) {
                        index.getNext();
                    }
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getLengths().seek(index);
                }
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (!this._isDictionaryEncoding && this._lengthStream != null) {
                this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
            if (!sameStripe && this._isDictionaryEncoding) {
                if (this._lengthStream != null) {
                    this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
                }
                if (this._dictionaryStream != null) {
                    this._dictionaryStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[3]));
                }
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData dictionaryStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData lengthStream) {
                this.lengthStream = lengthStream;
                return this;
            }

            public StreamReaderBuilder setDictionaryStream(EncodedColumnBatch.ColumnStreamData dictStream) {
                this.dictionaryStream = dictStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StringStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                SettableUncompressedStream dictionary = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DICTIONARY_DATA.name(), this.dictionaryStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new StringStreamReader(this.columnIndex, present, data, length, dictionary, isFileCompressed, this.columnEncoding);
            }
        }
    }

    public static class TimestampStreamReader
    extends TreeReaderFactory.TimestampTreeReader
    implements SettableTreeReader {
        private boolean isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _secondsStream;
        private SettableUncompressedStream _nanosStream;

        private TimestampStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream nanos, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, boolean skipCorrupt, String writerTimezoneId) throws IOException {
            super(columnId, present, data, nanos, encoding, skipCorrupt, writerTimezoneId);
            this.isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._secondsStream = data;
            this._nanosStream = nanos;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._secondsStream.available() > 0) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.data.seek(index);
            }
            if (this._nanosStream.available() > 0) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.nanos.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] streamsData, boolean sameStripe) throws IOException {
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._secondsStream != null) {
                this._secondsStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (this._nanosStream != null) {
                this._nanosStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[5]));
            }
        }

        public void updateTimezone(String writerTimezoneId) throws IOException {
            this.base_timestamp = this.getBaseTimestamp(writerTimezoneId);
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData nanosStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private boolean skipCorrupt;
            private String writerTimezone;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setSecondsStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setNanosStream(EncodedColumnBatch.ColumnStreamData secondaryStream) {
                this.nanosStream = secondaryStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setWriterTimezone(String writerTimezoneId) {
                this.writerTimezone = writerTimezoneId;
                return this;
            }

            public StreamReaderBuilder skipCorrupt(boolean skipCorrupt) {
                this.skipCorrupt = skipCorrupt;
                return this;
            }

            public TimestampStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream nanos = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.SECONDARY.name(), this.nanosStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new TimestampStreamReader(this.columnIndex, present, data, nanos, isFileCompressed, this.columnEncoding, this.skipCorrupt, this.writerTimezone);
            }
        }
    }

    public static interface SettableTreeReader {
        public void setBuffers(EncodedColumnBatch.ColumnStreamData[] var1, boolean var2) throws IOException;
    }
}

