/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.InputEstimator;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFetchOptimizer
extends Transform {
    private final Logger LOG = LoggerFactory.getLogger((String)SimpleFetchOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        HashMap<String, TableScanOperator> topOps = pctx.getTopOps();
        if (pctx.getQueryProperties().isQuery() && !pctx.getQueryProperties().isAnalyzeCommand() && topOps.size() == 1) {
            String alias = (String)pctx.getTopOps().keySet().toArray()[0];
            TableScanOperator topOp = pctx.getTopOps().values().iterator().next();
            try {
                FetchTask fetchTask = this.optimize(pctx, alias, topOp);
                if (fetchTask != null) {
                    pctx.setFetchTask(fetchTask);
                }
            }
            catch (Exception e) {
                this.LOG.error(StringUtils.stringifyException((Throwable)e));
                if (e instanceof SemanticException) {
                    throw (SemanticException)e;
                }
                throw new SemanticException(e.getMessage(), e);
            }
        }
        return pctx;
    }

    private FetchTask optimize(ParseContext pctx, String alias, TableScanOperator source) throws Exception {
        String mode = HiveConf.getVar(pctx.getConf(), HiveConf.ConfVars.HIVEFETCHTASKCONVERSION);
        boolean aggressive = "more".equals(mode);
        int limit = pctx.getQueryProperties().getOuterQueryLimit();
        FetchData fetch = this.checkTree(aggressive, pctx, alias, source);
        if (fetch != null && this.checkThreshold(fetch, limit, pctx)) {
            FetchWork fetchWork = fetch.convertToWork();
            FetchTask fetchTask = (FetchTask)TaskFactory.get(fetchWork, pctx.getConf(), new Task[0]);
            fetchWork.setSink(fetch.completed(pctx, fetchWork));
            fetchWork.setSource(source);
            fetchWork.setLimit(limit);
            return fetchTask;
        }
        return null;
    }

    private boolean checkThreshold(FetchData data, int limit, ParseContext pctx) throws Exception {
        long threshold;
        if (limit > 0) {
            if (data.hasOnlyPruningFilter()) {
                return true;
            }
            if (!data.isPartitioned() && !data.isFiltered()) {
                return true;
            }
        }
        if ((threshold = HiveConf.getLongVar(pctx.getConf(), HiveConf.ConfVars.HIVEFETCHTASKCONVERSIONTHRESHOLD)) < 0L) {
            return true;
        }
        Operator<OperatorDesc> child = data.scanOp.getChildOperators().get(0);
        if (child instanceof SelectOperator && this.checkExpressions((SelectOperator)child)) {
            return true;
        }
        long remaining = threshold;
        if ((remaining -= data.getInputLength(pctx, remaining)) < 0L) {
            this.LOG.info("Threshold " + remaining + " exceeded for pseudoMR mode");
            return false;
        }
        return true;
    }

    private FetchData checkTree(boolean aggressive, ParseContext pctx, String alias, TableScanOperator ts) throws HiveException {
        ExprNodeDesc pruner;
        SplitSample splitSample = pctx.getNameToSplitSample().get(alias);
        if (!aggressive && splitSample != null) {
            return null;
        }
        if (!aggressive && ((TableScanDesc)ts.getConf()).getTableSample() != null) {
            return null;
        }
        Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
        if (table == null) {
            return null;
        }
        ReadEntity parent = PlanUtils.getParentViewInfo(alias, pctx.getViewAliasToInput());
        if (!table.isPartitioned()) {
            FetchData fetch = new FetchData(ts, parent, table, splitSample);
            return this.checkOperators(fetch, aggressive, false);
        }
        boolean bypassFilter = false;
        if (HiveConf.getBoolVar(pctx.getConf(), HiveConf.ConfVars.HIVEOPTPPD) && PartitionPruner.onlyContainsPartnCols(table, pruner = pctx.getOpToPartPruner().get(ts))) {
            boolean bl = bypassFilter = !pctx.getPrunedPartitions(alias, ts).hasUnknownPartitions();
        }
        if (!aggressive && !bypassFilter) {
            return null;
        }
        PrunedPartitionList partitions = pctx.getPrunedPartitions(alias, ts);
        FetchData fetch = new FetchData(ts, parent, table, partitions, splitSample, bypassFilter);
        return this.checkOperators(fetch, aggressive, bypassFilter);
    }

    private FetchData checkOperators(FetchData fetch, boolean aggressive, boolean bypassFilter) {
        if (aggressive) {
            return this.isConvertible(fetch) ? fetch : null;
        }
        return this.checkOperators(fetch, fetch.scanOp, bypassFilter);
    }

    private FetchData checkOperators(FetchData fetch, TableScanOperator ts, boolean bypassFilter) {
        if (ts.getChildOperators().size() != 1) {
            return null;
        }
        Operator<OperatorDesc> op = ts.getChildOperators().get(0);
        while (true) {
            if (op instanceof SelectOperator) {
                if (!this.checkExpressions((SelectOperator)op)) {
                    return null;
                }
            } else {
                if (!(op instanceof LimitOperator) && (!(op instanceof FilterOperator) || !bypassFilter)) break;
                if (op.getChildOperators() == null || op.getChildOperators().size() != 1) {
                    return null;
                }
                if (op instanceof FilterOperator) {
                    fetch.setFiltered(true);
                }
            }
            op = op.getChildOperators().get(0);
        }
        if (op instanceof FileSinkOperator) {
            fetch.fileSink = op;
            return fetch;
        }
        return null;
    }

    private boolean checkExpressions(SelectOperator op) {
        SelectDesc desc = (SelectDesc)op.getConf();
        if (desc.isSelectStar() || desc.isSelStarNoCompute()) {
            return true;
        }
        for (ExprNodeDesc expr : desc.getColList()) {
            if (this.checkExpression(expr)) continue;
            return false;
        }
        return true;
    }

    private boolean checkExpression(ExprNodeDesc expr) {
        GenericUDF udf;
        if (expr instanceof ExprNodeConstantDesc || expr instanceof ExprNodeColumnDesc) {
            return true;
        }
        if (expr instanceof ExprNodeGenericFuncDesc && ((udf = ((ExprNodeGenericFuncDesc)expr).getGenericUDF()) instanceof GenericUDFToBinary || udf instanceof GenericUDFToChar || udf instanceof GenericUDFToDate || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToUnixTimeStamp || udf instanceof GenericUDFToUtcTimestamp || udf instanceof GenericUDFToVarchar)) {
            return expr.getChildren().size() == 1 && this.checkExpression(expr.getChildren().get(0));
        }
        return false;
    }

    private boolean isConvertible(FetchData fetch) {
        return this.isConvertible(fetch, fetch.scanOp, new HashSet());
    }

    private boolean isConvertible(FetchData fetch, Operator<?> operator, Set<Operator<?>> traversed) {
        if (operator instanceof ReduceSinkOperator || operator instanceof CommonJoinOperator || operator instanceof ScriptOperator) {
            return false;
        }
        if (operator instanceof FilterOperator) {
            fetch.setFiltered(true);
        }
        if (!traversed.add(operator)) {
            return true;
        }
        if (operator.getNumChild() == 0) {
            if (operator instanceof FileSinkOperator) {
                fetch.fileSink = operator;
                return true;
            }
            return false;
        }
        for (Operator<OperatorDesc> child : operator.getChildOperators()) {
            if (!traversed.containsAll(child.getParentOperators()) || this.isConvertible(fetch, child, traversed)) continue;
            return false;
        }
        return true;
    }

    public static ListSinkOperator replaceFSwithLS(Operator<?> fileSink, String nullFormat) {
        ListSinkDesc desc = new ListSinkDesc(nullFormat);
        ListSinkOperator sink = (ListSinkOperator)OperatorFactory.get(fileSink.getCompilationOpContext(), desc);
        sink.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
        Operator<OperatorDesc> parent = fileSink.getParentOperators().get(0);
        sink.getParentOperators().add(parent);
        parent.replaceChild(fileSink, sink);
        fileSink.setParentOperators(null);
        return sink;
    }

    private class FetchData {
        private final TableScanOperator scanOp;
        private final ReadEntity parent;
        private final Table table;
        private final SplitSample splitSample;
        private final PrunedPartitionList partsList;
        private final Set<ReadEntity> inputs = new LinkedHashSet<ReadEntity>();
        private final boolean onlyPruningFilter;
        private Operator<?> fileSink;
        private boolean filtered;

        private FetchData(TableScanOperator scanOp, ReadEntity parent, Table table, SplitSample splitSample) {
            this.scanOp = scanOp;
            this.parent = parent;
            this.table = table;
            this.partsList = null;
            this.splitSample = splitSample;
            this.onlyPruningFilter = false;
        }

        private FetchData(TableScanOperator scanOp, ReadEntity parent, Table table, PrunedPartitionList partsList, SplitSample splitSample, boolean bypassFilter) {
            this.scanOp = scanOp;
            this.parent = parent;
            this.table = table;
            this.partsList = partsList;
            this.splitSample = splitSample;
            this.onlyPruningFilter = bypassFilter;
        }

        public final boolean hasOnlyPruningFilter() {
            return this.onlyPruningFilter;
        }

        public final boolean isPartitioned() {
            return this.table.isPartitioned();
        }

        public final boolean isFiltered() {
            return this.filtered;
        }

        public final void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }

        private FetchWork convertToWork() throws HiveException {
            this.inputs.clear();
            Utilities.addSchemaEvolutionToTableScanOperator(this.table, this.scanOp);
            TableDesc tableDesc = Utilities.getTableDesc(this.table);
            if (!this.table.isPartitioned()) {
                this.inputs.add(new ReadEntity(this.table, this.parent, !this.table.isView() && this.parent == null));
                FetchWork work = new FetchWork(this.table.getPath(), tableDesc);
                PlanUtils.configureInputJobPropertiesForStorageHandler(work.getTblDesc());
                work.setSplitSample(this.splitSample);
                return work;
            }
            ArrayList<Path> listP = new ArrayList<Path>();
            ArrayList<PartitionDesc> partP = new ArrayList<PartitionDesc>();
            for (Partition partition : this.partsList.getNotDeniedPartns()) {
                this.inputs.add(new ReadEntity(partition, this.parent, this.parent == null));
                listP.add(partition.getDataLocation());
                partP.add(Utilities.getPartitionDescFromTableDesc(tableDesc, partition, true));
            }
            Table sourceTable = this.partsList.getSourceTable();
            this.inputs.add(new ReadEntity(sourceTable, this.parent, this.parent == null));
            TableDesc table = Utilities.getTableDesc(sourceTable);
            FetchWork work = new FetchWork(listP, partP, table);
            if (!work.getPartDesc().isEmpty()) {
                PartitionDesc part0 = work.getPartDesc().get(0);
                PlanUtils.configureInputJobPropertiesForStorageHandler(part0.getTableDesc());
                work.setSplitSample(this.splitSample);
            }
            return work;
        }

        private ListSinkOperator completed(ParseContext pctx, FetchWork work) {
            for (ReadEntity input : this.inputs) {
                PlanUtils.addInput(pctx.getSemanticInputs(), input);
            }
            return SimpleFetchOptimizer.replaceFSwithLS(this.fileSink, work.getSerializationNullFormat());
        }

        private long getInputLength(ParseContext pctx, long remaining) throws Exception {
            if (this.splitSample != null && this.splitSample.getTotalLength() != null) {
                return this.splitSample.getTotalLength();
            }
            if (this.splitSample != null) {
                return this.splitSample.getTargetSize(this.calculateLength(pctx, this.splitSample.estimateSourceSize(remaining)));
            }
            return this.calculateLength(pctx, remaining);
        }

        private long calculateLength(ParseContext pctx, long remaining) throws Exception {
            Partition partition;
            Path path;
            JobConf jobConf = new JobConf((Configuration)pctx.getConf());
            Utilities.setColumnNameList(jobConf, this.scanOp, true);
            Utilities.setColumnTypeList(jobConf, this.scanOp, true);
            HiveStorageHandler handler = this.table.getStorageHandler();
            if (handler instanceof InputEstimator) {
                InputEstimator estimator = (InputEstimator)((Object)handler);
                TableDesc tableDesc = Utilities.getTableDesc(this.table);
                PlanUtils.configureInputJobPropertiesForStorageHandler(tableDesc);
                Utilities.copyTableJobPropertiesToConf(tableDesc, (Configuration)jobConf);
                return estimator.estimate(jobConf, this.scanOp, remaining).getTotalLength();
            }
            if (this.table.isNonNative()) {
                return 0L;
            }
            if (!this.table.isPartitioned()) {
                return this.getFileLength(jobConf, this.table.getPath(), this.table.getInputFormatClass());
            }
            long total = 0L;
            Iterator<Partition> iterator = this.partsList.getNotDeniedPartns().iterator();
            while (iterator.hasNext() && (total += this.getFileLength(jobConf, path = (partition = iterator.next()).getDataLocation(), partition.getInputFormatClass())) <= remaining) {
            }
            return total;
        }

        private long getFileLength(JobConf conf, Path path, Class<? extends InputFormat> clazz) throws IOException {
            ContentSummary summary;
            if (ContentSummaryInputFormat.class.isAssignableFrom(clazz)) {
                InputFormat<WritableComparable, Writable> input = HiveInputFormat.getInputFormatFromCache(clazz, conf);
                summary = ((ContentSummaryInputFormat)input).getContentSummary(path, conf);
            } else {
                FileSystem fs = path.getFileSystem((Configuration)conf);
                try {
                    summary = fs.getContentSummary(path);
                }
                catch (FileNotFoundException e) {
                    return 0L;
                }
            }
            return summary.getLength();
        }
    }
}

