/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileMergeOperator<T extends FileMergeDesc>
extends Operator<T>
implements Serializable {
    public static final String BACKUP_PREFIX = "_backup.";
    public static final Logger LOG = LoggerFactory.getLogger(AbstractFileMergeOperator.class);
    protected JobConf jc;
    protected FileSystem fs;
    protected boolean autoDelete;
    protected boolean exception;
    protected Path outPath;
    protected Path finalPath;
    protected Path dpPath;
    protected Path tmpPath;
    protected Path taskTmpPath;
    protected int listBucketingDepth;
    protected boolean hasDynamicPartitions;
    protected boolean isListBucketingAlterTableConcatenate;
    protected boolean tmpPathFixedConcatenate;
    protected boolean tmpPathFixed;
    protected Set<Path> incompatFileSet;
    protected transient DynamicPartitionCtx dpCtx;

    protected AbstractFileMergeOperator() {
    }

    public AbstractFileMergeOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.jc = new JobConf(hconf);
        this.incompatFileSet = new HashSet<Path>();
        this.autoDelete = false;
        this.exception = false;
        this.tmpPathFixed = false;
        this.tmpPathFixedConcatenate = false;
        this.outPath = null;
        this.finalPath = null;
        this.dpPath = null;
        this.tmpPath = null;
        this.taskTmpPath = null;
        this.dpCtx = ((FileMergeDesc)this.conf).getDpCtx();
        this.hasDynamicPartitions = ((FileMergeDesc)this.conf).hasDynamicPartitions();
        this.isListBucketingAlterTableConcatenate = ((FileMergeDesc)this.conf).isListBucketingAlterTableConcatenate();
        this.listBucketingDepth = ((FileMergeDesc)this.conf).getListBucketingDepth();
        Path specPath = ((FileMergeDesc)this.conf).getOutputPath();
        this.updatePaths(Utilities.toTempPath(specPath), Utilities.toTaskTempPath(specPath));
        try {
            this.fs = specPath.getFileSystem(hconf);
            this.autoDelete = this.fs.deleteOnExit(this.outPath);
        }
        catch (IOException e) {
            this.exception = true;
            throw new HiveException("Failed to initialize AbstractFileMergeOperator", e);
        }
    }

    private void updatePaths(Path tp, Path ttp) {
        String taskId = Utilities.getTaskId((Configuration)this.jc);
        this.tmpPath = tp;
        this.taskTmpPath = ttp;
        this.finalPath = new Path(tp, taskId);
        this.outPath = new Path(ttp, Utilities.toTempPath(taskId));
    }

    protected void fixTmpPath(Path inputPath, int depthDiff) throws IOException {
        if (depthDiff <= 0) {
            return;
        }
        this.dpPath = inputPath;
        Path newPath = new Path(".");
        while (inputPath != null && depthDiff > 0) {
            newPath = new Path(inputPath.getName(), newPath);
            --depthDiff;
            inputPath = inputPath.getParent();
        }
        Path newTmpPath = new Path(this.tmpPath, newPath);
        Path newTaskTmpPath = new Path(this.taskTmpPath, newPath);
        if (!this.fs.exists(newTmpPath)) {
            this.fs.mkdirs(newTmpPath);
        }
        this.updatePaths(newTmpPath, newTaskTmpPath);
    }

    protected void checkPartitionsMatch(Path inputPath) throws IOException {
        if (!this.dpPath.equals((Object)inputPath)) {
            String msg = "Multiple partitions for one merge mapper: " + this.dpPath + " NOT EQUAL TO " + inputPath;
            LOG.error(msg);
            throw new IOException(msg);
        }
    }

    protected void fixTmpPath(Path path) throws IOException {
        if (this.isListBucketingAlterTableConcatenate) {
            if (this.tmpPathFixedConcatenate) {
                this.checkPartitionsMatch(path);
            } else {
                this.fixTmpPath(path, this.listBucketingDepth);
                this.tmpPathFixedConcatenate = true;
            }
        } else if (this.hasDynamicPartitions || this.listBucketingDepth > 0) {
            if (this.tmpPathFixed) {
                this.checkPartitionsMatch(path);
            } else {
                int depthDiff = path.depth() - this.tmpPath.depth();
                this.fixTmpPath(path, depthDiff);
                this.tmpPathFixed = true;
            }
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        try {
            if (!abort) {
                if (this.fs.exists(this.outPath)) {
                    FileStatus fss = this.fs.getFileStatus(this.outPath);
                    if (!this.fs.rename(this.outPath, this.finalPath)) {
                        throw new IOException("Unable to rename " + this.outPath + " to " + this.finalPath);
                    }
                    LOG.info("renamed path " + this.outPath + " to " + this.finalPath + " . File" + " size is " + fss.getLen());
                }
                if (this.incompatFileSet != null && !this.incompatFileSet.isEmpty()) {
                    for (Path incompatFile : this.incompatFileSet) {
                        Path destDir = this.finalPath.getParent();
                        try {
                            Utilities.renameOrMoveFiles(this.fs, incompatFile, destDir);
                            LOG.info("Moved incompatible file " + incompatFile + " to " + destDir);
                        }
                        catch (HiveException e) {
                            LOG.error("Unable to move " + incompatFile + " to " + destDir);
                            throw new IOException(e);
                        }
                    }
                }
            } else if (!this.autoDelete) {
                this.fs.delete(this.outPath, true);
            }
        }
        catch (IOException e) {
            throw new HiveException("Failed to close AbstractFileMergeOperator", e);
        }
    }

    @Override
    public void jobCloseOp(Configuration hconf, boolean success) throws HiveException {
        try {
            Path outputDir = ((FileMergeDesc)this.conf).getOutputPath();
            FileSystem fs = outputDir.getFileSystem(hconf);
            Path backupPath = this.backupOutputPath(fs, outputDir);
            Utilities.mvFileToFinalPath(outputDir, hconf, success, LOG, ((FileMergeDesc)this.conf).getDpCtx(), null, this.reporter);
            if (success) {
                LOG.info("jobCloseOp moved merged files to output dir: " + outputDir);
            }
            if (backupPath != null) {
                fs.delete(backupPath, true);
            }
        }
        catch (IOException e) {
            throw new HiveException("Failed jobCloseOp for AbstractFileMergeOperator", e);
        }
        super.jobCloseOp(hconf, success);
    }

    private Path backupOutputPath(FileSystem fs, Path outpath) throws IOException, HiveException {
        if (fs.exists(outpath)) {
            Path backupPath = new Path(outpath.getParent(), BACKUP_PREFIX + outpath.getName());
            Utilities.rename(fs, outpath, backupPath);
            return backupPath;
        }
        return null;
    }

    @Override
    public String getName() {
        return AbstractFileMergeOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MERGE";
    }
}

