/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTask
extends Task<CopyWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(CopyTask.class);

    @Override
    public int execute(DriverContext driverContext) {
        FileSystem dstFs = null;
        Path toPath = null;
        try {
            Path fromPath = ((CopyWork)this.work).getFromPath();
            toPath = ((CopyWork)this.work).getToPath();
            this.console.printInfo("Copying data from " + fromPath.toString(), " to " + toPath.toString());
            FileSystem srcFs = fromPath.getFileSystem((Configuration)this.conf);
            dstFs = toPath.getFileSystem((Configuration)this.conf);
            FileStatus[] srcs = LoadSemanticAnalyzer.matchFilesOrDir(srcFs, fromPath);
            if (srcs == null || srcs.length == 0) {
                if (((CopyWork)this.work).isErrorOnSrcEmpty()) {
                    this.console.printError("No files matching path: " + fromPath.toString());
                    return 3;
                }
                return 0;
            }
            boolean inheritPerms = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
            if (!FileUtils.mkdir(dstFs, toPath, inheritPerms, this.conf)) {
                this.console.printError("Cannot make target directory: " + toPath.toString());
                return 2;
            }
            for (FileStatus oneSrc : srcs) {
                this.console.printInfo("Copying file: " + oneSrc.getPath().toString());
                LOG.debug("Copying file: " + oneSrc.getPath().toString());
                if (FileUtils.copy(srcFs, oneSrc.getPath(), dstFs, toPath, false, true, this.conf)) continue;
                this.console.printError("Failed to copy: '" + oneSrc.getPath().toString() + "to: '" + toPath.toString() + "'");
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    @Override
    public StageType getType() {
        return StageType.COPY;
    }

    @Override
    public String getName() {
        return "COPY";
    }
}

