/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.arrow;

import io.netty.buffer.ArrowBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.arrow.ArrowColumnarBatchSerDe;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Writable;

class Deserializer {
    private final ArrowColumnarBatchSerDe serDe;
    private final VectorExtractRow vectorExtractRow;
    private final VectorizedRowBatch vectorizedRowBatch;
    private Object[][] rows;

    Deserializer(ArrowColumnarBatchSerDe serDe) throws SerDeException {
        this.serDe = serDe;
        this.vectorExtractRow = new VectorExtractRow();
        ArrayList<TypeInfo> fieldTypeInfoList = serDe.rowTypeInfo.getAllStructFieldTypeInfos();
        int fieldCount = fieldTypeInfoList.size();
        TypeInfo[] typeInfos = fieldTypeInfoList.toArray(new TypeInfo[fieldCount]);
        try {
            this.vectorExtractRow.init(typeInfos);
        }
        catch (HiveException e) {
            throw new SerDeException(e);
        }
        this.vectorizedRowBatch = new VectorizedRowBatch(fieldCount);
        for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
            ColumnVector columnVector = VectorizedBatchUtil.createColumnVector(typeInfos[fieldIndex]);
            columnVector.init();
            this.vectorizedRowBatch.cols[fieldIndex] = columnVector;
        }
    }

    public Object deserialize(Writable writable) {
        int rowIndex;
        ArrowWrapperWritable arrowWrapperWritable = (ArrowWrapperWritable)writable;
        VectorSchemaRoot vectorSchemaRoot = arrowWrapperWritable.getVectorSchemaRoot();
        List fieldVectors = vectorSchemaRoot.getFieldVectors();
        int fieldCount = fieldVectors.size();
        int rowCount = vectorSchemaRoot.getRowCount();
        this.vectorizedRowBatch.ensureSize(rowCount);
        if (this.rows == null || this.rows.length < rowCount) {
            this.rows = new Object[rowCount][];
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.rows[rowIndex] = new Object[fieldCount];
            }
        }
        for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
            FieldVector fieldVector = (FieldVector)fieldVectors.get(fieldIndex);
            int projectedCol = this.vectorizedRowBatch.projectedColumns[fieldIndex];
            ColumnVector columnVector = this.vectorizedRowBatch.cols[projectedCol];
            TypeInfo typeInfo = this.serDe.rowTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
            this.read(fieldVector, columnVector, typeInfo);
        }
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.vectorExtractRow.extractRow(this.vectorizedRowBatch, rowIndex, this.rows[rowIndex]);
        }
        this.vectorizedRowBatch.reset();
        return this.rows;
    }

    private void read(FieldVector arrowVector, ColumnVector hiveVector, TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                this.readPrimitive(arrowVector, hiveVector);
                break;
            }
            case LIST: {
                this.readList(arrowVector, (ListColumnVector)hiveVector, (ListTypeInfo)typeInfo);
                break;
            }
            case MAP: {
                this.readMap(arrowVector, (MapColumnVector)hiveVector, (MapTypeInfo)typeInfo);
                break;
            }
            case STRUCT: {
                this.readStruct(arrowVector, (StructColumnVector)hiveVector, (StructTypeInfo)typeInfo);
                break;
            }
            case UNION: {
                this.readUnion(arrowVector, (UnionColumnVector)hiveVector, (UnionTypeInfo)typeInfo);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void readPrimitive(FieldVector arrowVector, ColumnVector hiveVector) {
        Types.MinorType minorType = arrowVector.getMinorType();
        int size = arrowVector.getValueCount();
        hiveVector.ensureSize(size, false);
        switch (minorType) {
            case BIT: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((LongColumnVector)hiveVector).vector[i] = ((BitVector)arrowVector).get(i);
                }
                break;
            }
            case TINYINT: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((LongColumnVector)hiveVector).vector[i] = ((TinyIntVector)arrowVector).get(i);
                }
                break;
            }
            case SMALLINT: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((LongColumnVector)hiveVector).vector[i] = ((SmallIntVector)arrowVector).get(i);
                }
                break;
            }
            case INT: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((LongColumnVector)hiveVector).vector[i] = ((IntVector)arrowVector).get(i);
                }
                break;
            }
            case BIGINT: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((LongColumnVector)hiveVector).vector[i] = ((BigIntVector)arrowVector).get(i);
                }
                break;
            }
            case FLOAT4: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((DoubleColumnVector)hiveVector).vector[i] = ((Float4Vector)arrowVector).get(i);
                }
                break;
            }
            case FLOAT8: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((DoubleColumnVector)hiveVector).vector[i] = ((Float8Vector)arrowVector).get(i);
                }
                break;
            }
            case VARCHAR: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((BytesColumnVector)hiveVector).setVal(i, ((VarCharVector)arrowVector).get(i));
                }
                break;
            }
            case DATEDAY: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((LongColumnVector)hiveVector).vector[i] = ((DateDayVector)arrowVector).get(i);
                }
                break;
            }
            case TIMESTAMPMILLI: 
            case TIMESTAMPMILLITZ: 
            case TIMESTAMPMICROTZ: 
            case TIMESTAMPMICRO: 
            case TIMESTAMPNANOTZ: 
            case TIMESTAMPNANO: {
                for (int i = 0; i < size; ++i) {
                    long second;
                    int subSecondInNanos;
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    long time = ((TimeStampVector)arrowVector).get(i);
                    switch (minorType) {
                        case TIMESTAMPMILLI: 
                        case TIMESTAMPMILLITZ: {
                            subSecondInNanos = (int)(time % 1000L * 1000000L);
                            second = time / 1000L;
                            break;
                        }
                        case TIMESTAMPMICROTZ: 
                        case TIMESTAMPMICRO: {
                            subSecondInNanos = (int)(time % 1000000L * 1000L);
                            second = time / 1000000L;
                            break;
                        }
                        case TIMESTAMPNANOTZ: 
                        case TIMESTAMPNANO: {
                            subSecondInNanos = (int)(time % 1000000000L);
                            second = time / 1000000000L;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    TimestampColumnVector timestampColumnVector = (TimestampColumnVector)hiveVector;
                    if (subSecondInNanos < 0) {
                        subSecondInNanos += 1000000000;
                        --second;
                    }
                    timestampColumnVector.time[i] = second * 1000L;
                    timestampColumnVector.nanos[i] = subSecondInNanos;
                }
                break;
            }
            case VARBINARY: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((BytesColumnVector)hiveVector).setVal(i, ((VarBinaryVector)arrowVector).get(i));
                }
                break;
            }
            case DECIMAL: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((DecimalColumnVector)hiveVector).set(i, HiveDecimal.create(((DecimalVector)arrowVector).getObject(i)));
                }
                break;
            }
            case INTERVALYEAR: {
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    ((LongColumnVector)hiveVector).vector[i] = ((IntervalYearVector)arrowVector).get(i);
                }
                break;
            }
            case INTERVALDAY: {
                IntervalDayVector intervalDayVector = (IntervalDayVector)arrowVector;
                NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
                HiveIntervalDayTime intervalDayTime = new HiveIntervalDayTime();
                for (int i = 0; i < size; ++i) {
                    if (arrowVector.isNull(i)) {
                        VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                        continue;
                    }
                    hiveVector.isNull[i] = false;
                    intervalDayVector.get(i, intervalDayHolder);
                    long seconds = intervalDayHolder.days * 86400 + intervalDayHolder.milliseconds / 1000;
                    int nanos = intervalDayHolder.milliseconds % 1000 * 1000000;
                    intervalDayTime.set(seconds, nanos);
                    ((IntervalDayTimeColumnVector)hiveVector).set(i, intervalDayTime);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void readList(FieldVector arrowVector, ListColumnVector hiveVector, ListTypeInfo typeInfo) {
        int size = arrowVector.getValueCount();
        ArrowBuf offsets = arrowVector.getOffsetBuffer();
        int OFFSET_WIDTH = 4;
        this.read((FieldVector)arrowVector.getChildrenFromFields().get(0), hiveVector.child, typeInfo.getListElementTypeInfo());
        for (int i = 0; i < size; ++i) {
            if (arrowVector.isNull(i)) {
                VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                continue;
            }
            hiveVector.isNull[i] = false;
            int offset = offsets.getInt(i * 4);
            hiveVector.offsets[i] = offset;
            hiveVector.lengths[i] = offsets.getInt((i + 1) * 4) - offset;
        }
    }

    private void readMap(FieldVector arrowVector, MapColumnVector hiveVector, MapTypeInfo typeInfo) {
        int size = arrowVector.getValueCount();
        ListTypeInfo mapStructListTypeInfo = ArrowColumnarBatchSerDe.toStructListTypeInfo(typeInfo);
        ListColumnVector mapStructListVector = ArrowColumnarBatchSerDe.toStructListVector(hiveVector);
        StructColumnVector mapStructVector = (StructColumnVector)mapStructListVector.child;
        this.read(arrowVector, mapStructListVector, mapStructListTypeInfo);
        hiveVector.isRepeating = mapStructListVector.isRepeating;
        hiveVector.childCount = mapStructListVector.childCount;
        hiveVector.noNulls = mapStructListVector.noNulls;
        hiveVector.keys = mapStructVector.fields[0];
        hiveVector.values = mapStructVector.fields[1];
        System.arraycopy(mapStructListVector.offsets, 0, hiveVector.offsets, 0, size);
        System.arraycopy(mapStructListVector.lengths, 0, hiveVector.lengths, 0, size);
        System.arraycopy(mapStructListVector.isNull, 0, hiveVector.isNull, 0, size);
    }

    private void readStruct(FieldVector arrowVector, StructColumnVector hiveVector, StructTypeInfo typeInfo) {
        int i;
        int size = arrowVector.getValueCount();
        ArrayList<TypeInfo> fieldTypeInfos = typeInfo.getAllStructFieldTypeInfos();
        int fieldSize = arrowVector.getChildrenFromFields().size();
        for (i = 0; i < fieldSize; ++i) {
            this.read((FieldVector)arrowVector.getChildrenFromFields().get(i), hiveVector.fields[i], (TypeInfo)fieldTypeInfos.get(i));
        }
        for (i = 0; i < size; ++i) {
            if (arrowVector.isNull(i)) {
                VectorizedBatchUtil.setNullColIsNullValue(hiveVector, i);
                continue;
            }
            hiveVector.isNull[i] = false;
        }
    }

    private void readUnion(FieldVector arrowVector, UnionColumnVector hiveVector, UnionTypeInfo typeInfo) {
    }
}

