/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.decode.EncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedTreeReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.orc.impl.TreeReaderFactory;

public class OrcEncodedDataConsumer
extends EncodedDataConsumer<OrcBatchKey, Reader.OrcEncodedColumnBatch> {
    private TreeReaderFactory.TreeReader[] columnReaders;
    private int previousStripeIndex = -1;
    private OrcFileMetadata fileMetadata;
    private CompressionCodec codec;
    private OrcStripeMetadata[] stripes;
    private final boolean skipCorrupt;
    private final QueryFragmentCounters counters;
    private boolean[] includedColumns;

    public OrcEncodedDataConsumer(Consumer<ColumnVectorBatch> consumer, int colCount, boolean skipCorrupt, QueryFragmentCounters counters, LlapDaemonIOMetrics ioMetrics) {
        super(consumer, colCount, ioMetrics);
        this.skipCorrupt = skipCorrupt;
        this.counters = counters;
    }

    public void setFileMetadata(OrcFileMetadata f) {
        assert (this.fileMetadata == null);
        this.fileMetadata = f;
        this.stripes = new OrcStripeMetadata[f.getStripes().size()];
        this.codec = WriterImpl.createCodec((CompressionKind)this.fileMetadata.getCompressionKind());
    }

    public void setStripeMetadata(OrcStripeMetadata m) {
        assert (this.stripes != null);
        this.stripes[m.getStripeIx()] = m;
    }

    private static ColumnVector createColumn(List<OrcProto.Type> types, int columnId, int batchSize) {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongColumnVector(batchSize);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleColumnVector(batchSize);
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new BytesColumnVector(batchSize);
            }
            case TIMESTAMP: {
                return new TimestampColumnVector(batchSize);
            }
            case DECIMAL: {
                return new DecimalColumnVector(batchSize, type.getPrecision(), type.getScale());
            }
            case STRUCT: {
                List subtypeIdxs = type.getSubtypesList();
                ColumnVector[] fieldVector = new ColumnVector[subtypeIdxs.size()];
                for (int i = 0; i < fieldVector.length; ++i) {
                    fieldVector[i] = OrcEncodedDataConsumer.createColumn(types, (Integer)subtypeIdxs.get(i), batchSize);
                }
                return new StructColumnVector(batchSize, fieldVector);
            }
            case UNION: {
                List subtypeIdxs = type.getSubtypesList();
                ColumnVector[] fieldVector = new ColumnVector[subtypeIdxs.size()];
                for (int i = 0; i < fieldVector.length; ++i) {
                    fieldVector[i] = OrcEncodedDataConsumer.createColumn(types, (Integer)subtypeIdxs.get(i), batchSize);
                }
                return new UnionColumnVector(batchSize, fieldVector);
            }
            case LIST: {
                return new ListColumnVector(batchSize, OrcEncodedDataConsumer.createColumn(types, type.getSubtypes(0), batchSize));
            }
            case MAP: {
                return new MapColumnVector(batchSize, OrcEncodedDataConsumer.createColumn(types, type.getSubtypes(0), batchSize), OrcEncodedDataConsumer.createColumn(types, type.getSubtypes(1), batchSize));
            }
        }
        throw new IllegalArgumentException("LLAP does not support " + type.getKind());
    }

    @Override
    protected void decodeBatch(Reader.OrcEncodedColumnBatch batch, Consumer<ColumnVectorBatch> downstreamConsumer) {
        long startTime = this.counters.startTimeCounter();
        int currentStripeIndex = ((OrcBatchKey)batch.getBatchKey()).stripeIx;
        boolean sameStripe = currentStripeIndex == this.previousStripeIndex;
        try {
            OrcStripeMetadata stripeMetadata = this.stripes[currentStripeIndex];
            int rgIdx = ((OrcBatchKey)batch.getBatchKey()).rgIx;
            long nonNullRowCount = -1L;
            if (rgIdx == -1) {
                nonNullRowCount = stripeMetadata.getRowCount();
            } else {
                OrcProto.RowIndexEntry rowIndex = stripeMetadata.getRowIndexes()[0].getEntry(rgIdx);
                nonNullRowCount = this.getRowCount(rowIndex);
            }
            int maxBatchesRG = (int)(nonNullRowCount / 1024L + 1L);
            int batchSize = 1024;
            int numCols = batch.getColumnIxs().length;
            if (this.columnReaders == null || !sameStripe) {
                this.columnReaders = EncodedTreeReaderFactory.createEncodedTreeReader((int)numCols, this.fileMetadata.getTypes(), stripeMetadata.getEncodings(), (EncodedColumnBatch)batch, (CompressionCodec)this.codec, (boolean)this.skipCorrupt, (String)stripeMetadata.getWriterTimezone());
                this.positionInStreams(this.columnReaders, (EncodedColumnBatch<OrcBatchKey>)batch, numCols, stripeMetadata);
            } else {
                this.repositionInStreams(this.columnReaders, (EncodedColumnBatch<OrcBatchKey>)batch, sameStripe, numCols, stripeMetadata);
            }
            this.previousStripeIndex = currentStripeIndex;
            for (int i = 0; i < maxBatchesRG && (i != maxBatchesRG - 1 || (batchSize = (int)(nonNullRowCount % 1024L)) != 0); ++i) {
                ColumnVectorBatch cvb = (ColumnVectorBatch)this.cvbPool.take();
                assert (cvb.cols.length == batch.getColumnIxs().length);
                cvb.size = batchSize;
                List<OrcProto.Type> types = this.fileMetadata.getTypes();
                int[] columnMapping = batch.getColumnIxs();
                for (int idx = 0; idx < batch.getColumnIxs().length; ++idx) {
                    if (cvb.cols[idx] == null) {
                        cvb.cols[idx] = OrcEncodedDataConsumer.createColumn(types, columnMapping[idx], batchSize);
                    }
                    cvb.cols[idx].ensureSize(batchSize, false);
                    this.columnReaders[idx].nextVector(cvb.cols[idx], null, batchSize);
                }
                downstreamConsumer.consumeData((Object)cvb);
                this.counters.incrCounter(LlapIOCounters.ROWS_EMITTED, batchSize);
            }
            this.counters.incrTimeCounter(LlapIOCounters.DECODE_TIME_NS, startTime);
            this.counters.incrCounter(LlapIOCounters.NUM_VECTOR_BATCHES, maxBatchesRG);
            this.counters.incrCounter(LlapIOCounters.NUM_DECODED_BATCHES);
        }
        catch (IOException e) {
            downstreamConsumer.setError((Throwable)e);
        }
    }

    private void positionInStreams(TreeReaderFactory.TreeReader[] columnReaders, EncodedColumnBatch<OrcBatchKey> batch, int numCols, OrcStripeMetadata stripeMetadata) throws IOException {
        for (int i = 0; i < numCols; ++i) {
            int columnIndex = batch.getColumnIxs()[i];
            int rowGroupIndex = ((OrcBatchKey)batch.getBatchKey()).rgIx;
            OrcProto.RowIndex rowIndex = stripeMetadata.getRowIndexes()[columnIndex];
            OrcProto.RowIndexEntry rowIndexEntry = rowIndex.getEntry(rowGroupIndex);
            columnReaders[i].seek((PositionProvider)new RecordReaderImpl.PositionProviderImpl(rowIndexEntry));
        }
    }

    private void repositionInStreams(TreeReaderFactory.TreeReader[] columnReaders, EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe, int numCols, OrcStripeMetadata stripeMetadata) throws IOException {
        for (int i = 0; i < numCols; ++i) {
            int columnIndex = batch.getColumnIxs()[i];
            int rowGroupIndex = ((OrcBatchKey)batch.getBatchKey()).rgIx;
            EncodedColumnBatch.ColumnStreamData[] streamBuffers = batch.getColumnData()[i];
            OrcProto.RowIndex rowIndex = stripeMetadata.getRowIndexes()[columnIndex];
            OrcProto.RowIndexEntry rowIndexEntry = rowIndex.getEntry(rowGroupIndex);
            ((EncodedTreeReaderFactory.SettableTreeReader)columnReaders[i]).setBuffers(streamBuffers, sameStripe);
            if (columnReaders[i] instanceof EncodedTreeReaderFactory.TimestampStreamReader && !sameStripe) {
                ((EncodedTreeReaderFactory.TimestampStreamReader)columnReaders[i]).updateTimezone(stripeMetadata.getWriterTimezone());
            }
            columnReaders[i].seek((PositionProvider)new RecordReaderImpl.PositionProviderImpl(rowIndexEntry));
        }
    }

    private long getRowCount(OrcProto.RowIndexEntry rowIndexEntry) {
        return rowIndexEntry.getStatistics().getNumberOfValues();
    }

    @Override
    public TypeDescription getFileSchema() {
        return OrcUtils.convertTypeFromProtobuf(this.fileMetadata.getTypes(), (int)0);
    }

    @Override
    public boolean[] getIncludedColumns() {
        return this.includedColumns;
    }

    public void setIncludedColumns(boolean[] includedColumns) {
        this.includedColumns = includedColumns;
    }
}

