/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.jsr166.ConcurrentHashMap8;

public class H2Schema {
    private final String schemaName;
    private final GridUnsafeMemory offheap = null;
    private final ConcurrentMap<String, H2TableDescriptor> tbls = new ConcurrentHashMap8();
    private final ConcurrentMap<String, H2TableDescriptor> typeToTbl = new ConcurrentHashMap8();

    public H2Schema(String schemaName) {
        this.schemaName = schemaName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public GridUnsafeMemory offheap() {
        return this.offheap;
    }

    public Collection<H2TableDescriptor> tables() {
        return this.tbls.values();
    }

    public H2TableDescriptor tableByName(String tblName) {
        return (H2TableDescriptor)this.tbls.get(tblName);
    }

    public H2TableDescriptor tableByTypeName(String typeName) {
        return (H2TableDescriptor)this.typeToTbl.get(typeName);
    }

    public void add(H2TableDescriptor tbl) {
        if (this.tbls.putIfAbsent(tbl.tableName(), tbl) != null) {
            throw new IllegalStateException("Table already registered: " + tbl.fullTableName());
        }
        if (this.typeToTbl.putIfAbsent(tbl.typeName(), tbl) != null) {
            throw new IllegalStateException("Table already registered: " + tbl.fullTableName());
        }
    }

    public void remove(H2TableDescriptor tbl) {
        this.tbls.remove(tbl.tableName());
        this.typeToTbl.remove(tbl.typeName());
    }

    public void drop(H2TableDescriptor tbl) {
        tbl.onDrop();
        this.tbls.remove(tbl.tableName());
        this.typeToTbl.remove(tbl.typeName());
    }

    public void dropAll() {
        for (H2TableDescriptor tbl : this.tbls.values()) {
            tbl.onDrop();
        }
        this.tbls.clear();
        this.typeToTbl.clear();
    }
}

