/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.query.h2.H2Cursor;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class H2TreeIndex
extends GridH2IndexBase {
    public static final int IGNITE_MAX_INDEX_PAYLOAD_SIZE_DEFAULT = 10;
    private final H2Tree[] segments;
    private final List<InlineIndexHelper> inlineIdxs;
    private GridCacheContext<?, ?> cctx;

    public H2TreeIndex(GridCacheContext<?, ?> cctx, GridH2Table tbl, String name, boolean pk, List<IndexColumn> colsList, int inlineSize, int segmentsCnt) throws IgniteCheckedException {
        assert (segmentsCnt > 0) : segmentsCnt;
        this.cctx = cctx;
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        this.initBaseIndex((Table)tbl, 0, name, cols, pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
        name = (tbl.rowDescriptor() == null ? "" : tbl.rowDescriptor().type().typeId() + "_") + name;
        name = BPlusTree.treeName((String)name, (String)"H2Tree");
        if (cctx.affinityNode()) {
            this.inlineIdxs = this.getAvailableInlineColumns(cols);
            this.segments = new H2Tree[segmentsCnt];
            for (int i = 0; i < this.segments.length; ++i) {
                RootPage page = this.getMetaPage(name, i);
                this.segments[i] = new H2Tree(name, cctx.offheap().reuseListForIndex(name), cctx.groupId(), cctx.memoryPolicy().pageMemory(), cctx.shared().wal(), (AtomicLong)cctx.offheap().globalRemoveId(), tbl.rowFactory(), page.pageId().pageId(), page.isAllocated(), cols, this.inlineIdxs, this.computeInlineSize(this.inlineIdxs, inlineSize)){

                    @Override
                    public int compareValues(Value v1, Value v2) {
                        return v1 == v2 ? 0 : H2TreeIndex.this.table.compareTypeSafe(v1, v2);
                    }
                };
            }
        } else {
            this.segments = null;
            this.inlineIdxs = null;
        }
        this.initDistributedJoinMessaging(tbl);
    }

    private List<InlineIndexHelper> getAvailableInlineColumns(IndexColumn[] cols) {
        ArrayList<InlineIndexHelper> res = new ArrayList<InlineIndexHelper>();
        for (IndexColumn col : cols) {
            if (!InlineIndexHelper.AVAILABLE_TYPES.contains(col.column.getType())) break;
            InlineIndexHelper idx = new InlineIndexHelper(col.column.getType(), col.column.getColumnId(), col.sortType);
            res.add(idx);
        }
        return res;
    }

    @Override
    protected int segmentsCount() {
        return this.segments.length;
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        try {
            IndexingQueryFilter f = H2TreeIndex.threadLocalFilter();
            IgniteBiPredicate p = null;
            if (f != null) {
                String cacheName = this.getTable().cacheName();
                p = f.forCache(cacheName);
            }
            int seg = this.threadLocalSegment();
            H2Tree tree = this.treeForRead(seg);
            return new H2Cursor((GridCursor<GridH2Row>)tree.find(lower, upper), (IgniteBiPredicate<Object, Object>)p);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    public GridH2Row findOne(GridH2Row row) {
        try {
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            return (GridH2Row)tree.findOne(row);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    public GridH2Row put(GridH2Row row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            GridH2Row gridH2Row = (GridH2Row)tree.put(row);
            return gridH2Row;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public boolean putx(GridH2Row row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            boolean bl = tree.putx(row);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public GridH2Row remove(SearchRow row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            GridH2Row gridH2Row = (GridH2Row)tree.remove(row);
            return gridH2Row;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public void removex(SearchRow row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            tree.removex(row);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = this.getCostRangeIndex(masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public long getRowCount(Session ses) {
        Cursor cursor = this.find(ses, null, null);
        long res = 0L;
        while (cursor.next()) {
            ++res;
        }
        return res;
    }

    public long getRowCountApproximation() {
        return 10000L;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean b) {
        try {
            int seg = this.threadLocalSegment();
            H2Tree tree = this.treeForRead(seg);
            GridH2Row row = b ? (GridH2Row)tree.findFirst() : (GridH2Row)tree.findLast();
            return new SingleRowCursor((Row)row);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.cctx.affinityNode() && !this.cctx.kernalContext().cache().context().database().persistenceEnabled()) {
                for (int i = 0; i < this.segments.length; ++i) {
                    H2Tree tree = this.segments[i];
                    tree.destroy();
                    this.dropMetaPage(tree.getName(), i);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        finally {
            super.destroy();
        }
    }

    @Nullable
    protected IgniteTree<SearchRow, GridH2Row> doTakeSnapshot() {
        int seg = this.threadLocalSegment();
        return this.treeForRead(seg);
    }

    protected H2Tree treeForRead(int segment) {
        return this.segments[segment];
    }

    @Override
    protected GridCursor<GridH2Row> doFind0(IgniteTree t, @Nullable SearchRow first, boolean includeFirst, @Nullable SearchRow last, IndexingQueryFilter filter) {
        try {
            GridCursor range = t.find((Object)first, (Object)last);
            if (range == null) {
                return EMPTY_CURSOR;
            }
            return this.filter((GridCursor<GridH2Row>)range, filter);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    private int computeInlineSize(List<InlineIndexHelper> inlineIdxs, int cfgInlineSize) {
        int propSize;
        int confSize = this.cctx.config().getSqlIndexMaxInlineSize();
        int n = propSize = confSize == -1 ? IgniteSystemProperties.getInteger((String)"IGNITE_MAX_INDEX_PAYLOAD_SIZE", (int)10) : confSize;
        if (cfgInlineSize == 0) {
            return 0;
        }
        if (F.isEmpty(inlineIdxs)) {
            return 0;
        }
        if (cfgInlineSize == -1) {
            if (propSize == 0) {
                return 0;
            }
            int size = 0;
            for (InlineIndexHelper idxHelper : inlineIdxs) {
                if (idxHelper.size() <= 0) {
                    size = propSize;
                    break;
                }
                size += idxHelper.size() + 1;
            }
            return Math.min(2048, size);
        }
        return Math.min(2048, cfgInlineSize);
    }

    private RootPage getMetaPage(String name, int segIdx) throws IgniteCheckedException {
        return this.cctx.offheap().rootPageForIndex(this.cctx.cacheId(), name + "%" + segIdx);
    }

    private void dropMetaPage(String name, int segIdx) throws IgniteCheckedException {
        this.cctx.offheap().dropRootPageForIndex(this.cctx.cacheId(), name + "%" + segIdx);
    }
}

