/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2AbstractKeyValueRow
extends GridH2Row {
    public static final int DEFAULT_COLUMNS_COUNT = 3;
    public static final int KEY_COL = 0;
    public static final int VAL_COL = 1;
    public static final int VER_COL = 2;
    protected final GridH2RowDescriptor desc;
    protected long expirationTime;
    private Value key;
    private volatile Value val;
    private Value[] valCache;
    private Value version;

    protected GridH2AbstractKeyValueRow(GridH2RowDescriptor desc, Object key, int keyType, @Nullable Object val, int valType, GridCacheVersion ver, long expirationTime) throws IgniteCheckedException {
        this.desc = desc;
        this.expirationTime = expirationTime;
        this.setValue(0, desc.wrap(key, keyType));
        if (val != null) {
            this.setValue(1, desc.wrap(val, valType));
        }
        if (ver != null) {
            this.setValue(2, desc.wrap(ver, 19));
        }
    }

    @Override
    public Value[] getValueList() {
        throw new UnsupportedOperationException();
    }

    protected GridH2AbstractKeyValueRow(GridH2RowDescriptor desc) {
        this.desc = desc;
    }

    public long expireTime() {
        return this.expirationTime;
    }

    public int getColumnCount() {
        return 3 + this.desc.fieldsCount();
    }

    protected synchronized Value updateWeakValue(Object valObj) throws IgniteCheckedException {
        Value res = this.peekValue(1);
        if (res != null && !(res instanceof WeakValue)) {
            return res;
        }
        Value upd = this.desc.wrap(valObj, this.desc.valueType());
        this.setValue(1, new WeakValue(upd));
        this.notifyAll();
        return upd;
    }

    protected synchronized Value syncValue(long waitTime) {
        Value v = this.peekValue(1);
        while (v == null && waitTime > 0L) {
            long start = System.nanoTime();
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedException(e);
            }
            long t = System.nanoTime() - start;
            if (t > 0L) {
                waitTime -= TimeUnit.NANOSECONDS.toMillis(t);
            }
            v = this.peekValue(1);
        }
        return v;
    }

    protected final Value peekValue(int col) {
        if (col == 0) {
            return this.key;
        }
        if (col == 1) {
            return this.val;
        }
        assert (col == 2);
        return this.version;
    }

    public Value getValue(int col) {
        Value v;
        Value[] vCache = this.valCache;
        if (vCache != null && (v = vCache[col]) != null) {
            return v;
        }
        if (this.desc.isValueColumn(col)) {
            v = this.peekValue(1);
            assert (!(v instanceof WeakValue)) : v;
            return v;
        }
        if (this.desc.isKeyColumn(col)) {
            v = this.peekValue(0);
            if (v == null) {
                v = this.getOffheapValue(0);
                assert (v != null);
                this.setValue(0, v);
                if (this.peekValue(1) == null) {
                    this.cache();
                }
            }
            assert (!(v instanceof WeakValue)) : v;
            return v;
        }
        if (col == 2) {
            return this.version;
        }
        assert ((col -= 3) >= 0);
        Value key = this.getValue(0);
        Value val = this.getValue(1);
        assert (key != null);
        assert (val != null);
        Object res = this.desc.columnValue(key.getObject(), val.getObject(), col);
        if (res == null) {
            v = ValueNull.INSTANCE;
        } else {
            try {
                v = this.desc.wrap(res, this.desc.fieldType(col));
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }
        if (vCache != null) {
            vCache[col + 3] = v;
        }
        return v;
    }

    public void valuesCache(Value[] valCache) {
        if (valCache != null) {
            this.desc.initValueCache(valCache, this.key, this.val, this.version);
        }
        this.valCache = valCache;
    }

    protected abstract void cache();

    protected abstract Value getOffheapValue(int var1);

    protected void addOffheapRowId(SB sb) {
    }

    public String toString() {
        SB sb = new SB("Row@");
        sb.a(Integer.toHexString(System.identityHashCode(this)));
        this.addOffheapRowId(sb);
        Value v = this.peekValue(0);
        sb.a("[ key: ").a(v == null ? "nil" : v.getString());
        v = WeakValue.unwrap(this.peekValue(1));
        sb.a(", val: ").a(v == null ? "nil" : v.getString());
        v = this.peekValue(2);
        sb.a(", ver: ").a(v == null ? "nil" : v.getString());
        sb.a(" ][ ");
        if (v != null) {
            int cnt = this.getColumnCount();
            for (int i = 3; i < cnt; ++i) {
                v = this.getValue(i);
                if (i != 3) {
                    sb.a(", ");
                }
                if (this.desc.isKeyValueOrVersionColumn(i)) continue;
                sb.a(v == null ? "nil" : v.getString());
            }
        }
        sb.a(" ]");
        return sb.toString();
    }

    @Override
    public void setKeyAndVersion(SearchRow old) {
        throw new IllegalStateException();
    }

    @Override
    public void setKey(long key) {
        throw new IllegalStateException();
    }

    @Override
    public Row getCopy() {
        throw new IllegalStateException();
    }

    @Override
    public void setDeleted(boolean deleted) {
        throw new IllegalStateException();
    }

    @Override
    public long getKey() {
        throw new IllegalStateException();
    }

    @Override
    public void setSessionId(int sesId) {
        throw new IllegalStateException();
    }

    @Override
    public void setVersion(int ver) {
        throw new IllegalStateException();
    }

    public void setValue(int idx, Value v) {
        if (this.desc.isValueColumn(idx)) {
            this.val = v;
        } else if (idx == 2) {
            this.version = v;
        } else {
            assert (this.desc.isKeyColumn(idx)) : idx + " " + v;
            this.key = v;
        }
    }

    public final int hashCode() {
        throw new IllegalStateException();
    }

    private static class WeakValue
    extends Value {
        private final WeakReference<Value> ref;

        static Value unwrap(Value v) {
            return v instanceof WeakValue ? ((WeakValue)v).get() : v;
        }

        private WeakValue(Value v) {
            this.ref = new WeakReference<Value>(v);
        }

        public Value get() {
            return (Value)this.ref.get();
        }

        public String getSQL() {
            throw new IllegalStateException();
        }

        public int getType() {
            throw new IllegalStateException();
        }

        public long getPrecision() {
            throw new IllegalStateException();
        }

        public int getDisplaySize() {
            throw new IllegalStateException();
        }

        public String getString() {
            throw new IllegalStateException();
        }

        public Object getObject() {
            throw new IllegalStateException();
        }

        public void set(PreparedStatement preparedStatement, int i) throws SQLException {
            throw new IllegalStateException();
        }

        protected int compareSecure(Value val, CompareMode compareMode) {
            throw new IllegalStateException();
        }

        public int hashCode() {
            throw new IllegalStateException();
        }

        public boolean equals(Object o) {
            throw new IllegalStateException();
        }
    }
}

