/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.h2.H2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOffheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridSearchRowPointer;
import org.apache.ignite.internal.util.GridCursorIteratorWrapper;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.offheap.unsafe.GridOffHeapSmartPointerFactory;
import org.apache.ignite.internal.util.offheap.unsafe.GridOffHeapSnapTreeMap;
import org.apache.ignite.internal.util.snaptree.SnapTreeMap;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridH2TreeIndex
extends GridH2IndexBase
implements Comparator<GridSearchRowPointer> {
    private final IgniteNavigableMapTree[] segments;
    private final boolean snapshotEnabled;

    public GridH2TreeIndex(String name, GridH2Table tbl, boolean pk, List<IndexColumn> colsList) {
        this(name, tbl, pk, colsList, 1);
    }

    public GridH2TreeIndex(String name, GridH2Table tbl, boolean pk, List<IndexColumn> colsList, int segmentsCnt) {
        assert (segmentsCnt > 0) : segmentsCnt;
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        this.initBaseIndex((Table)tbl, 0, name, cols, pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
        this.segments = new IgniteNavigableMapTree[segmentsCnt];
        final GridH2RowDescriptor desc = tbl.rowDescriptor();
        if (desc == null || desc.memory() == null) {
            boolean bl = this.snapshotEnabled = desc == null || desc.snapshotableIndex();
            if (this.snapshotEnabled) {
                for (int i = 0; i < segmentsCnt; ++i) {
                    this.segments[i] = new IgniteNavigableMapTree((NavigableMap)new SnapTreeMap<GridSearchRowPointer, GridH2Row>((Comparator)this){

                        protected void afterNodeUpdate_nl(SnapTreeMap.Node<GridSearchRowPointer, GridH2Row> node, Object val) {
                            if (val != null) {
                                node.key = (GridSearchRowPointer)val;
                            }
                        }

                        protected Comparable<? super GridSearchRowPointer> comparable(Object key) {
                            if (key instanceof ComparableRow) {
                                return (Comparable)key;
                            }
                            return super.comparable(key);
                        }
                    });
                }
            } else {
                for (int i = 0; i < segmentsCnt; ++i) {
                    this.segments[i] = new IgniteNavigableMapTree(new ConcurrentSkipListMap(new Comparator<GridSearchRowPointer>(){

                        @Override
                        public int compare(GridSearchRowPointer o1, GridSearchRowPointer o2) {
                            if (o1 instanceof ComparableRow) {
                                return ((ComparableRow)o1).compareTo(o2);
                            }
                            if (o2 instanceof ComparableRow) {
                                return -((ComparableRow)o2).compareTo(o1);
                            }
                            return GridH2TreeIndex.this.compareRows(o1, o2);
                        }
                    }));
                }
            }
        } else {
            assert (desc.snapshotableIndex()) : desc;
            this.snapshotEnabled = true;
            for (int i = 0; i < segmentsCnt; ++i) {
                this.segments[i] = new IgniteNavigableMapTree((NavigableMap)new GridOffHeapSnapTreeMap<GridSearchRowPointer, GridH2Row>((GridOffHeapSmartPointerFactory)desc, (GridOffHeapSmartPointerFactory)desc, desc.memory(), desc.guard(), (Comparator)this){

                    protected void afterNodeUpdate_nl(long node, GridH2Row val) {
                        final long oldKey = this.keyPtr(node);
                        if (val != null) {
                            this.key(node, val);
                            this.guard.finalizeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((GridH2KeyValueRowOffheap)desc.createPointer(oldKey)).decrementRefCount();
                                }
                            });
                        }
                    }

                    protected Comparable<? super GridSearchRowPointer> comparable(Object key) {
                        if (key instanceof ComparableRow) {
                            return (Comparable)key;
                        }
                        return super.comparable(key);
                    }
                });
            }
        }
        this.initDistributedJoinMessaging(tbl);
    }

    @Override
    protected IgniteTree doTakeSnapshot() {
        assert (this.snapshotEnabled);
        int seg = this.threadLocalSegment();
        IgniteNavigableMapTree tree = this.segments[seg];
        return tree.clone();
    }

    protected final IgniteTree treeForRead(int seg) {
        if (!this.snapshotEnabled) {
            return this.segments[seg];
        }
        IgniteTree res = (IgniteTree)this.threadLocalSnapshot();
        if (res == null) {
            return this.segments[seg];
        }
        return res;
    }

    @Override
    public void destroy() {
        assert (this.threadLocalSnapshot() == null);
        super.destroy();
    }

    public long getRowCount(@Nullable Session ses) {
        IndexingQueryFilter f = GridH2TreeIndex.threadLocalFilter();
        int seg = this.threadLocalSegment();
        if (f == null || f.forCache(this.getTable().cacheName()) == null) {
            try {
                return this.treeForRead(seg).size();
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }
        GridCursor<GridH2Row> cursor = this.doFind(null, false, null);
        long size = 0L;
        try {
            while (cursor.next()) {
                ++size;
            }
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        return size;
    }

    public long getRowCountApproximation() {
        return this.table.getRowCountApproximation();
    }

    @Override
    public int compare(GridSearchRowPointer r1, GridSearchRowPointer r2) {
        return -this.compareRows(r2, r1);
    }

    public String toString() {
        SB sb = new SB((this.indexType.isUnique() ? "Unique index '" : "Index '") + this.getName() + "' [");
        boolean first = true;
        for (IndexColumn col : this.getIndexColumns()) {
            if (first) {
                first = false;
            } else {
                sb.a(", ");
            }
            sb.a(col.getSQL());
        }
        sb.a(" ]");
        return sb.toString();
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> cols) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = this.getCostRangeIndex(masks, rowCnt, filters, filter, sortOrder, false, cols);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public boolean canFindNext() {
        return false;
    }

    public Cursor find(Session ses, @Nullable SearchRow first, @Nullable SearchRow last) {
        return new H2Cursor(this.doFind(first, true, last), null);
    }

    public Cursor findNext(Session ses, SearchRow higherThan, SearchRow last) {
        return new H2Cursor(this.doFind(higherThan, false, last), null);
    }

    @Override
    public GridH2Row findOne(GridH2Row row) {
        int seg = this.segmentForRow(row);
        return this.segments[seg].findOne(row);
    }

    private GridCursor<GridH2Row> doFind(@Nullable SearchRow first, boolean includeFirst, @Nullable SearchRow last) {
        int seg = this.threadLocalSegment();
        IgniteTree t = this.treeForRead(seg);
        return this.doFind0(t, first, includeFirst, last, GridH2TreeIndex.threadLocalFilter());
    }

    @Override
    protected final GridCursor<GridH2Row> doFind0(IgniteTree t, @Nullable SearchRow first, boolean includeFirst, @Nullable SearchRow last, IndexingQueryFilter filter) {
        GridCursor<GridH2Row> range = this.subTree(t, this.comparable(first, (includeFirst &= first != null) ? -1 : 1), this.comparable(last, 1));
        if (range == null) {
            return EMPTY_CURSOR;
        }
        return this.filter(range, filter);
    }

    private GridSearchRowPointer comparable(SearchRow row, int bias) {
        if (row == null) {
            return null;
        }
        if (bias == 0 && row instanceof GridH2Row) {
            return (GridSearchRowPointer)row;
        }
        return new ComparableRow(row, bias);
    }

    private GridCursor<GridH2Row> subTree(IgniteTree tree, @Nullable GridSearchRowPointer first, @Nullable GridSearchRowPointer last) {
        if (first != null && last != null && this.compare(first, last) > 0) {
            return null;
        }
        try {
            return tree.find((Object)first, (Object)last);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    GridCursor<GridH2Row> rows() {
        return this.doFind(null, false, null);
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        try {
            int seg = this.threadLocalSegment();
            IgniteTree t = this.treeForRead(seg);
            GridH2Row row = (GridH2Row)(first ? t.findFirst() : t.findLast());
            return new SingleRowCursor((Row)row);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    public GridH2Row put(GridH2Row row) {
        int seg = this.segmentForRow(row);
        return this.segments[seg].put(row);
    }

    @Override
    public GridH2Row remove(SearchRow row) {
        GridSearchRowPointer comparable = this.comparable(row, 0);
        int seg = this.segmentForRow(row);
        return this.segments[seg].remove(comparable);
    }

    @Override
    protected int segmentsCount() {
        return this.segments.length;
    }

    private static final class IgniteNavigableMapTree
    implements IgniteTree<GridSearchRowPointer, GridH2Row>,
    Cloneable {
        private final NavigableMap<GridSearchRowPointer, GridH2Row> tree;

        private IgniteNavigableMapTree(NavigableMap<GridSearchRowPointer, GridH2Row> tree) {
            this.tree = tree;
        }

        public void invoke(GridSearchRowPointer key, Object x, IgniteTree.InvokeClosure<GridH2Row> c) {
            throw new UnsupportedOperationException();
        }

        public GridH2Row put(GridH2Row val) {
            return this.tree.put(val, val);
        }

        public GridH2Row findOne(GridSearchRowPointer key) {
            return (GridH2Row)this.tree.get(key);
        }

        public GridCursor<GridH2Row> find(GridSearchRowPointer lower, GridSearchRowPointer upper) throws IgniteCheckedException {
            Collection<Object> rows = lower == null && upper == null ? this.tree.values() : (lower != null && upper == null ? this.tree.tailMap(lower).values() : (lower == null ? this.tree.headMap(upper).values() : this.tree.subMap(lower, false, upper, false).values()));
            return new GridCursorIteratorWrapper(rows.iterator());
        }

        public GridH2Row findFirst() throws IgniteCheckedException {
            Map.Entry<GridSearchRowPointer, GridH2Row> first = this.tree.firstEntry();
            return first == null ? null : first.getValue();
        }

        public GridH2Row findLast() throws IgniteCheckedException {
            Map.Entry<GridSearchRowPointer, GridH2Row> last = this.tree.lastEntry();
            return last == null ? null : last.getValue();
        }

        public GridH2Row remove(GridSearchRowPointer key) {
            return (GridH2Row)this.tree.remove(key);
        }

        public long size() {
            return this.tree.size();
        }

        public IgniteNavigableMapTree clone() {
            IgniteNavigableMapTree cp;
            try {
                cp = (IgniteNavigableMapTree)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw DbException.convert((Throwable)e);
            }
            return new IgniteNavigableMapTree(cp.tree);
        }
    }

    private final class ComparableRow
    implements GridSearchRowPointer,
    Comparable<SearchRow> {
        private final SearchRow row;
        private final int bias;

        private ComparableRow(SearchRow row, int bias) {
            this.row = row;
            this.bias = bias;
        }

        @Override
        public int compareTo(SearchRow o) {
            int res = GridH2TreeIndex.this.compareRows(o, this.row);
            if (res == 0) {
                return this.bias;
            }
            return -res;
        }

        public boolean equals(Object obj) {
            throw new IllegalStateException("Should never be called.");
        }

        public int getColumnCount() {
            return this.row.getColumnCount();
        }

        public Value getValue(int idx) {
            return this.row.getValue(idx);
        }

        public void setValue(int idx, Value v) {
            this.row.setValue(idx, v);
        }

        public void setKeyAndVersion(SearchRow old) {
            this.row.setKeyAndVersion(old);
        }

        public int getVersion() {
            return this.row.getVersion();
        }

        public void setKey(long key) {
            this.row.setKey(key);
        }

        public long getKey() {
            return this.row.getKey();
        }

        public int getMemory() {
            return this.row.getMemory();
        }

        public long pointer() {
            throw new IllegalStateException();
        }

        public void incrementRefCount() {
            throw new IllegalStateException();
        }

        public void decrementRefCount() {
            throw new IllegalStateException();
        }
    }
}

