/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.Collections;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Parser;
import org.h2.table.Column;

public class GridSqlColumn
extends GridSqlElement {
    private GridSqlAst from;
    private String schema;
    private String tblAlias;
    private String colName;
    private Column col;

    public GridSqlColumn(Column col, GridSqlAst from, String colName) {
        this(col, from, null, null, colName);
    }

    public GridSqlColumn(Column col, GridSqlAst from, String schema, String tblAlias, String colName) {
        super(Collections.emptyList());
        assert (!F.isEmpty((String)colName)) : colName;
        this.col = col;
        this.from = from;
        this.colName = colName;
        this.schema = schema;
        this.tblAlias = tblAlias;
    }

    public String columnName() {
        return this.colName;
    }

    public String schema() {
        return this.schema;
    }

    public String tableAlias() {
        return this.tblAlias;
    }

    public void tableAlias(String tblAlias) {
        this.tblAlias = tblAlias;
    }

    @Override
    public String getSQL() {
        String sql = Parser.quoteIdentifier((String)this.colName);
        if (this.tblAlias != null) {
            sql = Parser.quoteIdentifier((String)this.tblAlias) + "." + sql;
        }
        if (this.schema != null) {
            sql = Parser.quoteIdentifier((String)this.schema) + "." + sql;
        }
        return sql;
    }

    public GridSqlAst expressionInFrom() {
        return this.from;
    }

    public void expressionInFrom(GridSqlAlias from) {
        this.from = from;
    }

    public Column column() {
        return this.col;
    }
}

