/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Set;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;

@Singleton
public class TemplateToImage
implements Function<Template, Image> {
    private final Supplier<Set<? extends Location>> locations;
    private final Function<Template, OperatingSystem> templateToOperatingSystem;

    @Inject
    public TemplateToImage(@Memoized Supplier<Set<? extends Location>> locations, Function<Template, OperatingSystem> templateToOperatingSystem) {
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.templateToOperatingSystem = (Function)Preconditions.checkNotNull(templateToOperatingSystem, (Object)"templateToOperatingSystem");
    }

    public Image apply(Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template");
        OperatingSystem os = (OperatingSystem)this.templateToOperatingSystem.apply((Object)template);
        ImageBuilder builder = new ImageBuilder().ids(template.getId() + "").name(template.getName()).description(template.getDisplayText()).operatingSystem(os);
        if (!template.isCrossZones()) {
            builder.location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)template.getZoneId())).orNull());
        }
        builder.status(Image.Status.AVAILABLE);
        return builder.build();
    }
}

