/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.functions.ParseAsyncJobFromHttpResponse;
import org.jclouds.cloudstack.functions.ParseAsyncJobsFromHttpResponse;
import org.jclouds.cloudstack.options.ListAsyncJobsOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface AsyncJobApi {
    @Named(value="listAsyncJobs")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listAsyncJobs", "true"})
    @ResponseParser(value=ParseAsyncJobsFromHttpResponse.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<AsyncJob<?>> listAsyncJobs(ListAsyncJobsOptions ... var1);

    @Named(value="queryAsyncJobResult")
    @GET
    @QueryParams(keys={"command"}, values={"queryAsyncJobResult"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseAsyncJobFromHttpResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public <T> AsyncJob<T> getAsyncJob(@QueryParam(value="jobid") String var1);
}

