/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.InvalidKeyException;
import java.util.Map;
import javax.crypto.Mac;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.util.Strings2;

@Singleton
public class QuerySigner
implements AuthenticationFilter,
RequestSigner {
    private final SignatureWire signatureWire;
    private final Supplier<Credentials> creds;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    private Logger signatureLog = Logger.NULL;

    @Inject
    public QuerySigner(SignatureWire signatureWire, @Provider Supplier<Credentials> creds, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.creds = creds;
        this.crypto = crypto;
        this.utils = utils;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkNotNull((Object)request, (Object)"request must be present");
        Multimap decodedParams = (Multimap)Queries.queryParser().apply((Object)request.getEndpoint().getRawQuery());
        this.addSigningParams((Multimap<String, String>)decodedParams);
        String stringToSign = this.createStringToSign(request, (Multimap<String, String>)decodedParams);
        String signature = this.sign(stringToSign);
        this.addSignature((Multimap<String, String>)decodedParams, signature);
        request = request.toBuilder().endpoint(Uris.uriBuilder((URI)request.getEndpoint()).query(decodedParams).build()).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    @VisibleForTesting
    void addSignature(Multimap<String, String> params, String signature) {
        params.replaceValues((Object)"signature", (Iterable)ImmutableList.of((Object)signature));
    }

    @VisibleForTesting
    public String sign(String toSign) {
        try {
            ByteProcessor hmacSHA1 = Macs.asByteProcessor((Mac)this.crypto.hmacSHA1(((Credentials)this.creds.get()).credential.getBytes()));
            String signature = BaseEncoding.base64().encode((byte[])ByteStreams.readBytes((InputStream)Strings2.toInputStream((String)toSign), (ByteProcessor)hmacSHA1));
            if (this.signatureWire.enabled()) {
                this.signatureWire.input(Strings2.toInputStream((String)signature));
            }
            return signature;
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    public String createStringToSign(HttpRequest request, Multimap<String, String> decodedParams) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Map.Entry entry : decodedParams.entries()) {
            builder.add((Object)((String)entry.getKey() + "=" + Strings2.urlEncode((String)((String)entry.getValue()), (char[])new char[0])));
        }
        String stringToSign = Joiner.on((char)'&').join((Iterable)builder.build()).toLowerCase();
        if (this.signatureWire.enabled()) {
            this.signatureWire.output((Object)stringToSign);
        }
        return stringToSign;
    }

    @VisibleForTesting
    void addSigningParams(Multimap<String, String> params) {
        params.replaceValues((Object)"apiKey", (Iterable)ImmutableList.of((Object)((Credentials)this.creds.get()).identity));
        params.removeAll((Object)"signature");
    }

    public String createStringToSign(HttpRequest input) {
        Multimap decodedParams = (Multimap)Queries.queryParser().apply((Object)input.getEndpoint().getQuery());
        this.addSigningParams((Multimap<String, String>)decodedParams);
        return this.createStringToSign(input, (Multimap<String, String>)decodedParams);
    }
}

