/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.UncheckedExecutionException;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.logging.Logger;

@Singleton
public class BlockUntilJobCompletesAndReturnResult {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackApi client;
    private final Predicate<String> jobComplete;

    @Inject
    public BlockUntilJobCompletesAndReturnResult(CloudStackApi client, Predicate<String> jobComplete) {
        this.client = (CloudStackApi)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.jobComplete = (Predicate)Preconditions.checkNotNull(jobComplete, (Object)"jobComplete");
    }

    public <T> T apply(AsyncCreateResponse job) {
        boolean completed = this.jobComplete.apply((Object)job.getJobId());
        this.logger.trace("<< job(%s) complete(%s)", new Object[]{job, completed});
        AsyncJob jobWithResult = this.client.getAsyncJobApi().getAsyncJob(job.getJobId());
        Preconditions.checkState((boolean)completed, (String)"job %s failed to complete in time %s", (Object)job.getJobId(), jobWithResult);
        if (jobWithResult.getError() != null) {
            throw new UncheckedExecutionException(String.format("job %s failed with exception %s", job.getJobId(), jobWithResult.getError().toString())){};
        }
        return jobWithResult.getResult();
    }
}

