/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.googlecomputeengine.domain.Resource;

public class ListPage<T>
extends IterableWithMarker<T> {
    private final Resource.Kind kind;
    private final String id;
    private final URI selfLink;
    private final String nextPageToken;
    private final Iterable<T> items;

    @ConstructorProperties(value={"kind", "id", "selfLink", "nextPageToken", "items"})
    protected ListPage(Resource.Kind kind, String id, URI selfLink, String nextPageToken, Iterable<T> items) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.kind = (Resource.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind), (String)"kind of %id", (Object[])new Object[]{id}));
        this.selfLink = (URI)Preconditions.checkNotNull((Object)selfLink, (String)"selfLink of %id", (Object[])new Object[]{id});
        this.nextPageToken = nextPageToken;
        this.items = items != null ? ImmutableSet.copyOf(items) : ImmutableSet.of();
    }

    public Resource.Kind getKind() {
        return this.kind;
    }

    public String getId() {
        return this.id;
    }

    public URI getSelfLink() {
        return this.selfLink;
    }

    public Optional<Object> nextMarker() {
        return Optional.fromNullable((Object)this.nextPageToken);
    }

    public Iterator<T> iterator() {
        return ((Iterable)Preconditions.checkNotNull(this.items, (Object)"items")).iterator();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.kind, this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ListPage that = (ListPage)((Object)ListPage.class.cast(obj));
        return Objects.equal((Object)((Object)this.kind), (Object)((Object)that.kind)) && Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)((Object)this)).omitNullValues().add("kind", (Object)this.kind).add("id", (Object)this.id).add("selfLink", (Object)this.selfLink).add("nextPageToken", (Object)this.nextPageToken).add("items", this.items);
    }

    public String toString() {
        return this.string().toString();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder().fromPagedList(this);
    }

    public static final class Builder<T> {
        private Resource.Kind kind;
        private String id;
        private URI selfLink;
        private String nextPageToken;
        private ImmutableSet.Builder<T> items = ImmutableSet.builder();

        public Builder<T> kind(Resource.Kind kind) {
            this.kind = kind;
            return this;
        }

        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<T> selfLink(URI selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Builder<T> addItem(T item) {
            this.items.add(item);
            return this;
        }

        public Builder<T> items(Iterable<T> items) {
            this.items.addAll(items);
            return this;
        }

        public Builder<T> nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public ListPage<T> build() {
            return new ListPage(this.kind, this.id, this.selfLink, this.nextPageToken, this.items.build());
        }

        public Builder<T> fromPagedList(ListPage<T> in) {
            return this.kind(in.getKind()).id(in.getId()).selfLink(in.getSelfLink()).nextPageToken((String)in.nextMarker().orNull()).items((Iterable<T>)((Object)in));
        }
    }
}

