/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.Disk;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseDisks;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticationFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticationFilter.class})
public interface DiskApi {
    @Named(value="Disks:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/disks/{disk}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Disk getInZone(@PathParam(value="zone") String var1, @PathParam(value="disk") String var2);

    @Named(value="Disks:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/zones/{zone}/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createInZone(@PayloadParam(value="name") String var1, @PayloadParam(value="sizeGb") int var2, @PathParam(value="zone") String var3);

    @Named(value="Disks:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/zones/{zone}/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createFromImageWithSizeInZone(@QueryParam(value="sourceImage") String var1, @PayloadParam(value="name") String var2, @PayloadParam(value="sizeGb") int var3, @PathParam(value="zone") String var4);

    @Named(value="Disks:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/zones/{zone}/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createFromImageInZone(@QueryParam(value="sourceImage") String var1, @PayloadParam(value="name") String var2, @PathParam(value="zone") String var3);

    @Named(value="Disks:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/disks/{disk}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation deleteInZone(@PathParam(value="zone") String var1, @PathParam(value="disk") String var2);

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Disk> listFirstPageInZone(@PathParam(value="zone") String var1);

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Disk> listAtMarkerInZone(@PathParam(value="zone") String var1, @QueryParam(value="pageToken") @Nullable String var2);

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Disk> listAtMarkerInZone(@PathParam(value="zone") String var1, @QueryParam(value="pageToken") @Nullable String var2, ListOptions var3);

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Transform(value=ParseDisks.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Disk> listInZone(@PathParam(value="zone") String var1);

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Transform(value=ParseDisks.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Disk> listInZone(@PathParam(value="zone") String var1, ListOptions var2);

    @Named(value="Disks:createSnapshot")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/disks/{disk}/createSnapshot")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    @Nullable
    public Operation createSnapshotInZone(@PathParam(value="zone") String var1, @PathParam(value="disk") String var2, @PayloadParam(value="name") String var3);
}

