/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseNetworks;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticationFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticationFilter.class})
public interface NetworkApi {
    @Named(value="Networks:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/networks/{network}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Network get(@PathParam(value="network") String var1);

    @Named(value="Networks:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/global/networks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createInIPv4Range(@PayloadParam(value="name") String var1, @PayloadParam(value="IPv4Range") String var2);

    @Named(value="Networks:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/global/networks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createInIPv4RangeWithGateway(@PayloadParam(value="name") String var1, @PayloadParam(value="IPv4Range") String var2, @PayloadParam(value="gatewayIPv4") String var3);

    @Named(value="Networks:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/global/networks/{network}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation delete(@PathParam(value="network") String var1);

    @Named(value="Networks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/networks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseNetworks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Network> listFirstPage();

    @Named(value="Networks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/networks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseNetworks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Network> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1);

    @Named(value="Networks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/networks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseNetworks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Network> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1, ListOptions var2);

    @Named(value="Networks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/networks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseNetworks.class)
    @Transform(value=ParseNetworks.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Network> list();

    @Named(value="Networks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/networks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseNetworks.class)
    @Transform(value=ParseNetworks.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Network> list(ListOptions var1);
}

