/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class NetworkFirewallPredicates {
    public static Predicate<Firewall> hasProtocol(final IpProtocol protocol) {
        return new Predicate<Firewall>(){

            public boolean apply(Firewall fw) {
                for (Firewall.Rule rule : fw.getAllowed()) {
                    if (!rule.getIpProtocol().equals((Object)protocol)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Firewall> hasPortRange(final Range<Integer> portRange) {
        return new Predicate<Firewall>(){

            public boolean apply(Firewall fw) {
                return Iterables.any(fw.getAllowed(), (Predicate)new Predicate<Firewall.Rule>(){

                    public boolean apply(Firewall.Rule input) {
                        return input.getPorts().encloses(portRange);
                    }
                });
            }
        };
    }

    public static Predicate<Firewall> hasSourceTag(final String sourceTag) {
        return new Predicate<Firewall>(){

            public boolean apply(Firewall input) {
                return input.getSourceTags() != null && input.getSourceTags().contains(sourceTag);
            }
        };
    }

    public static Predicate<Firewall> hasSourceRange(final String sourceRange) {
        return new Predicate<Firewall>(){

            public boolean apply(Firewall input) {
                return input.getSourceRanges() != null && input.getSourceRanges().contains(sourceRange);
            }
        };
    }

    public static Predicate<Firewall> equalsIpPermission(final IpPermission permission) {
        return new Predicate<Firewall>(){

            public boolean apply(Firewall input) {
                return Iterables.elementsEqual((Iterable)permission.getGroupIds(), input.getSourceTags()) && Iterables.elementsEqual((Iterable)permission.getCidrBlocks(), input.getSourceRanges()) && input.getAllowed().size() == 1 && NetworkFirewallPredicates.ruleEqualsIpPermission(permission).apply(Iterables.getOnlyElement(input.getAllowed()));
            }
        };
    }

    public static Predicate<Firewall> providesIpPermission(final IpPermission permission) {
        return new Predicate<Firewall>(){

            public boolean apply(Firewall input) {
                boolean groupsMatchTags = permission.getGroupIds().isEmpty() && input.getSourceTags().isEmpty() || !Sets.intersection((Set)permission.getGroupIds(), input.getSourceTags()).isEmpty();
                boolean cidrsMatchRanges = permission.getCidrBlocks().isEmpty() && input.getSourceRanges().isEmpty() || !Sets.intersection((Set)permission.getCidrBlocks(), input.getSourceRanges()).isEmpty();
                boolean firewallHasPorts = NetworkFirewallPredicates.hasProtocol(permission.getIpProtocol()).apply((Object)input) && (permission.getFromPort() == 0 && permission.getToPort() == 0 || NetworkFirewallPredicates.hasPortRange((Range<Integer>)Range.closed((Comparable)Integer.valueOf(permission.getFromPort()), (Comparable)Integer.valueOf(permission.getToPort()))).apply((Object)input));
                return groupsMatchTags && cidrsMatchRanges && firewallHasPorts;
            }
        };
    }

    private static Predicate<Firewall.Rule> ruleEqualsIpPermission(final IpPermission permission) {
        return new Predicate<Firewall.Rule>(){

            public boolean apply(Firewall.Rule input) {
                return permission.getIpProtocol().equals((Object)input.getIpProtocol()) && (input.getPorts().isEmpty() && permission.getFromPort() == 0 && permission.getToPort() == 0 || input.getPorts().asRanges().size() == 1 && permission.getFromPort() == ((Integer)((Range)Iterables.getOnlyElement((Iterable)input.getPorts().asRanges())).lowerEndpoint()).intValue() && permission.getToPort() == ((Integer)((Range)Iterables.getOnlyElement((Iterable)input.getPorts().asRanges())).upperEndpoint()).intValue());
            }
        };
    }
}

