/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Client;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.client.KeyRange;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionPruner;
import org.apache.kudu.client.PartitionSchema;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.TableLocationsCache;
import org.apache.kudu.security.Token;
import org.apache.kudu.shaded.com.google.common.base.MoreObjects;
import org.apache.kudu.shaded.com.google.common.base.Objects;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.shaded.com.google.protobuf.CodedInputStream;
import org.apache.kudu.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.util.NetUtil;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class KuduScanToken
implements Comparable<KuduScanToken> {
    private final LocatedTablet tablet;
    private final Client.ScanTokenPB message;

    private KuduScanToken(LocatedTablet tablet, Client.ScanTokenPB message) {
        this.tablet = tablet;
        this.message = message;
    }

    public LocatedTablet getTablet() {
        return this.tablet;
    }

    public KuduScanner intoScanner(KuduClient client) throws IOException {
        return KuduScanToken.pbIntoScannerBuilder(this.message, client).build();
    }

    public byte[] serialize() throws IOException {
        return KuduScanToken.serialize(this.message);
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    static byte[] serialize(Client.ScanTokenPB message) throws IOException {
        byte[] buf = new byte[message.getSerializedSize()];
        CodedOutputStream cos = CodedOutputStream.newInstance(buf);
        message.writeTo(cos);
        cos.flush();
        return buf;
    }

    public static KuduScanner deserializeIntoScanner(byte[] buf, KuduClient client) throws IOException {
        return KuduScanToken.deserializeIntoScannerBuilder(buf, client).build();
    }

    public static KuduScanner.KuduScannerBuilder deserializeIntoScannerBuilder(byte[] buf, KuduClient client) throws IOException {
        return KuduScanToken.pbIntoScannerBuilder(Client.ScanTokenPB.parseFrom(CodedInputStream.newInstance(buf)), client);
    }

    public static String stringifySerializedToken(byte[] buf, KuduClient client) throws IOException {
        Client.ScanTokenPB token = Client.ScanTokenPB.parseFrom(CodedInputStream.newInstance(buf));
        KuduTable table = KuduScanToken.getKuduTable(token, client);
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ScanToken").add("table-name", table.getName());
        helper.add("table-id", table.getTableId());
        if (token.hasLowerBoundPrimaryKey() && !token.getLowerBoundPrimaryKey().isEmpty()) {
            helper.add("lower-bound-primary-key", KeyEncoder.decodePrimaryKey(table.getSchema(), token.getLowerBoundPrimaryKey().toByteArray()).stringifyRowKey());
        }
        if (token.hasUpperBoundPrimaryKey() && !token.getUpperBoundPrimaryKey().isEmpty()) {
            helper.add("upper-bound-primary-key", KeyEncoder.decodePrimaryKey(table.getSchema(), token.getUpperBoundPrimaryKey().toByteArray()).stringifyRowKey());
        }
        helper.addValue(KeyEncoder.formatPartitionKeyRange(table.getSchema(), table.getPartitionSchema(), token.getLowerBoundPartitionKey().toByteArray(), token.getUpperBoundPartitionKey().toByteArray()));
        return helper.toString();
    }

    private static List<Integer> computeProjectedColumnIndexesForScanner(Client.ScanTokenPB message, Schema schema) {
        if (message.getProjectedColumnIdxCount() != 0) {
            return message.getProjectedColumnIdxList();
        }
        ArrayList<Integer> columns = new ArrayList<Integer>(message.getProjectedColumnsCount());
        for (Common.ColumnSchemaPB colSchemaFromPb : message.getProjectedColumnsList()) {
            int colIdx = colSchemaFromPb.hasId() && schema.hasColumnIds() ? schema.getColumnIndex(colSchemaFromPb.getId()) : schema.getColumnIndex(colSchemaFromPb.getName());
            ColumnSchema colSchema = schema.getColumnByIndex(colIdx);
            if (colSchemaFromPb.getType() != colSchema.getType().getDataType(colSchema.getTypeAttributes())) {
                throw new IllegalStateException(String.format("invalid type %s for column '%s' in scan token, expected: %s", colSchemaFromPb.getType().name(), colSchemaFromPb.getName(), colSchema.getType().name()));
            }
            if (colSchemaFromPb.getIsNullable() != colSchema.isNullable()) {
                throw new IllegalStateException(String.format("invalid nullability for column '%s' in scan token, expected: %s", colSchemaFromPb.getName(), colSchema.isNullable() ? "NULLABLE" : "NOT NULL"));
            }
            columns.add(colIdx);
        }
        return columns;
    }

    public static RemoteTablet newRemoteTabletFromTabletMetadata(Client.TabletMetadataPB tabletMetadata, String tableId, Partition partition) {
        ArrayList<LocatedTablet.Replica> replicas = new ArrayList<LocatedTablet.Replica>();
        for (Client.TabletMetadataPB.ReplicaMetadataPB replicaMetadataPB : tabletMetadata.getReplicasList()) {
            Client.ServerMetadataPB server = tabletMetadata.getTabletServers(replicaMetadataPB.getTsIdx());
            LocatedTablet.Replica replica = new LocatedTablet.Replica(server.getRpcAddresses(0).getHost(), server.getRpcAddresses(0).getPort(), replicaMetadataPB.getRole(), replicaMetadataPB.getDimensionLabel());
            replicas.add(replica);
        }
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        for (Client.ServerMetadataPB serverMetadataPB : tabletMetadata.getTabletServersList()) {
            HostAndPort hostPort = ProtobufHelper.hostAndPortFromPB(serverMetadataPB.getRpcAddresses(0));
            InetAddress inetAddress = NetUtil.getInetAddress(hostPort.getHost());
            ServerInfo serverInfo = new ServerInfo(serverMetadataPB.getUuid().toStringUtf8(), hostPort, inetAddress, serverMetadataPB.getLocation());
            servers.add(serverInfo);
        }
        RemoteTablet remoteTablet = new RemoteTablet(tableId, tabletMetadata.getTabletId(), partition, replicas, servers);
        return remoteTablet;
    }

    private static KuduScanner.KuduScannerBuilder pbIntoScannerBuilder(Client.ScanTokenPB message, KuduClient client) throws KuduException {
        Preconditions.checkArgument(!message.getFeatureFlagsList().contains(Client.ScanTokenPB.Feature.Unknown), "Scan token requires an unsupported feature. This Kudu client must be updated.");
        KuduTable table = KuduScanToken.getKuduTable(message, client);
        if (message.hasTabletMetadata()) {
            Client.TabletMetadataPB tabletMetadata = message.getTabletMetadata();
            Partition partition = ProtobufHelper.pbToPartition(tabletMetadata.getPartition());
            if (client.asyncClient.getTableLocationEntry(table.getTableId(), partition.partitionKeyStart) == null) {
                TableLocationsCache tableLocationsCache = client.asyncClient.getOrCreateTableLocationsCache(table.getTableId());
                RemoteTablet remoteTablet = KuduScanToken.newRemoteTabletFromTabletMetadata(tabletMetadata, table.getTableId(), partition);
                tableLocationsCache.cacheTabletLocations(Collections.singletonList(remoteTablet), partition.partitionKeyStart, 1, tabletMetadata.getTtlMillis());
            }
        }
        if (message.hasAuthzToken()) {
            client.asyncClient.getAuthzTokenCache().put(table.getTableId(), message.getAuthzToken());
        }
        KuduScanner.KuduScannerBuilder builder = client.newScannerBuilder(table);
        builder.setProjectedColumnIndexes(KuduScanToken.computeProjectedColumnIndexesForScanner(message, table.getSchema()));
        for (Common.ColumnPredicatePB pred : message.getColumnPredicatesList()) {
            builder.addPredicate(KuduPredicate.fromPB(table.getSchema(), pred));
        }
        if (message.hasLowerBoundPrimaryKey()) {
            builder.lowerBoundRaw(message.getLowerBoundPrimaryKey().toByteArray());
        }
        if (message.hasUpperBoundPrimaryKey()) {
            builder.exclusiveUpperBoundRaw(message.getUpperBoundPrimaryKey().toByteArray());
        }
        if (message.hasLowerBoundPartitionKey()) {
            builder.lowerBoundPartitionKeyRaw(message.getLowerBoundPartitionKey().toByteArray());
        }
        if (message.hasUpperBoundPartitionKey()) {
            builder.exclusiveUpperBoundPartitionKeyRaw(message.getUpperBoundPartitionKey().toByteArray());
        }
        if (message.hasLimit()) {
            builder.limit(message.getLimit());
        }
        if (message.hasReadMode()) {
            switch (message.getReadMode()) {
                case READ_AT_SNAPSHOT: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT);
                    if (message.hasSnapTimestamp()) {
                        builder.snapshotTimestampRaw(message.getSnapTimestamp());
                    }
                    if (!message.hasSnapStartTimestamp()) break;
                    builder.diffScan(message.getSnapStartTimestamp(), message.getSnapTimestamp());
                    break;
                }
                case READ_LATEST: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_LATEST);
                    break;
                }
                case READ_YOUR_WRITES: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_YOUR_WRITES);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown read mode");
                }
            }
        }
        if (message.hasReplicaSelection()) {
            switch (message.getReplicaSelection()) {
                case LEADER_ONLY: {
                    builder.replicaSelection(ReplicaSelection.LEADER_ONLY);
                    break;
                }
                case CLOSEST_REPLICA: {
                    builder.replicaSelection(ReplicaSelection.CLOSEST_REPLICA);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown replica selection policy");
                }
            }
        }
        if (message.hasPropagatedTimestamp() && message.getPropagatedTimestamp() != -1L) {
            client.updateLastPropagatedTimestamp(message.getPropagatedTimestamp());
        }
        if (message.hasCacheBlocks()) {
            builder.cacheBlocks(message.getCacheBlocks());
        }
        if (message.hasFaultTolerant()) {
            builder.setFaultTolerant(message.getFaultTolerant());
        }
        if (message.hasBatchSizeBytes()) {
            builder.batchSizeBytes(message.getBatchSizeBytes());
        }
        if (message.hasScanRequestTimeoutMs()) {
            builder.scanRequestTimeout(message.getScanRequestTimeoutMs());
        }
        if (message.hasKeepAlivePeriodMs()) {
            builder.keepAlivePeriodMs(message.getKeepAlivePeriodMs());
        }
        return builder;
    }

    private static KuduTable getKuduTable(Client.ScanTokenPB message, KuduClient client) throws KuduException {
        if (message.hasTableMetadata()) {
            Client.TableMetadataPB tableMetadata = message.getTableMetadata();
            Schema schema = ProtobufHelper.pbToSchema(tableMetadata.getSchema());
            PartitionSchema partitionSchema = ProtobufHelper.pbToPartitionSchema(tableMetadata.getPartitionSchema(), schema);
            return new KuduTable(client.asyncClient, tableMetadata.getTableName(), tableMetadata.getTableId(), schema, partitionSchema, tableMetadata.getNumReplicas(), tableMetadata.getExtraConfigsMap(), tableMetadata.getOwner(), tableMetadata.getComment());
        }
        if (message.hasTableId()) {
            return client.openTableById(message.getTableId());
        }
        return client.openTable(message.getTableName());
    }

    @Override
    public int compareTo(KuduScanToken other) {
        if (this.message.hasTableId() && other.message.hasTableId() ? !this.message.getTableId().equals(other.message.getTableId()) : !this.message.getTableName().equals(other.message.getTableName())) {
            throw new IllegalArgumentException("Scan tokens from different tables may not be compared");
        }
        return this.tablet.getPartition().compareTo(other.getTablet().getPartition());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KuduScanToken)) {
            return false;
        }
        KuduScanToken that = (KuduScanToken)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.tablet, this.message);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class KuduScanTokenBuilder
    extends AbstractKuduScannerBuilder<KuduScanTokenBuilder, List<KuduScanToken>> {
        private static final int DEFAULT_SPLIT_SIZE_BYTES = -1;
        private long timeout;
        private long splitSizeBytes = -1L;
        private boolean includeTableMetadata = true;
        private boolean includeTabletMetadata = true;

        KuduScanTokenBuilder(AsyncKuduClient client, KuduTable table) {
            super(client, table);
            this.timeout = client.getDefaultOperationTimeoutMs();
        }

        public KuduScanTokenBuilder setTimeout(long timeoutMs) {
            this.timeout = timeoutMs;
            return this;
        }

        public KuduScanTokenBuilder setSplitSizeBytes(long splitSizeBytes) {
            this.splitSizeBytes = splitSizeBytes;
            return this;
        }

        public KuduScanTokenBuilder includeTableMetadata(boolean includeMetadata) {
            this.includeTableMetadata = includeMetadata;
            return this;
        }

        public KuduScanTokenBuilder includeTabletMetadata(boolean includeMetadata) {
            this.includeTabletMetadata = includeMetadata;
            return this;
        }

        @Override
        public List<KuduScanToken> build() {
            ColumnSchema columnSchema;
            Iterator indexes;
            if (this.lowerBoundPartitionKey.length != 0 || this.upperBoundPartitionKey.length != 0) {
                throw new IllegalArgumentException("Partition key bounds may not be set on KuduScanTokenBuilder");
            }
            for (KuduPredicate predicate : this.predicates.values()) {
                if (predicate.getType() != KuduPredicate.PredicateType.NONE) continue;
                return new ArrayList<KuduScanToken>();
            }
            Client.ScanTokenPB.Builder proto = Client.ScanTokenPB.newBuilder();
            if (this.includeTableMetadata) {
                Client.TableMetadataPB tableMetadataPB = Client.TableMetadataPB.newBuilder().setTableId(this.table.getTableId()).setTableName(this.table.getName()).setOwner(this.table.getOwner()).setComment(this.table.getComment()).setNumReplicas(this.table.getNumReplicas()).setSchema(ProtobufHelper.schemaToPb(this.table.getSchema())).setPartitionSchema(ProtobufHelper.partitionSchemaToPb(this.table.getPartitionSchema())).putAllExtraConfigs(this.table.getExtraConfig()).build();
                proto.setTableMetadata(tableMetadataPB);
                Token.SignedTokenPB authzToken = this.client.getAuthzToken(this.table.getTableId());
                if (authzToken != null) {
                    proto.setAuthzToken(authzToken);
                }
            } else {
                proto.setTableId(this.table.getTableId());
                proto.setTableName(this.table.getName());
            }
            Schema schema = this.table.getSchema();
            if (this.includeTableMetadata) {
                if (this.projectedColumnNames != null) {
                    for (String columnName : this.projectedColumnNames) {
                        proto.addProjectedColumnIdx(schema.getColumnIndex(columnName));
                    }
                } else if (this.projectedColumnIndexes != null) {
                    proto.addAllProjectedColumnIdx(this.projectedColumnIndexes);
                } else {
                    indexes = IntStream.range(0, schema.getColumnCount()).boxed().collect(Collectors.toList());
                    proto.addAllProjectedColumnIdx((Iterable<? extends Integer>)((Object)indexes));
                }
            } else if (this.projectedColumnNames != null) {
                for (String columnName : this.projectedColumnNames) {
                    columnSchema = schema.getColumn(columnName);
                    Preconditions.checkArgument(columnSchema != null, "unknown column i%s", (Object)columnName);
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), schema.hasColumnIds() ? schema.getColumnId(columnName) : -1, columnSchema);
                }
            } else if (this.projectedColumnIndexes != null) {
                indexes = this.projectedColumnIndexes.iterator();
                while (indexes.hasNext()) {
                    int columnIdx = (Integer)indexes.next();
                    columnSchema = schema.getColumnByIndex(columnIdx);
                    Preconditions.checkArgument(columnSchema != null, "unknown column index %s", columnIdx);
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), schema.hasColumnIds() ? schema.getColumnId(columnSchema.getName()) : -1, columnSchema);
                }
            } else {
                for (ColumnSchema column : schema.getColumns()) {
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), schema.hasColumnIds() ? schema.getColumnId(column.getName()) : -1, column);
                }
            }
            for (KuduPredicate predicate : this.predicates.values()) {
                proto.addColumnPredicates(predicate.toPB());
            }
            if (this.lowerBoundPrimaryKey.length > 0) {
                proto.setLowerBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(this.lowerBoundPrimaryKey));
            }
            if (this.upperBoundPrimaryKey.length > 0) {
                proto.setUpperBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(this.upperBoundPrimaryKey));
            }
            proto.setLimit(this.limit);
            proto.setReadMode(this.readMode.pbVersion());
            if (this.replicaSelection == ReplicaSelection.LEADER_ONLY) {
                proto.setReplicaSelection(Common.ReplicaSelection.LEADER_ONLY);
            } else if (this.replicaSelection == ReplicaSelection.CLOSEST_REPLICA) {
                proto.setReplicaSelection(Common.ReplicaSelection.CLOSEST_REPLICA);
            }
            if (this.table.getAsyncClient().getLastPropagatedTimestamp() != -1L) {
                proto.setPropagatedTimestamp(this.client.getLastPropagatedTimestamp());
            }
            if (this.readMode == AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT) {
                if (this.htTimestamp != -1L) {
                    proto.setSnapTimestamp(this.htTimestamp);
                }
                if (this.startTimestamp != -1L) {
                    proto.setSnapStartTimestamp(this.startTimestamp);
                }
            }
            proto.setCacheBlocks(this.cacheBlocks);
            proto.setFaultTolerant(this.isFaultTolerant);
            proto.setBatchSizeBytes(this.batchSizeBytes);
            proto.setScanRequestTimeoutMs(this.scanRequestTimeout);
            proto.setKeepAlivePeriodMs(this.keepAlivePeriodMs);
            try {
                PartitionPruner pruner = PartitionPruner.create(this);
                ArrayList keyRanges = new ArrayList();
                while (pruner.hasMorePartitionKeyRanges()) {
                    Pair<byte[], byte[]> partitionRange = pruner.nextPartitionKeyRange();
                    List newKeyRanges = (List)this.client.getTableKeyRanges(this.table, proto.getLowerBoundPrimaryKey().toByteArray(), proto.getUpperBoundPrimaryKey().toByteArray(), partitionRange.getFirst().length == 0 ? null : partitionRange.getFirst(), partitionRange.getSecond().length == 0 ? null : partitionRange.getSecond(), AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, this.splitSizeBytes, this.timeout).join();
                    if (newKeyRanges.isEmpty()) {
                        pruner.removePartitionKeyRange(partitionRange.getSecond());
                    } else {
                        pruner.removePartitionKeyRange(((KeyRange)newKeyRanges.get(newKeyRanges.size() - 1)).getPartitionKeyEnd());
                    }
                    keyRanges.addAll(newKeyRanges);
                }
                ArrayList<KuduScanToken> tokens = new ArrayList<KuduScanToken>(keyRanges.size());
                for (KeyRange keyRange : keyRanges) {
                    TableLocationsCache.Entry entry;
                    byte[] primaryKeyEnd;
                    Client.ScanTokenPB.Builder builder = proto.clone();
                    builder.setLowerBoundPartitionKey(UnsafeByteOperations.unsafeWrap(keyRange.getPartitionKeyStart()));
                    builder.setUpperBoundPartitionKey(UnsafeByteOperations.unsafeWrap(keyRange.getPartitionKeyEnd()));
                    byte[] primaryKeyStart = keyRange.getPrimaryKeyStart();
                    if (primaryKeyStart != null && primaryKeyStart.length > 0) {
                        builder.setLowerBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(primaryKeyStart));
                    }
                    if ((primaryKeyEnd = keyRange.getPrimaryKeyEnd()) != null && primaryKeyEnd.length > 0) {
                        builder.setUpperBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(primaryKeyEnd));
                    }
                    LocatedTablet tablet = keyRange.getTablet();
                    if (this.includeTabletMetadata && (entry = this.client.getTableLocationEntry(this.table.getTableId(), tablet.getPartition().partitionKeyStart)) != null && !entry.isNonCoveredRange() && !entry.isStale()) {
                        RemoteTablet remoteTablet = entry.getTablet();
                        ArrayList<Client.ServerMetadataPB> servers = new ArrayList<Client.ServerMetadataPB>();
                        HashMap<HostAndPort, Integer> serverIndexMap = new HashMap<HostAndPort, Integer>();
                        List<ServerInfo> tabletServers = remoteTablet.getTabletServersCopy();
                        for (int i = 0; i < tabletServers.size(); ++i) {
                            ServerInfo serverInfo = tabletServers.get(i);
                            Client.ServerMetadataPB serverMetadataPB = Client.ServerMetadataPB.newBuilder().setUuid(ByteString.copyFromUtf8(serverInfo.getUuid())).addRpcAddresses(ProtobufHelper.hostAndPortToPB(serverInfo.getHostAndPort())).setLocation(serverInfo.getLocation()).build();
                            servers.add(serverMetadataPB);
                            serverIndexMap.put(serverInfo.getHostAndPort(), i);
                        }
                        ArrayList<Client.TabletMetadataPB.ReplicaMetadataPB> replicas = new ArrayList<Client.TabletMetadataPB.ReplicaMetadataPB>();
                        for (LocatedTablet.Replica replica : remoteTablet.getReplicas()) {
                            Integer serverIndex = (Integer)serverIndexMap.get(new HostAndPort(replica.getRpcHost(), replica.getRpcPort()));
                            if (serverIndex == null) continue;
                            Client.TabletMetadataPB.ReplicaMetadataPB.Builder tabletMetadataBuilder = Client.TabletMetadataPB.ReplicaMetadataPB.newBuilder().setRole(replica.getRoleAsEnum()).setTsIdx(serverIndex);
                            if (replica.getDimensionLabel() != null) {
                                tabletMetadataBuilder.setDimensionLabel(replica.getDimensionLabel());
                            }
                            replicas.add(tabletMetadataBuilder.build());
                        }
                        Client.TabletMetadataPB tabletMetadataPB = Client.TabletMetadataPB.newBuilder().setTabletId(remoteTablet.getTabletId()).setPartition(ProtobufHelper.partitionToPb(remoteTablet.getPartition())).addAllReplicas(replicas).addAllTabletServers(servers).setTtlMillis(entry.ttl()).build();
                        builder.setTabletMetadata(tabletMetadataPB);
                    }
                    tokens.add(new KuduScanToken(keyRange.getTablet(), builder.build()));
                }
                return tokens;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

