/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Random;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduMetrics;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.TimeoutTracker;
import org.apache.kudu.test.RandomUtils;
import org.apache.kudu.test.cluster.FakeDNS;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduTestHarness
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(KuduTestHarness.class);
    private static final int NUM_MASTER_SERVERS = 3;
    private static final int NUM_TABLET_SERVERS = 3;
    public static final int DEFAULT_SLEEP = 50000;
    private final Random randomForTSRestart = RandomUtils.getRandom();
    private MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder;
    private MiniKuduCluster miniCluster;
    private AsyncKuduClient asyncClient;
    private KuduClient client;

    public KuduTestHarness(MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder) {
        this.clusterBuilder = clusterBuilder;
    }

    public KuduTestHarness() {
        this.clusterBuilder = KuduTestHarness.getBaseClusterBuilder();
    }

    public static MiniKuduCluster.MiniKuduClusterBuilder getBaseClusterBuilder() {
        return new MiniKuduCluster.MiniKuduClusterBuilder().numMasterServers(3).numTabletServers(3);
    }

    public Statement apply(Statement base, Description description) {
        TabletServerConfig tabletServerConfig;
        LocationConfig locationConfig;
        MasterServerConfig masterServerConfig = (MasterServerConfig)description.getAnnotation(MasterServerConfig.class);
        if (masterServerConfig != null) {
            for (String flag : masterServerConfig.flags()) {
                this.clusterBuilder.addMasterServerFlag(flag);
            }
        }
        if ((locationConfig = (LocationConfig)description.getAnnotation(LocationConfig.class)) != null) {
            for (String location : locationConfig.locations()) {
                this.clusterBuilder.addLocation(location);
            }
        }
        if ((tabletServerConfig = (TabletServerConfig)description.getAnnotation(TabletServerConfig.class)) != null) {
            for (String flag : tabletServerConfig.flags()) {
                this.clusterBuilder.addTabletServerFlag(flag);
            }
        }
        Statement statement = super.apply(base, description);
        return new RetryRule().apply(statement, description);
    }

    public void before() throws Exception {
        FakeDNS.getInstance().install();
        KuduMetrics.setEnabled(true);
        LOG.info("Creating a new MiniKuduCluster...");
        this.miniCluster = this.clusterBuilder.build();
        LOG.info("Creating a new Kudu client...");
        this.asyncClient = new AsyncKuduClient.AsyncKuduClientBuilder(this.miniCluster.getMasterAddressesAsString()).defaultAdminOperationTimeoutMs(50000L).build();
        this.client = this.asyncClient.syncClient();
    }

    public void after() {
        try {
            if (this.client != null) {
                this.client.shutdown();
            }
        }
        catch (KuduException e) {
            LOG.warn("Error while shutting down the test client", (Throwable)e);
        }
        finally {
            if (this.miniCluster != null) {
                this.miniCluster.shutdown();
            }
        }
    }

    public KuduClient getClient() {
        return this.client;
    }

    public AsyncKuduClient getAsyncClient() {
        return this.asyncClient;
    }

    public void killTabletLeader(KuduTable table) throws Exception {
        LocatedTablet tablet;
        List<LocatedTablet> tablets = table.getTabletsLocations(50000L);
        if (tablets.size() != 1) {
            Assert.fail((String)("Currently only support killing leaders for tables containing 1 tablet, table " + table.getName() + " has " + tablets.size()));
        }
        if ((tablet = tablets.get(0)).getReplicas().size() == 1) {
            Assert.fail((String)("Table " + table.getName() + " only has 1 tablet, please enable replication"));
        }
        HostAndPort hp = this.findLeaderTabletServer(tablet);
        this.miniCluster.killTabletServer(hp);
    }

    public void killTabletLeader(RemoteTablet tablet) throws Exception {
        this.killTabletLeader(new LocatedTablet(tablet));
    }

    public void killTabletLeader(LocatedTablet tablet) throws Exception {
        HostAndPort hp = this.findLeaderTabletServer(tablet);
        this.miniCluster.killTabletServer(hp);
    }

    public HostAndPort findLeaderTabletServer(LocatedTablet tablet) throws Exception {
        LocatedTablet.Replica leader = null;
        TimeoutTracker timeoutTracker = new TimeoutTracker();
        timeoutTracker.setTimeout(50000L);
        while (leader == null) {
            if (timeoutTracker.timedOut()) {
                Assert.fail((String)"Timed out while trying to find a leader for this table");
            }
            if ((leader = tablet.getLeaderReplica()) != null) continue;
            LOG.info("Sleeping while waiting for a tablet LEADER to arise, currently slept {} ms", (Object)timeoutTracker.getElapsedMillis());
            Thread.sleep(50L);
        }
        return new HostAndPort(leader.getRpcHost(), leader.getRpcPort());
    }

    public void killLeaderMasterServer() throws Exception {
        HostAndPort hp = this.findLeaderMasterServer();
        this.miniCluster.killMasterServer(hp);
    }

    public HostAndPort findLeaderMasterServer() throws Exception {
        return this.client.findLeaderMasterServer();
    }

    public void restartTabletServer(KuduTable table) throws Exception {
        List<LocatedTablet> tablets = table.getTabletsLocations(50000L);
        if (tablets.isEmpty()) {
            Assert.fail((String)("Table " + table.getName() + " doesn't have any tablets"));
        }
        LocatedTablet tablet = tablets.get(0);
        LocatedTablet.Replica replica = tablet.getReplicas().get(this.randomForTSRestart.nextInt(tablet.getReplicas().size()));
        HostAndPort hp = new HostAndPort(replica.getRpcHost(), replica.getRpcPort());
        this.miniCluster.killTabletServer(hp);
        this.miniCluster.startTabletServer(hp);
    }

    public void restartTabletServer(RemoteTablet tablet) throws Exception {
        HostAndPort hp = this.findLeaderTabletServer(new LocatedTablet(tablet));
        this.miniCluster.killTabletServer(hp);
        this.miniCluster.startTabletServer(hp);
    }

    public void restartLeaderMaster() throws Exception {
        HostAndPort hp = this.findLeaderMasterServer();
        this.miniCluster.killMasterServer(hp);
        this.miniCluster.startMasterServer(hp);
    }

    public String getMasterAddressesAsString() {
        return this.miniCluster.getMasterAddressesAsString();
    }

    public List<HostAndPort> getMasterServers() {
        return this.miniCluster.getMasterServers();
    }

    public List<HostAndPort> getTabletServers() {
        return this.miniCluster.getMasterServers();
    }

    public String getClusterRoot() {
        return this.miniCluster.getClusterRoot();
    }

    public void killAllMasterServers() throws IOException {
        this.miniCluster.killAllMasterServers();
    }

    public void startAllMasterServers() throws IOException {
        this.miniCluster.startAllMasterServers();
    }

    public void killAllTabletServers() throws IOException {
        this.miniCluster.killAllTabletServers();
    }

    public void startAllTabletServers() throws IOException {
        this.miniCluster.startAllTabletServers();
    }

    public void kdestroy() throws IOException {
        this.miniCluster.kdestroy();
    }

    public void kinit(String username) throws IOException {
        this.miniCluster.kinit(username);
    }

    public void resetClients() throws IOException {
        this.client.shutdown();
        this.asyncClient = new AsyncKuduClient.AsyncKuduClientBuilder(this.miniCluster.getMasterAddressesAsString()).defaultAdminOperationTimeoutMs(50000L).build();
        this.client = this.asyncClient.syncClient();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface LocationConfig {
        public String[] locations();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface TabletServerConfig {
        public String[] flags();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface MasterServerConfig {
        public String[] flags();
    }
}

