/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;

public class ToChildBlockJoinQuery
extends Query {
    static final String INVALID_QUERY_MESSAGE = "Parent query yields document which is not matched by parents filter, docID=";
    static final String ILLEGAL_ADVANCE_ON_PARENT = "Expect to be advanced on child docs only. got docID=";
    private final BitSetProducer parentsFilter;
    private final Query parentQuery;
    private final Query origParentQuery;

    public ToChildBlockJoinQuery(Query parentQuery, BitSetProducer parentsFilter) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
    }

    private ToChildBlockJoinQuery(Query origParentQuery, Query parentQuery, BitSetProducer parentsFilter) {
        this.origParentQuery = origParentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ToChildBlockJoinWeight(this, this.parentQuery.createWeight(searcher, needsScores), this.parentsFilter, needsScores);
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            return new ToChildBlockJoinQuery(this.parentQuery, parentRewrite, this.parentsFilter);
        }
        return super.rewrite(reader);
    }

    public String toString(String field) {
        return "ToChildBlockJoinQuery (" + this.parentQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof ToChildBlockJoinQuery) {
            ToChildBlockJoinQuery other = (ToChildBlockJoinQuery)((Object)_other);
            return this.origParentQuery.equals((Object)other.origParentQuery) && this.parentsFilter.equals(other.parentsFilter) && super.equals((Object)other);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = super.hashCode();
        hash = 31 * hash + this.origParentQuery.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    static class ToChildBlockJoinScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final DocIdSetIterator parentIt;
        private final BitSet parentBits;
        private final boolean doScores;
        private float parentScore;
        private int parentFreq = 1;
        private int childDoc = -1;
        private int parentDoc = 0;

        public ToChildBlockJoinScorer(Weight weight, Scorer parentScorer, BitSet parentBits, boolean doScores) {
            super(weight);
            this.doScores = doScores;
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
            this.parentIt = parentScorer.iterator();
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.parentScorer, "BLOCK_JOIN"));
        }

        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){

                public int docID() {
                    return ToChildBlockJoinScorer.this.childDoc;
                }

                public int nextDoc() throws IOException {
                    if (ToChildBlockJoinScorer.this.childDoc + 1 == ToChildBlockJoinScorer.this.parentDoc) {
                        do {
                            ToChildBlockJoinScorer.this.parentDoc = ToChildBlockJoinScorer.this.parentIt.nextDoc();
                            ToChildBlockJoinScorer.this.validateParentDoc();
                            if (ToChildBlockJoinScorer.this.parentDoc == 0) {
                                ToChildBlockJoinScorer.this.parentDoc = ToChildBlockJoinScorer.this.parentIt.nextDoc();
                                ToChildBlockJoinScorer.this.validateParentDoc();
                            }
                            if (ToChildBlockJoinScorer.this.parentDoc == Integer.MAX_VALUE) {
                                ToChildBlockJoinScorer.this.childDoc = Integer.MAX_VALUE;
                                return ToChildBlockJoinScorer.this.childDoc;
                            }
                            ToChildBlockJoinScorer.this.childDoc = 1 + ToChildBlockJoinScorer.this.parentBits.prevSetBit(ToChildBlockJoinScorer.this.parentDoc - 1);
                        } while (ToChildBlockJoinScorer.this.childDoc == ToChildBlockJoinScorer.this.parentDoc || ToChildBlockJoinScorer.this.childDoc >= ToChildBlockJoinScorer.this.parentDoc);
                        if (ToChildBlockJoinScorer.this.doScores) {
                            ToChildBlockJoinScorer.this.parentScore = ToChildBlockJoinScorer.this.parentScorer.score();
                            ToChildBlockJoinScorer.this.parentFreq = ToChildBlockJoinScorer.this.parentScorer.freq();
                        }
                        return ToChildBlockJoinScorer.this.childDoc;
                    }
                    assert (ToChildBlockJoinScorer.this.childDoc < ToChildBlockJoinScorer.this.parentDoc) : "childDoc=" + ToChildBlockJoinScorer.access$000(ToChildBlockJoinScorer.this) + " parentDoc=" + ToChildBlockJoinScorer.access$100(ToChildBlockJoinScorer.this);
                    ToChildBlockJoinScorer.this.childDoc++;
                    return ToChildBlockJoinScorer.this.childDoc;
                }

                public int advance(int childTarget) throws IOException {
                    if (childTarget >= ToChildBlockJoinScorer.this.parentDoc) {
                        int firstChild;
                        block7: {
                            if (childTarget == Integer.MAX_VALUE) {
                                return ToChildBlockJoinScorer.this.childDoc = (ToChildBlockJoinScorer.this.parentDoc = Integer.MAX_VALUE);
                            }
                            ToChildBlockJoinScorer.this.parentDoc = ToChildBlockJoinScorer.this.parentIt.advance(childTarget + 1);
                            ToChildBlockJoinScorer.this.validateParentDoc();
                            if (ToChildBlockJoinScorer.this.parentDoc == Integer.MAX_VALUE) {
                                return ToChildBlockJoinScorer.this.childDoc = Integer.MAX_VALUE;
                            }
                            do {
                                if ((firstChild = ToChildBlockJoinScorer.this.parentBits.prevSetBit(ToChildBlockJoinScorer.this.parentDoc - 1) + 1) != ToChildBlockJoinScorer.this.parentDoc) break block7;
                                ToChildBlockJoinScorer.this.parentDoc = ToChildBlockJoinScorer.this.parentIt.nextDoc();
                                ToChildBlockJoinScorer.this.validateParentDoc();
                            } while (ToChildBlockJoinScorer.this.parentDoc != Integer.MAX_VALUE);
                            return ToChildBlockJoinScorer.this.childDoc = Integer.MAX_VALUE;
                        }
                        childTarget = Math.max(childTarget, firstChild);
                        if (ToChildBlockJoinScorer.this.doScores) {
                            ToChildBlockJoinScorer.this.parentScore = ToChildBlockJoinScorer.this.parentScorer.score();
                            ToChildBlockJoinScorer.this.parentFreq = ToChildBlockJoinScorer.this.parentScorer.freq();
                        }
                    }
                    assert (childTarget < ToChildBlockJoinScorer.this.parentDoc);
                    assert (!ToChildBlockJoinScorer.this.parentBits.get(childTarget));
                    ToChildBlockJoinScorer.this.childDoc = childTarget;
                    return ToChildBlockJoinScorer.this.childDoc;
                }

                public long cost() {
                    return ToChildBlockJoinScorer.this.parentIt.cost();
                }
            };
        }

        private void validateParentDoc() {
            if (this.parentDoc != Integer.MAX_VALUE && !this.parentBits.get(this.parentDoc)) {
                throw new IllegalStateException(ToChildBlockJoinQuery.INVALID_QUERY_MESSAGE + this.parentDoc);
            }
        }

        public int docID() {
            return this.childDoc;
        }

        public float score() throws IOException {
            return this.parentScore;
        }

        public int freq() throws IOException {
            return this.parentFreq;
        }

        int getParentDoc() {
            return this.parentDoc;
        }
    }

    private static class ToChildBlockJoinWeight
    extends Weight {
        private final Weight parentWeight;
        private final BitSetProducer parentsFilter;
        private final boolean doScores;

        public ToChildBlockJoinWeight(Query joinQuery, Weight parentWeight, BitSetProducer parentsFilter, boolean doScores) {
            super(joinQuery);
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
            this.doScores = doScores;
        }

        public void extractTerms(Set<Term> terms) {
            this.parentWeight.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.parentWeight.getValueForNormalization();
        }

        public void normalize(float norm, float boost) {
            this.parentWeight.normalize(norm, boost);
        }

        public Scorer scorer(LeafReaderContext readerContext) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(readerContext);
            if (parentScorer == null) {
                return null;
            }
            BitSet parents = this.parentsFilter.getBitSet(readerContext);
            if (parents == null) {
                return null;
            }
            return new ToChildBlockJoinScorer(this, parentScorer, parents, this.doScores);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            ToChildBlockJoinScorer scorer = (ToChildBlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.iterator().advance(doc) == doc) {
                int parentDoc = scorer.getParentDoc();
                return Explanation.match((float)scorer.score(), (String)String.format(Locale.ROOT, "Score based on parent document %d", parentDoc + context.docBase), (Explanation[])new Explanation[]{this.parentWeight.explain(context, parentDoc)});
            }
            return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
        }
    }
}

