/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Mirror
extends IdentifiableBase
implements Serializable,
InputLocationTracker {
    final String mirrorOf;
    final String name;
    final String url;
    final String layout;
    final String mirrorOfLayouts;
    final boolean blocked;

    Mirror(String id, String mirrorOf, String name, String url, String layout, String mirrorOfLayouts, boolean blocked, Map<Object, InputLocation> locations) {
        super(id, locations);
        this.mirrorOf = mirrorOf;
        this.name = name;
        this.url = url;
        this.layout = layout;
        this.mirrorOfLayouts = mirrorOfLayouts;
        this.blocked = blocked;
    }

    public String getMirrorOf() {
        return this.mirrorOf;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLayout() {
        return this.layout;
    }

    public String getMirrorOfLayouts() {
        return this.mirrorOfLayouts;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Mirror.newBuilder(this);
    }

    @Override
    @Nonnull
    public Mirror withId(String id) {
        return Mirror.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Mirror withMirrorOf(String mirrorOf) {
        return Mirror.newBuilder(this, true).mirrorOf(mirrorOf).build();
    }

    @Nonnull
    public Mirror withName(String name) {
        return Mirror.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Mirror withUrl(String url) {
        return Mirror.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public Mirror withLayout(String layout) {
        return Mirror.newBuilder(this, true).layout(layout).build();
    }

    @Nonnull
    public Mirror withMirrorOfLayouts(String mirrorOfLayouts) {
        return Mirror.newBuilder(this, true).mirrorOfLayouts(mirrorOfLayouts).build();
    }

    @Nonnull
    public Mirror withBlocked(boolean blocked) {
        return Mirror.newBuilder(this, true).blocked(blocked).build();
    }

    @Nonnull
    public static Mirror newInstance() {
        return Mirror.newInstance(true);
    }

    @Nonnull
    public static Mirror newInstance(boolean withDefaults) {
        return Mirror.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Mirror.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Mirror from) {
        return Mirror.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Mirror from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Mirror[");
        sb.append("id=").append(this.getId());
        sb.append(",mirrorOf=").append(this.getMirrorOf());
        sb.append(",url=").append(this.getUrl());
        sb.append(",name=").append(this.getName());
        if (this.isBlocked()) {
            sb.append(",blocked");
        }
        sb.append("]");
        return sb.toString();
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        Mirror base;
        String mirrorOf;
        String name;
        String url;
        String layout;
        String mirrorOfLayouts;
        Boolean blocked;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.layout = "default";
                this.mirrorOfLayouts = "default,legacy";
                this.blocked = false;
            }
        }

        Builder(Mirror base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.mirrorOf = base.mirrorOf;
                this.name = base.name;
                this.url = base.url;
                this.layout = base.layout;
                this.mirrorOfLayouts = base.mirrorOfLayouts;
                this.blocked = base.blocked;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder mirrorOf(String mirrorOf) {
            this.mirrorOf = mirrorOf;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public Builder mirrorOfLayouts(String mirrorOfLayouts) {
            this.mirrorOfLayouts = mirrorOfLayouts;
            return this;
        }

        @Nonnull
        public Builder blocked(boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Mirror build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.mirrorOf != null && this.mirrorOf != this.base.mirrorOf || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout || this.mirrorOfLayouts != null && this.mirrorOfLayouts != this.base.mirrorOfLayouts || this.blocked != null && this.blocked != this.base.blocked)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("id", newlocs.containsKey("id") ? (InputLocation)newlocs.get("id") : (InputLocation)oldlocs.get("id"));
            locations.put("mirrorOf", newlocs.containsKey("mirrorOf") ? (InputLocation)newlocs.get("mirrorOf") : (InputLocation)oldlocs.get("mirrorOf"));
            locations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
            locations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
            locations.put("layout", newlocs.containsKey("layout") ? (InputLocation)newlocs.get("layout") : (InputLocation)oldlocs.get("layout"));
            locations.put("mirrorOfLayouts", newlocs.containsKey("mirrorOfLayouts") ? (InputLocation)newlocs.get("mirrorOfLayouts") : (InputLocation)oldlocs.get("mirrorOfLayouts"));
            locations.put("blocked", newlocs.containsKey("blocked") ? (InputLocation)newlocs.get("blocked") : (InputLocation)oldlocs.get("blocked"));
            return new Mirror(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.mirrorOf != null ? this.mirrorOf : (this.base != null ? this.base.mirrorOf : null), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.layout != null ? this.layout : (this.base != null ? this.base.layout : null), this.mirrorOfLayouts != null ? this.mirrorOfLayouts : (this.base != null ? this.base.mirrorOfLayouts : null), this.blocked != null ? this.blocked : (this.base != null ? this.base.blocked : false), locations);
        }
    }
}

