/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Repository
extends RepositoryBase
implements Serializable,
InputLocationTracker {
    final RepositoryPolicy releases;
    final RepositoryPolicy snapshots;

    Repository(String id, String name, String url, String layout, RepositoryPolicy releases, RepositoryPolicy snapshots, Map<Object, InputLocation> locations) {
        super(id, name, url, layout, locations);
        this.releases = releases;
        this.snapshots = snapshots;
    }

    public RepositoryPolicy getReleases() {
        return this.releases;
    }

    public RepositoryPolicy getSnapshots() {
        return this.snapshots;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Repository.newBuilder(this);
    }

    @Override
    @Nonnull
    public Repository withId(String id) {
        return Repository.newBuilder(this, true).id(id).build();
    }

    @Override
    @Nonnull
    public Repository withName(String name) {
        return Repository.newBuilder(this, true).name(name).build();
    }

    @Override
    @Nonnull
    public Repository withUrl(String url) {
        return Repository.newBuilder(this, true).url(url).build();
    }

    @Override
    @Nonnull
    public Repository withLayout(String layout) {
        return Repository.newBuilder(this, true).layout(layout).build();
    }

    @Nonnull
    public Repository withReleases(RepositoryPolicy releases) {
        return Repository.newBuilder(this, true).releases(releases).build();
    }

    @Nonnull
    public Repository withSnapshots(RepositoryPolicy snapshots) {
        return Repository.newBuilder(this, true).snapshots(snapshots).build();
    }

    @Nonnull
    public static Repository newInstance() {
        return Repository.newInstance(true);
    }

    @Nonnull
    public static Repository newInstance(boolean withDefaults) {
        return Repository.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Repository.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Repository from) {
        return Repository.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Repository from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends RepositoryBase.Builder {
        Repository base;
        RepositoryPolicy releases;
        RepositoryPolicy snapshots;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Repository base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.releases = base.releases;
                this.snapshots = base.snapshots;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public Builder releases(RepositoryPolicy releases) {
            this.releases = releases;
            return this;
        }

        @Nonnull
        public Builder snapshots(RepositoryPolicy snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Repository build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout || this.releases != null && this.releases != this.base.releases || this.snapshots != null && this.snapshots != this.base.snapshots)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("id", newlocs.containsKey("id") ? (InputLocation)newlocs.get("id") : (InputLocation)oldlocs.get("id"));
            locations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
            locations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
            locations.put("layout", newlocs.containsKey("layout") ? (InputLocation)newlocs.get("layout") : (InputLocation)oldlocs.get("layout"));
            locations.put("releases", newlocs.containsKey("releases") ? (InputLocation)newlocs.get("releases") : (InputLocation)oldlocs.get("releases"));
            locations.put("snapshots", newlocs.containsKey("snapshots") ? (InputLocation)newlocs.get("snapshots") : (InputLocation)oldlocs.get("snapshots"));
            return new Repository(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.layout != null ? this.layout : (this.base != null ? this.base.layout : null), this.releases != null ? this.releases : (this.base != null ? this.base.releases : null), this.snapshots != null ? this.snapshots : (this.base != null ? this.base.snapshots : null), locations);
        }
    }
}

