/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.interpolation.AssemblyExpressionEvaluator;
import org.apache.maven.plugins.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugins.assembly.io.AssemblyReadException;
import org.apache.maven.plugins.assembly.io.AssemblyReader;
import org.apache.maven.plugins.assembly.io.ClasspathResourceLocatorStrategy;
import org.apache.maven.plugins.assembly.io.FileLocatorStrategy;
import org.apache.maven.plugins.assembly.io.Location;
import org.apache.maven.plugins.assembly.io.Locator;
import org.apache.maven.plugins.assembly.io.LocatorStrategy;
import org.apache.maven.plugins.assembly.io.PrefixedClasspathLocatorStrategy;
import org.apache.maven.plugins.assembly.io.RelativeFileLocatorStrategy;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.Component;
import org.apache.maven.plugins.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Writer;
import org.apache.maven.plugins.assembly.model.io.xpp3.ComponentXpp3Reader;
import org.apache.maven.plugins.assembly.resolved.AssemblyId;
import org.apache.maven.plugins.assembly.utils.InterpolationConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;
import org.codehaus.plexus.interpolation.fixed.InterpolationState;
import org.codehaus.plexus.interpolation.fixed.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedPropertiesValueSource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultAssemblyReader
implements AssemblyReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAssemblyReader.class);

    public static FixedStringSearchInterpolator createProjectInterpolator(MavenProject project) {
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{new PrefixedPropertiesValueSource(InterpolationConstants.PROJECT_PROPERTIES_PREFIXES, project.getProperties(), true), new PrefixedObjectValueSource(InterpolationConstants.PROJECT_PREFIXES, (Object)project, true)});
    }

    @Override
    public List<Assembly> readAssemblies(AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Locator locator = new Locator();
        ArrayList<LocatorStrategy> strategies = new ArrayList<LocatorStrategy>();
        strategies.add(new RelativeFileLocatorStrategy(configSource.getBasedir()));
        strategies.add(new FileLocatorStrategy());
        ArrayList<LocatorStrategy> refStrategies = new ArrayList<LocatorStrategy>();
        refStrategies.add(new PrefixedClasspathLocatorStrategy("/assemblies/"));
        ArrayList<Assembly> assemblies = new ArrayList<Assembly>();
        String[] descriptors = configSource.getDescriptors();
        String[] descriptorRefs = configSource.getDescriptorReferences();
        File descriptorSourceDirectory = configSource.getDescriptorSourceDirectory();
        List<Assembly> inlineDescriptors = configSource.getInlineDescriptors();
        if (descriptors != null && descriptors.length > 0) {
            locator.setStrategies(strategies);
            for (String descriptor1 : descriptors) {
                LOGGER.info("Reading assembly descriptor: " + descriptor1);
                this.addAssemblyFromDescriptor(descriptor1, locator, configSource, assemblies);
            }
        }
        if (descriptorRefs != null && descriptorRefs.length > 0) {
            locator.setStrategies(refStrategies);
            for (String descriptorRef : descriptorRefs) {
                this.addAssemblyForDescriptorReference(descriptorRef, configSource, assemblies);
            }
        }
        if (descriptorSourceDirectory != null && descriptorSourceDirectory.isDirectory()) {
            String[] paths;
            locator.setStrategies(Collections.singletonList(new RelativeFileLocatorStrategy(descriptorSourceDirectory)));
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(descriptorSourceDirectory);
            scanner.setIncludes(new String[]{"**/*.xml"});
            scanner.addDefaultExcludes();
            scanner.scan();
            for (String path : paths = scanner.getIncludedFiles()) {
                this.addAssemblyFromDescriptor(path, locator, configSource, assemblies);
            }
        }
        if (inlineDescriptors != null) {
            assemblies.addAll(inlineDescriptors);
        }
        if (assemblies.isEmpty()) {
            if (configSource.isIgnoreMissingDescriptor()) {
                LOGGER.debug("Ignoring missing assembly descriptors per configuration. See messages above for specifics.");
            } else {
                throw new AssemblyReadException("No assembly descriptors found.");
            }
        }
        HashSet<String> ids = new HashSet<String>();
        for (Assembly assembly : assemblies) {
            if (ids.add(assembly.getId())) continue;
            LOGGER.warn("The assembly id " + assembly.getId() + " is used more than once.");
        }
        return assemblies;
    }

    @Override
    public Assembly getAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        return this.addAssemblyForDescriptorReference(ref, configSource, new ArrayList<Assembly>(1));
    }

    @Override
    public Assembly getAssemblyFromDescriptorFile(File file, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        return this.addAssemblyFromDescriptorFile(file, configSource, new ArrayList<Assembly>(1));
    }

    private Assembly addAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        block10: {
            InputStream resourceAsStream = this.getClass().getResourceAsStream("/assemblies/" + ref + ".xml");
            if (resourceAsStream == null) {
                if (configSource.isIgnoreMissingDescriptor()) {
                    LOGGER.debug("Ignoring missing assembly descriptor with ID '" + ref + "' per configuration.");
                    return null;
                }
                throw new AssemblyReadException("Descriptor with ID '" + ref + "' not found");
            }
            XmlStreamReader reader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setInputStream(resourceAsStream)).get();
            try {
                Assembly assembly2 = this.readAssembly((Reader)reader, ref, null, configSource);
                assemblies.add(assembly2);
                assembly = assembly2;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssemblyReadException("Problem with descriptor with ID '" + ref + "'", e);
                }
            }
            reader.close();
        }
        return assembly;
    }

    private Assembly addAssemblyFromDescriptorFile(File descriptor, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        block10: {
            if (!descriptor.exists()) {
                if (configSource.isIgnoreMissingDescriptor()) {
                    LOGGER.debug("Ignoring missing assembly descriptor: '" + descriptor + "' per configuration.");
                    return null;
                }
                throw new AssemblyReadException("Descriptor: '" + descriptor + "' not found");
            }
            XmlStreamReader r = ((XmlStreamReader.Builder)XmlStreamReader.builder().setFile(descriptor)).get();
            try {
                Assembly assembly2 = this.readAssembly((Reader)r, descriptor.getAbsolutePath(), descriptor.getParentFile(), configSource);
                assemblies.add(assembly2);
                assembly = assembly2;
                if (r == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssemblyReadException("Error reading assembly descriptor: " + descriptor, e);
                }
            }
            r.close();
        }
        return assembly;
    }

    private Assembly addAssemblyFromDescriptor(String spec, Locator locator, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        block11: {
            Location location = locator.resolve(spec);
            if (location == null) {
                if (configSource.isIgnoreMissingDescriptor()) {
                    LOGGER.debug("Ignoring missing assembly descriptor with ID '" + spec + "' per configuration.\nLocator output was:\n\n" + locator.getMessageHolder().render());
                    return null;
                }
                throw new AssemblyReadException("Error locating assembly descriptor: " + spec + "\n\n" + locator.getMessageHolder().render());
            }
            XmlStreamReader r = ((XmlStreamReader.Builder)XmlStreamReader.builder().setInputStream(location.getInputStream())).get();
            try {
                File dir = null;
                if (location.getFile() != null) {
                    dir = location.getFile().getParentFile();
                }
                Assembly assembly2 = this.readAssembly((Reader)r, spec, dir, configSource);
                assemblies.add(assembly2);
                assembly = assembly2;
                if (r == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssemblyReadException("Error reading assembly descriptor: " + spec, e);
                }
            }
            r.close();
        }
        return assembly;
    }

    public Assembly readAssembly(Reader reader, String locationDescription, File assemblyDir, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        MavenProject project = configSource.getProject();
        try {
            InterpolationState is = new InterpolationState();
            PrefixAwareRecursionInterceptor interceptor = new PrefixAwareRecursionInterceptor(InterpolationConstants.PROJECT_PREFIXES, true);
            is.setRecursionInterceptor((RecursionInterceptor)interceptor);
            FixedStringSearchInterpolator interpolator = AssemblyInterpolator.fullInterpolator(project, DefaultAssemblyReader.createProjectInterpolator(project), configSource);
            AssemblyXpp3Reader.ContentTransformer transformer = AssemblyInterpolator.assemblyInterpolator(interpolator, is, LOGGER);
            AssemblyXpp3Reader r = new AssemblyXpp3Reader(transformer);
            assembly = r.read(reader);
            ComponentXpp3Reader.ContentTransformer ctrans = AssemblyInterpolator.componentInterpolator(interpolator, is, LOGGER);
            this.mergeComponentsWithMainAssembly(assembly, assemblyDir, configSource, ctrans);
            this.debugPrintAssembly("After assembly is interpolated:", assembly);
            AssemblyInterpolator.checkErrors(AssemblyId.createAssemblyId(assembly), is, LOGGER);
        }
        catch (IOException | XmlPullParserException e) {
            throw new AssemblyReadException("Error reading descriptor: " + locationDescription + ": " + e.getMessage(), e);
        }
        if (assembly.isIncludeSiteDirectory()) {
            this.includeSiteInAssembly(assembly, configSource);
        }
        return assembly;
    }

    private void debugPrintAssembly(String message, Assembly assembly) {
        StringWriter sWriter = new StringWriter();
        try {
            new AssemblyXpp3Writer().write(sWriter, assembly);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to print debug message with assembly descriptor listing, and message: " + message, (Throwable)e);
        }
        LOGGER.debug(message + "\n\n" + sWriter + "\n\n");
    }

    protected void mergeComponentsWithMainAssembly(Assembly assembly, File assemblyDir, AssemblerConfigurationSource configSource, ComponentXpp3Reader.ContentTransformer transformer) throws AssemblyReadException {
        Locator locator = new Locator();
        if (assemblyDir != null && assemblyDir.exists() && assemblyDir.isDirectory()) {
            locator.addStrategy(new RelativeFileLocatorStrategy(assemblyDir));
        }
        locator.addStrategy(new RelativeFileLocatorStrategy(configSource.getBasedir()));
        locator.addStrategy(new FileLocatorStrategy());
        locator.addStrategy(new ClasspathResourceLocatorStrategy());
        AssemblyExpressionEvaluator aee = new AssemblyExpressionEvaluator(configSource);
        List<String> componentLocations = assembly.getComponentDescriptors();
        for (String location : componentLocations) {
            try {
                location = aee.evaluate(location).toString();
            }
            catch (Exception eee) {
                LOGGER.error("Error interpolating componentDescriptor: " + location, (Throwable)eee);
            }
            Location resolvedLocation = locator.resolve(location);
            if (resolvedLocation == null) {
                throw new AssemblyReadException("Failed to locate component descriptor: " + location);
            }
            Component component = null;
            try (InputStreamReader reader = new InputStreamReader(resolvedLocation.getInputStream());){
                component = new ComponentXpp3Reader(transformer).read(reader);
            }
            catch (IOException | XmlPullParserException e) {
                throw new AssemblyReadException("Error reading component descriptor: " + location + " (resolved to: " + resolvedLocation.getSpecification() + ")", e);
            }
            this.mergeComponentWithAssembly(component, assembly);
        }
    }

    protected void mergeComponentWithAssembly(Component component, Assembly assembly) {
        List<ContainerDescriptorHandlerConfig> containerHandlerDescriptors = component.getContainerDescriptorHandlers();
        for (ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig : containerHandlerDescriptors) {
            assembly.addContainerDescriptorHandler(containerDescriptorHandlerConfig);
        }
        List<DependencySet> dependencySetList = component.getDependencySets();
        for (DependencySet dependencySet : dependencySetList) {
            assembly.addDependencySet(dependencySet);
        }
        List<FileSet> list = component.getFileSets();
        for (FileSet fileSet : list) {
            assembly.addFileSet(fileSet);
        }
        List<FileItem> list2 = component.getFiles();
        for (FileItem fileItem : list2) {
            assembly.addFile(fileItem);
        }
        List<ModuleSet> list3 = component.getModuleSets();
        for (ModuleSet moduleSet : list3) {
            assembly.addModuleSet(moduleSet);
        }
    }

    @Override
    public void includeSiteInAssembly(Assembly assembly, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        File siteDirectory = configSource.getSiteDirectory();
        if (!siteDirectory.exists()) {
            throw new InvalidAssemblerConfigurationException("site did not exist in the target directory - please run site:site before creating the assembly");
        }
        LOGGER.info("Adding site directory to assembly : " + siteDirectory);
        FileSet siteFileSet = new FileSet();
        siteFileSet.setDirectory(siteDirectory.getPath());
        siteFileSet.setOutputDirectory("/site");
        assembly.addFileSet(siteFileSet);
    }
}

