/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public final class DependencyUtil {
    public static String getFormattedFileName(Artifact artifact, boolean removeVersion) {
        String destFileName = null;
        if (artifact.getFile() != null && !removeVersion) {
            destFileName = artifact.getFile().getName();
        } else {
            String versionString = null;
            versionString = !removeVersion ? "-" + artifact.getVersion() : "";
            String classifierString = "";
            if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
                classifierString = "-" + artifact.getClassifier();
            }
            destFileName = artifact.getArtifactId() + versionString + classifierString + "." + artifact.getArtifactHandler().getExtension();
        }
        return destFileName;
    }

    public static File getFormattedOutputDirectory(boolean useSubdirsPerType, boolean useSubdirPerArtifact, boolean useRepositoryLayout, boolean removeVersion, File outputDirectory, Artifact artifact) {
        StringBuffer sb = new StringBuffer(128);
        if (useRepositoryLayout) {
            sb.append(artifact.getGroupId().replace('.', File.separatorChar)).append(File.separatorChar);
            sb.append(artifact.getArtifactId()).append(File.separatorChar);
            sb.append(artifact.getVersion()).append(File.separatorChar);
        } else {
            if (useSubdirsPerType) {
                sb.append(artifact.getType()).append("s").append(File.separatorChar);
            }
            if (useSubdirPerArtifact) {
                String artifactString = DependencyUtil.getDependencyId(artifact, removeVersion);
                sb.append(artifactString).append(File.separatorChar);
            }
        }
        return new File(outputDirectory, sb.toString());
    }

    private static String getDependencyId(Artifact artifact, boolean removeVersion) {
        StringBuffer sb = new StringBuffer();
        sb.append(artifact.getArtifactId());
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            sb.append("-");
            sb.append(artifact.getClassifier());
        }
        if (!removeVersion) {
            sb.append("-");
            sb.append(artifact.getVersion());
            sb.append("-");
            sb.append(artifact.getType());
        } else if (!StringUtils.equals((String)artifact.getClassifier(), (String)artifact.getType())) {
            sb.append("-");
            sb.append(artifact.getType());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void write(String string, File file, Log log) throws IOException {
        file.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(string);
            Object var5_4 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException exception) {
                log.error((CharSequence)"Cannot close file", (Throwable)exception);
            }
            throw throwable;
        }
        try {
            writer.close();
            return;
        }
        catch (IOException exception) {
            log.error((CharSequence)"Cannot close file", (Throwable)exception);
        }
    }

    public static synchronized void log(String string, Log log) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(string));
        while ((line = reader.readLine()) != null) {
            log.info((CharSequence)line);
        }
        reader.close();
    }
}

