/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.surefire.commonjunit48.org.codehaus.plexus.util.SelectorUtils;
import org.junit.experimental.categories.Categories;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFactory {
    private final ClassLoader testClassLoader;

    public FilterFactory(ClassLoader testClassLoader) {
        this.testClassLoader = testClassLoader;
    }

    public Filter createGroupFilter(Properties providerProperties) {
        String groups = providerProperties.getProperty("groups");
        String excludedGroups = providerProperties.getProperty("excludedgroups");
        List<Filter> included = this.commaSeparatedListToFilters(groups);
        List<Filter> excluded = this.commaSeparatedListToFilters(excludedGroups);
        return new CombinedCategoryFilter(included, excluded);
    }

    private List<Filter> commaSeparatedListToFilters(String str) {
        ArrayList<Filter> included = new ArrayList<Filter>();
        if (str != null) {
            for (String group : str.split(",")) {
                if ((group = group.trim()) == null || group.length() == 0) continue;
                Class<?> categoryType = this.classloadCategory(group);
                included.add((Filter)Categories.CategoryFilter.include(categoryType));
            }
        }
        return included;
    }

    public Filter createMethodFilter(String requestedTestMethod) {
        return new MethodFilter(requestedTestMethod);
    }

    private Class<?> classloadCategory(String category) {
        try {
            return this.testClassLoader.loadClass(category);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load category: " + category, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombinedCategoryFilter
    extends Filter {
        private final List<Filter> includedFilters;
        private final List<Filter> excludedFilters;

        public CombinedCategoryFilter(List<Filter> includedFilters, List<Filter> excludedFilters) {
            this.includedFilters = includedFilters;
            this.excludedFilters = excludedFilters;
        }

        public boolean shouldRun(Description description) {
            return !(!this.includedFilters.isEmpty() && !this.inOneOfFilters(this.includedFilters, description) || !this.excludedFilters.isEmpty() && this.inOneOfFilters(this.excludedFilters, description));
        }

        private boolean inOneOfFilters(List<Filter> filters, Description description) {
            for (Filter f : filters) {
                if (!f.shouldRun(description)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            StringBuilder sb = new StringBuilder();
            if (!this.includedFilters.isEmpty()) {
                sb.append("(");
                sb.append(this.joinFilters(this.includedFilters, " OR "));
                sb.append(")");
                if (!this.excludedFilters.isEmpty()) {
                    sb.append(" AND ");
                }
            }
            if (!this.excludedFilters.isEmpty()) {
                sb.append("NOT (");
                sb.append(this.joinFilters(this.includedFilters, " OR "));
                sb.append(")");
            }
            return sb.toString();
        }

        private String joinFilters(List<Filter> filters, String sep) {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            for (Filter f : filters) {
                if (i++ > 0) {
                    sb.append(sep);
                }
                sb.append(f.describe());
            }
            return sb.toString();
        }
    }

    private static class MethodFilter
    extends Filter {
        private final String requestedTestMethod;

        public MethodFilter(String requestedTestMethod) {
            this.requestedTestMethod = requestedTestMethod;
        }

        public boolean shouldRun(Description description) {
            for (Description o : description.getChildren()) {
                if (!this.isDescriptionMatch(o)) continue;
                return true;
            }
            return this.isDescriptionMatch(description);
        }

        private boolean isDescriptionMatch(Description description) {
            return description.getMethodName() != null && SelectorUtils.match(this.requestedTestMethod, description.getMethodName());
        }

        public String describe() {
            return "By method" + this.requestedTestMethod;
        }
    }
}

