/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http4;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;

public class HttpMethodConfiguration {
    private static final String COERCE_PATTERN = "%(\\w+),(.+)";
    private Boolean useDefaultHeaders;
    private Properties headers = new Properties();
    private Properties params = new Properties();
    private int connectionTimeout = 60000;
    private int readTimeout = Integer.parseInt(System.getProperty("maven.wagon.rto", Integer.toString(1800000)));

    public boolean isUseDefaultHeaders() {
        return this.useDefaultHeaders == null || this.useDefaultHeaders != false;
    }

    public HttpMethodConfiguration setUseDefaultHeaders(boolean useDefaultHeaders) {
        this.useDefaultHeaders = useDefaultHeaders;
        return this;
    }

    public Boolean getUseDefaultHeaders() {
        return this.useDefaultHeaders;
    }

    public HttpMethodConfiguration addHeader(String header, String value) {
        this.headers.setProperty(header, value);
        return this;
    }

    public Properties getHeaders() {
        return this.headers;
    }

    public HttpMethodConfiguration setHeaders(Properties headers) {
        this.headers = headers;
        return this;
    }

    public HttpMethodConfiguration addParam(String param, String value) {
        this.params.setProperty(param, value);
        return this;
    }

    public Properties getParams() {
        return this.params;
    }

    public HttpMethodConfiguration setParams(Properties params) {
        this.params = params;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public HttpMethodConfiguration setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpMethodConfiguration setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpParams asMethodParams(HttpParams defaults) {
        if (!this.hasParams()) {
            return null;
        }
        DefaultedHttpParams p = new DefaultedHttpParams((HttpParams)new BasicHttpParams(), defaults);
        this.fillParams((HttpParams)p);
        return p;
    }

    private boolean hasParams() {
        return this.connectionTimeout >= 1 || this.params != null || this.readTimeout >= 1;
    }

    private void fillParams(HttpParams p) {
        if (!this.hasParams()) {
            return;
        }
        if (this.connectionTimeout > 0) {
            p.setParameter("http.connection.timeout", (Object)this.connectionTimeout);
        }
        if (this.readTimeout > 0) {
            p.setParameter("http.socket.timeout", (Object)this.readTimeout);
        }
        if (this.params != null) {
            Pattern coercePattern = Pattern.compile(COERCE_PATTERN);
            for (Map.Entry<Object, Object> entry : this.params.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Matcher matcher = coercePattern.matcher(value);
                if (matcher.matches()) {
                    char type = matcher.group(1).charAt(0);
                    value = matcher.group(2);
                    switch (type) {
                        case 'i': {
                            p.setIntParameter(key, Integer.parseInt(value));
                            break;
                        }
                        case 'd': {
                            p.setDoubleParameter(key, Double.parseDouble(value));
                            break;
                        }
                        case 'l': {
                            p.setLongParameter(key, Long.parseLong(value));
                            break;
                        }
                        case 'b': {
                            p.setBooleanParameter(key, Boolean.valueOf(value).booleanValue());
                            break;
                        }
                        case 'c': {
                            int i;
                            String[] entries = value.split(",");
                            ArrayList<String> collection = new ArrayList<String>();
                            for (i = 0; i < entries.length; ++i) {
                                collection.add(entries[i].trim());
                            }
                            p.setParameter(key, collection);
                            break;
                        }
                        case 'm': {
                            int idx;
                            int i;
                            String[] entries = value.split(",");
                            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                            for (i = 0; i < entries.length && (idx = entries[i].indexOf("=>")) >= 1; ++i) {
                                String mapKey = entries[i].substring(0, idx);
                                String mapVal = entries[i].substring(idx + 1, entries[i].length());
                                map.put(mapKey.trim(), mapVal.trim());
                            }
                            p.setParameter(key, map);
                            break;
                        }
                    }
                    continue;
                }
                p.setParameter(key, (Object)value);
            }
        }
    }

    public Header[] asRequestHeaders() {
        if (this.headers == null) {
            return new Header[0];
        }
        Header[] result = new Header[this.headers.size()];
        int index = 0;
        for (Map.Entry<Object, Object> entry : this.headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            BasicHeader header = new BasicHeader(key, value);
            result[index++] = header;
        }
        return result;
    }

    private HttpMethodConfiguration copy() {
        HttpMethodConfiguration copy = new HttpMethodConfiguration();
        copy.setConnectionTimeout(this.getConnectionTimeout());
        copy.setReadTimeout(this.getReadTimeout());
        if (this.getHeaders() != null) {
            copy.setHeaders(this.getHeaders());
        }
        if (this.getParams() != null) {
            copy.setParams(this.getParams());
        }
        copy.setUseDefaultHeaders(this.isUseDefaultHeaders());
        return copy;
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration defaults, HttpMethodConfiguration base, HttpMethodConfiguration local) {
        HttpMethodConfiguration result = HttpMethodConfiguration.merge(defaults, base);
        return HttpMethodConfiguration.merge(result, local);
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration base, HttpMethodConfiguration local) {
        if (base == null && local == null) {
            return null;
        }
        if (base == null) {
            return local;
        }
        if (local == null) {
            return base;
        }
        HttpMethodConfiguration result = base.copy();
        if (local.getConnectionTimeout() != 60000) {
            result.setConnectionTimeout(local.getConnectionTimeout());
        }
        if (local.getReadTimeout() != 1800000) {
            result.setReadTimeout(local.getReadTimeout());
        }
        if (local.getHeaders() != null) {
            result.getHeaders().putAll((Map<?, ?>)local.getHeaders());
        }
        if (local.getParams() != null) {
            result.getParams().putAll((Map<?, ?>)local.getParams());
        }
        if (local.getUseDefaultHeaders() != null) {
            result.setUseDefaultHeaders(local.isUseDefaultHeaders());
        }
        return result;
    }
}

