/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.datacache.ExpirationListener;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class DelegatingDataCache
implements DataCache {
    private static final BitSet EMPTY_BITSET = new BitSet(0);
    private final DataCache _cache;
    private final DelegatingDataCache _del;
    private final RuntimeExceptionTranslator _trans;

    public DelegatingDataCache(DataCache cache) {
        this(cache, null);
    }

    public DelegatingDataCache(DataCache cache, RuntimeExceptionTranslator trans) {
        this._cache = cache;
        this._trans = trans;
        this._del = cache instanceof DelegatingDataCache ? (DelegatingDataCache)this._cache : null;
    }

    public DataCache getDelegate() {
        return this._cache;
    }

    public DataCache getInnermostDelegate() {
        return this._del == null ? this._cache : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        if (this._cache == null) {
            return super.hashCode();
        }
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingDataCache) {
            other = ((DelegatingDataCache)other).getInnermostDelegate();
        }
        return ObjectUtils.equals((Object)this.getInnermostDelegate(), (Object)other);
    }

    protected RuntimeException translate(RuntimeException re) {
        return this._trans == null ? re : this._trans.translate(re);
    }

    public String getName() {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.getName();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void setName(String name) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.setName(name);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void initialize(DataCacheManager manager) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.initialize(manager);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void commit(Collection additions, Collection newUpdates, Collection existingUpdates, Collection deletes) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.commit(additions, newUpdates, existingUpdates, deletes);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean contains(Object oid) {
        if (this._cache == null) {
            return false;
        }
        try {
            return this._cache.contains(oid);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public BitSet containsAll(Collection oids) {
        if (this._cache == null) {
            return EMPTY_BITSET;
        }
        try {
            return this._cache.containsAll(oids);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public DataCachePCData get(Object oid) {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.get(oid);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public DataCachePCData put(DataCachePCData value) {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.put(value);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void update(DataCachePCData value) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.update(value);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public DataCachePCData remove(Object oid) {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.remove(oid);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public BitSet removeAll(Collection oids) {
        if (this._cache == null) {
            return EMPTY_BITSET;
        }
        try {
            return this._cache.removeAll(oids);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void removeAll(Class cls, boolean subclasses) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.removeAll(cls, subclasses);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void clear() {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.clear();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean pin(Object oid) {
        if (this._cache == null) {
            return false;
        }
        try {
            return this._cache.pin(oid);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public BitSet pinAll(Collection oids) {
        if (this._cache == null) {
            return EMPTY_BITSET;
        }
        try {
            return this._cache.pinAll(oids);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void pinAll(Class cls, boolean subs) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.pinAll(cls, subs);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean unpin(Object oid) {
        if (this._cache == null) {
            return false;
        }
        try {
            return this._cache.unpin(oid);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public BitSet unpinAll(Collection oids) {
        if (this._cache == null) {
            return EMPTY_BITSET;
        }
        try {
            return this._cache.unpinAll(oids);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void unpinAll(Class cls, boolean subs) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.unpinAll(cls, subs);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void writeLock() {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.writeLock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void writeUnlock() {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.writeUnlock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void addExpirationListener(ExpirationListener listen) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.addExpirationListener(listen);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean removeExpirationListener(ExpirationListener listen) {
        if (this._cache == null) {
            return false;
        }
        try {
            return this._cache.removeExpirationListener(listen);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void close() {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.close();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Map getAll(List keys) {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.getAll(keys);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }
}

