/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.reactor.Acceptor;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Selectable;
import org.apache.qpid.proton.reactor.Selector;
import org.apache.qpid.proton.reactor.impl.Address;
import org.apache.qpid.proton.reactor.impl.ReactorImpl;
import org.apache.qpid.proton.reactor.impl.ReactorInternalException;
import org.apache.qpid.proton.reactor.impl.SelectableImpl;
import org.apache.qpid.proton.reactor.impl.SelectorImpl;

public class IOHandler
extends BaseHandler {
    private static Selectable.Callback connectionReadable = new Selectable.Callback(){

        @Override
        public void run(Selectable selectable) {
            Reactor reactor = selectable.getReactor();
            Transport transport = ((SelectableImpl)selectable).getTransport();
            int capacity = transport.capacity();
            if (capacity > 0) {
                SocketChannel socketChannel = (SocketChannel)selectable.getChannel();
                try {
                    int n = socketChannel.read(transport.tail());
                    if (n == -1) {
                        transport.close_tail();
                    } else {
                        transport.process();
                    }
                }
                catch (IOException e) {
                    ErrorCondition condition = new ErrorCondition();
                    condition.setCondition(Symbol.getSymbol("proton:io"));
                    condition.setDescription(e.getMessage());
                    transport.setCondition(condition);
                    transport.close_tail();
                }
            }
            IOHandler.update(selectable);
            reactor.update(selectable);
        }
    };
    private static Selectable.Callback connectionWritable = new Selectable.Callback(){

        @Override
        public void run(Selectable selectable) {
            int newPending;
            Reactor reactor = selectable.getReactor();
            Transport transport = ((SelectableImpl)selectable).getTransport();
            int pending = transport.pending();
            if (pending > 0) {
                SocketChannel channel = (SocketChannel)selectable.getChannel();
                try {
                    int n = channel.write(transport.head());
                    if (n < 0) {
                        transport.close_head();
                    } else {
                        transport.pop(n);
                    }
                }
                catch (IOException ioException) {
                    ErrorCondition condition = new ErrorCondition();
                    condition.setCondition(Symbol.getSymbol("proton:io"));
                    condition.setDescription(ioException.getMessage());
                    transport.setCondition(condition);
                    transport.close_head();
                }
            }
            if ((newPending = transport.pending()) != pending) {
                IOHandler.update(selectable);
                reactor.update(selectable);
            }
        }
    };
    private static Selectable.Callback connectionError = new Selectable.Callback(){

        @Override
        public void run(Selectable selectable) {
            Reactor reactor = selectable.getReactor();
            selectable.terminate();
            reactor.update(selectable);
        }
    };
    private static Selectable.Callback connectionExpired = new Selectable.Callback(){

        @Override
        public void run(Selectable selectable) {
            Reactor reactor = selectable.getReactor();
            Transport transport = ((SelectableImpl)selectable).getTransport();
            long deadline = transport.tick(reactor.now());
            selectable.setDeadline(deadline);
            int c = IOHandler.capacity(selectable);
            int p = IOHandler.pending(selectable);
            selectable.setReading(c > 0);
            selectable.setWriting(p > 0);
            reactor.update(selectable);
        }
    };
    private static Selectable.Callback connectionFree = new Selectable.Callback(){

        @Override
        public void run(Selectable selectable) {
            SelectableChannel channel = selectable.getChannel();
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    };

    private void handleQuiesced(Reactor reactor, Selector selector) throws IOException {
        if (!reactor.quiesced()) {
            return;
        }
        selector.select(reactor.getTimeout());
        reactor.mark();
        Iterator<Selectable> selectables = selector.readable();
        while (selectables.hasNext()) {
            selectables.next().readable();
        }
        selectables = selector.writeable();
        while (selectables.hasNext()) {
            selectables.next().writeable();
        }
        selectables = selector.expired();
        while (selectables.hasNext()) {
            selectables.next().expired();
        }
        selectables = selector.error();
        while (selectables.hasNext()) {
            selectables.next().error();
        }
        reactor.yield();
    }

    private void handleOpen(Reactor reactor, Event event) {
        Connection connection = event.getConnection();
        if (connection.getRemoteState() != EndpointState.UNINITIALIZED) {
            return;
        }
        String vhost = connection.getHostname();
        if (vhost == null) {
            String conAddr = reactor.getConnectionAddress(connection);
            if (conAddr != null) {
                Address addr = new Address(conAddr);
                connection.setHostname(addr.getHost());
            }
        } else if (vhost.isEmpty()) {
            connection.setHostname(null);
        }
        Transport transport = Proton.transport();
        int maxFrameSizeOption = reactor.getOptions().getMaxFrameSize();
        if (maxFrameSizeOption != 0) {
            transport.setMaxFrameSize(maxFrameSizeOption);
        }
        if (reactor.getOptions().isEnableSaslByDefault()) {
            Sasl sasl = transport.sasl();
            sasl.client();
            sasl.setMechanisms("ANONYMOUS");
        }
        transport.bind(connection);
    }

    private void handleBound(Reactor reactor, Event event) {
        Connection connection = event.getConnection();
        Record conn_recs = connection.attachments();
        if (conn_recs.get("pn_reactor_connection_acceptor", Acceptor.class) != null) {
            return;
        }
        String url = reactor.getConnectionAddress(connection);
        String hostname = connection.getHostname();
        int port = 5672;
        if (url != null) {
            Address address = new Address(url);
            hostname = address.getHost();
            try {
                port = Integer.parseInt(address.getImpliedPort());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Not a valid host: " + url, nfe);
            }
        }
        if (hostname != null && !hostname.equals("")) {
            int colonIndex = hostname.indexOf(58);
            if (colonIndex >= 0) {
                try {
                    port = Integer.parseInt(hostname.substring(colonIndex + 1));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Not a valid host: " + hostname, nfe);
                }
                hostname = hostname.substring(0, colonIndex);
            }
        } else {
            throw new IllegalStateException("No address provided for Connection");
        }
        Transport transport = event.getConnection().getTransport();
        Socket socket = null;
        try {
            SocketChannel socketChannel = ((ReactorImpl)reactor).getIO().socketChannel();
            socketChannel.configureBlocking(false);
            socketChannel.connect(new InetSocketAddress(hostname, port));
            socket = socketChannel.socket();
        }
        catch (Exception exception) {
            ErrorCondition condition = new ErrorCondition();
            condition.setCondition(Symbol.getSymbol("proton:io"));
            condition.setDescription(exception.getMessage());
            transport.setCondition(condition);
            transport.close_tail();
            transport.close_head();
            transport.pop(Math.max(0, transport.pending()));
        }
        IOHandler.selectableTransport(reactor, socket, transport);
    }

    private static int capacity(Selectable selectable) {
        Transport transport = ((SelectableImpl)selectable).getTransport();
        int capacity = transport.capacity();
        if (capacity < 0 && transport.isClosed()) {
            selectable.terminate();
        }
        return capacity;
    }

    private static int pending(Selectable selectable) {
        Transport transport = ((SelectableImpl)selectable).getTransport();
        int pending = transport.pending();
        if (pending < 0 && transport.isClosed()) {
            selectable.terminate();
        }
        return pending;
    }

    private static long deadline(SelectableImpl selectable) {
        Reactor reactor = selectable.getReactor();
        Transport transport = selectable.getTransport();
        long deadline = transport.tick(reactor.now());
        return deadline;
    }

    private static void update(Selectable selectable) {
        SelectableImpl selectableImpl = (SelectableImpl)selectable;
        int c = IOHandler.capacity(selectableImpl);
        int p = IOHandler.pending(selectableImpl);
        selectable.setReading(c > 0);
        selectable.setWriting(p > 0);
        selectable.setDeadline(IOHandler.deadline(selectableImpl));
    }

    protected static Selectable selectableTransport(Reactor reactor, Socket socket, Transport transport) {
        Selectable selectable = reactor.selectable();
        selectable.setChannel(socket != null ? socket.getChannel() : null);
        selectable.onReadable(connectionReadable);
        selectable.onWritable(connectionWritable);
        selectable.onError(connectionError);
        selectable.onExpired(connectionExpired);
        selectable.onFree(connectionFree);
        ((SelectableImpl)selectable).setTransport(transport);
        ((TransportImpl)transport).setSelectable(selectable);
        ((TransportImpl)transport).setReactor(reactor);
        IOHandler.update(selectable);
        reactor.update(selectable);
        return selectable;
    }

    private void handleTransport(Reactor reactor, Event event) {
        TransportImpl transport = (TransportImpl)event.getTransport();
        Selectable selectable = transport.getSelectable();
        if (selectable != null && !selectable.isTerminal()) {
            IOHandler.update(selectable);
            reactor.update(selectable);
        }
    }

    @Override
    public void onUnhandled(Event event) {
        try {
            ReactorImpl reactor = (ReactorImpl)event.getReactor();
            Selector selector = reactor.getSelector();
            if (selector == null) {
                selector = new SelectorImpl(reactor.getIO());
                reactor.setSelector(selector);
            }
            switch (event.getType()) {
                case SELECTABLE_INIT: {
                    Selectable selectable = event.getSelectable();
                    selector.add(selectable);
                    break;
                }
                case SELECTABLE_UPDATED: {
                    Selectable selectable = event.getSelectable();
                    selector.update(selectable);
                    break;
                }
                case SELECTABLE_FINAL: {
                    Selectable selectable = event.getSelectable();
                    selector.remove(selectable);
                    selectable.release();
                    break;
                }
                case CONNECTION_LOCAL_OPEN: {
                    this.handleOpen(reactor, event);
                    break;
                }
                case CONNECTION_BOUND: {
                    this.handleBound(reactor, event);
                    break;
                }
                case TRANSPORT: {
                    this.handleTransport(reactor, event);
                    break;
                }
                case TRANSPORT_CLOSED: {
                    event.getTransport().unbind();
                    break;
                }
                case REACTOR_QUIESCED: {
                    this.handleQuiesced(reactor, selector);
                    break;
                }
            }
        }
        catch (IOException ioException) {
            throw new ReactorInternalException(ioException);
        }
    }
}

