/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.transport;

import java.util.HashMap;
import java.util.List;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.qpid.client.HeartbeatListener;
import org.apache.qpid.client.security.AMQCallbackHandler;
import org.apache.qpid.client.security.CallbackHandlerRegistry;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.transport.ClientDelegate;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionHeartbeat;
import org.apache.qpid.transport.ConnectionOpenOk;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.util.Logger;
import org.apache.qpid.util.Strings;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConnectionDelegate
extends ClientDelegate {
    private static final Logger LOGGER;
    private static final String KRB5_OID_STR = "1.2.840.113554.1.2.2";
    protected static final Oid KRB5_OID;
    private final ConnectionURL _connectionURL;
    private HeartbeatListener _heartbeatListener = HeartbeatListener.DEFAULT;

    public ClientConnectionDelegate(ConnectionSettings settings, ConnectionURL connectionURL) {
        super(settings);
        this._connectionURL = connectionURL;
    }

    protected SaslClient createSaslClient(List<Object> brokerMechs) throws ConnectionException, SaslException {
        String brokerMechanisms = Strings.join((String)" ", brokerMechs);
        String restrictionList = this.getConnectionSettings().getSaslMechs();
        String selectedMech = CallbackHandlerRegistry.getInstance().selectMechanism(brokerMechanisms, restrictionList);
        if (selectedMech == null) {
            throw new ConnectionException("Client and broker have no SASL mechanisms in common. Broker allows : " + brokerMechanisms + " Client has : " + CallbackHandlerRegistry.getInstance().getMechanisms() + " Client restricted itself to : " + (restrictionList != null ? restrictionList : "no restriction"));
        }
        if ((this._connectionURL.getUsername() == null || this._connectionURL.getPassword() == null) && CallbackHandlerRegistry.getInstance().isUserPassRequired(selectedMech)) {
            throw new ConnectionException("Username and Password is required for the selected mechanism : " + selectedMech + " Broker allows : " + brokerMechanisms + " Client has : " + CallbackHandlerRegistry.getInstance().getMechanisms() + " Client restricted itself to : " + (restrictionList != null ? restrictionList : "no restriction"));
        }
        HashMap<String, String> saslProps = new HashMap<String, String>();
        if (this.getConnectionSettings().isUseSASLEncryption()) {
            saslProps.put("javax.security.sasl.qop", "auth-conf");
        }
        AMQCallbackHandler handler = CallbackHandlerRegistry.getInstance().createCallbackHandler(selectedMech);
        handler.initialise(this._connectionURL);
        SaslClient sc = Sasl.createSaslClient(new String[]{selectedMech}, null, this.getConnectionSettings().getSaslProtocol(), this.getConnectionSettings().getSaslServerName(), saslProps, handler);
        return sc;
    }

    public void connectionOpenOk(Connection conn, ConnectionOpenOk ok) {
        SaslClient sc = conn.getSaslClient();
        if (sc != null) {
            if (sc.getMechanismName().equals("GSSAPI")) {
                String id = this.getKerberosUser();
                if (id != null) {
                    conn.setUserID(id);
                }
            } else if (sc.getMechanismName().equals("EXTERNAL") && conn.getSecurityLayer() != null) {
                conn.setUserID(conn.getSecurityLayer().getUserID());
            }
        }
        super.connectionOpenOk(conn, ok);
    }

    private String getKerberosUser() {
        LOGGER.debug("Obtaining userID from kerberos", new Object[0]);
        String service = this.getConnectionSettings().getSaslProtocol() + "@" + this.getConnectionSettings().getSaslServerName();
        GSSManager manager = GSSManager.getInstance();
        try {
            GSSName acceptorName = manager.createName(service, GSSName.NT_HOSTBASED_SERVICE, KRB5_OID);
            GSSContext secCtx = manager.createContext(acceptorName, KRB5_OID, null, Integer.MAX_VALUE);
            secCtx.initSecContext(new byte[0], 0, 1);
            if (secCtx.getSrcName() != null) {
                return ((Object)secCtx.getSrcName()).toString();
            }
        }
        catch (GSSException e) {
            LOGGER.warn("Unable to retrieve userID from Kerberos due to error", new Object[]{e});
        }
        return null;
    }

    public void connectionHeartbeat(Connection conn, ConnectionHeartbeat hearbeat) {
        this._heartbeatListener.heartbeatReceived();
        super.connectionHeartbeat(conn, hearbeat);
        this._heartbeatListener.heartbeatSent();
    }

    public void setHeartbeatListener(HeartbeatListener listener) {
        this._heartbeatListener = listener == null ? HeartbeatListener.DEFAULT : listener;
    }

    static {
        Oid oid;
        LOGGER = Logger.get(ClientDelegate.class);
        try {
            oid = new Oid(KRB5_OID_STR);
        }
        catch (GSSException ignore) {
            oid = null;
        }
        KRB5_OID = oid;
    }
}

