/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.Content;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.FieldTableFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingUtils {
    private static final Logger _logger = LoggerFactory.getLogger(EncodingUtils.class);
    private static final String STRING_ENCODING = "iso8859-15";
    private static final Charset _charset = Charset.forName("iso8859-15");
    public static final int SIZEOF_UNSIGNED_SHORT = 2;
    public static final int SIZEOF_UNSIGNED_INT = 4;
    private static final boolean[] ALL_FALSE_ARRAY = new boolean[8];
    private static char[] hex_chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private EncodingUtils() {
    }

    public static int encodedShortStringLength(String s) {
        if (s == null) {
            return 1;
        }
        return (short)(1 + s.length());
    }

    public static int encodedShortStringLength(short s) {
        if (s == 0) {
            return 2;
        }
        boolean len = false;
        if (s < 0) {
            len = true;
            s = -s;
        }
        if (s > 9999) {
            return 6;
        }
        if (s > 999) {
            return 5;
        }
        if (s > 99) {
            return 4;
        }
        if (s > 9) {
            return 3;
        }
        return 2;
    }

    public static int encodedShortStringLength(int i) {
        if (i == 0) {
            return 2;
        }
        int len = 0;
        if (i < 0) {
            len = 1;
            i = -i;
        }
        if (i < Short.MAX_VALUE) {
            return len + EncodingUtils.encodedShortStringLength((short)i);
        }
        if (i > 999999) {
            return len + 6 + EncodingUtils.encodedShortStringLength((short)(i / 1000000));
        }
        return len + 5 + EncodingUtils.encodedShortStringLength((short)(i / 100000));
    }

    public static int encodedShortStringLength(long l) {
        if (l == 0L) {
            return 2;
        }
        int len = 0;
        if (l < 0L) {
            len = 1;
            l = -l;
        }
        if (l < Integer.MAX_VALUE) {
            return len + EncodingUtils.encodedShortStringLength((int)l);
        }
        if (l > 9999999999L) {
            return len + 10 + EncodingUtils.encodedShortStringLength((int)(l / 10000000000L));
        }
        return len + 1 + EncodingUtils.encodedShortStringLength((int)(l / 10L));
    }

    public static int encodedShortStringLength(AMQShortString s) {
        if (s == null) {
            return 1;
        }
        return 1 + s.length();
    }

    public static int encodedLongStringLength(String s) {
        if (s == null) {
            return 4;
        }
        return 4 + s.length();
    }

    public static int encodedLongStringLength(char[] s) {
        if (s == null) {
            return 4;
        }
        return 4 + s.length;
    }

    public static int encodedLongstrLength(byte[] bytes) {
        if (bytes == null) {
            return 4;
        }
        return 4 + bytes.length;
    }

    public static int encodedFieldTableLength(FieldTable table) {
        if (table == null) {
            return 4;
        }
        return (int)table.getEncodedSize() + 4;
    }

    public static int encodedContentLength(Content table) {
        return 0;
    }

    public static void writeShortStringBytes(DataOutput buffer, String s) throws IOException {
        if (s != null) {
            byte[] encodedString = new byte[s.length()];
            char[] cha = s.toCharArray();
            for (int i = 0; i < cha.length; ++i) {
                encodedString[i] = (byte)cha[i];
            }
            EncodingUtils.writeUnsignedByte(buffer, (short)encodedString.length);
            buffer.write(encodedString);
        } else {
            buffer.write(0);
        }
    }

    public static void writeShortStringBytes(DataOutput buffer, AMQShortString s) throws IOException {
        if (s != null) {
            s.writeToBuffer(buffer);
        } else {
            buffer.write(0);
        }
    }

    public static void writeLongStringBytes(DataOutput buffer, String s) throws IOException {
        if (s != null) {
            int len = s.length();
            EncodingUtils.writeUnsignedInteger(buffer, s.length());
            byte[] encodedString = new byte[len];
            char[] cha = s.toCharArray();
            for (int i = 0; i < cha.length; ++i) {
                encodedString[i] = (byte)cha[i];
            }
            buffer.write(encodedString);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeLongStringBytes(DataOutput buffer, char[] s) throws IOException {
        if (s != null) {
            int len = s.length;
            EncodingUtils.writeUnsignedInteger(buffer, s.length);
            byte[] encodedString = new byte[len];
            for (int i = 0; i < s.length; ++i) {
                encodedString[i] = (byte)s[i];
            }
            buffer.write(encodedString);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeLongStringBytes(DataOutput buffer, byte[] bytes) throws IOException {
        if (bytes != null) {
            EncodingUtils.writeUnsignedInteger(buffer, bytes.length);
            buffer.write(bytes);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeUnsignedByte(DataOutput buffer, short b) throws IOException {
        byte bv = (byte)b;
        buffer.write(bv);
    }

    public static void writeUnsignedShort(DataOutput buffer, int s) throws IOException {
        if (s < Short.MAX_VALUE) {
            buffer.writeShort(s);
        } else {
            short sv = (short)s;
            buffer.write((byte)(0xFF & sv >> 8));
            buffer.write((byte)(0xFF & sv));
        }
    }

    public static int unsignedIntegerLength() {
        return 4;
    }

    public static void writeUnsignedInteger(DataOutput buffer, long l) throws IOException {
        if (l < Integer.MAX_VALUE) {
            buffer.writeInt((int)l);
        } else {
            int iv = (int)l;
            buffer.write((byte)(0xFF & iv >> 24));
            buffer.write((byte)(0xFF & iv >> 16));
            buffer.write((byte)(0xFF & iv >> 8));
            buffer.write((byte)(0xFF & iv));
        }
    }

    public static void writeFieldTableBytes(DataOutput buffer, FieldTable table) throws IOException {
        if (table != null) {
            table.writeToBuffer(buffer);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeContentBytes(DataOutput buffer, Content content) {
    }

    public static void writeBooleans(DataOutput buffer, boolean[] values) throws IOException {
        int packedValue = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i]) continue;
            packedValue = (byte)(packedValue | 1 << i);
        }
        buffer.write(packedValue);
    }

    public static void writeBooleans(DataOutput buffer, boolean value) throws IOException {
        buffer.write(value ? 1 : 0);
    }

    public static void writeBooleans(DataOutput buffer, boolean value0, boolean value1) throws IOException {
        int packedValue;
        int n = packedValue = value0 ? 1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        buffer.write(packedValue);
    }

    public static void writeBooleans(DataOutput buffer, boolean value0, boolean value1, boolean value2) throws IOException {
        int packedValue;
        int n = packedValue = value0 ? 1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        buffer.write(packedValue);
    }

    public static void writeBooleans(DataOutput buffer, boolean value0, boolean value1, boolean value2, boolean value3) throws IOException {
        int packedValue;
        int n = packedValue = value0 ? 1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        buffer.write(packedValue);
    }

    public static void writeBooleans(DataOutput buffer, boolean value0, boolean value1, boolean value2, boolean value3, boolean value4) throws IOException {
        int packedValue;
        int n = packedValue = value0 ? 1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        if (value4) {
            packedValue = (byte)(packedValue | 0x10);
        }
        buffer.write(packedValue);
    }

    public static void writeBooleans(DataOutput buffer, boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) throws IOException {
        int packedValue;
        int n = packedValue = value0 ? 1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        if (value4) {
            packedValue = (byte)(packedValue | 0x10);
        }
        if (value5) {
            packedValue = (byte)(packedValue | 0x20);
        }
        buffer.write(packedValue);
    }

    public static void writeBooleans(DataOutput buffer, boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6) throws IOException {
        int packedValue;
        int n = packedValue = value0 ? 1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        if (value4) {
            packedValue = (byte)(packedValue | 0x10);
        }
        if (value5) {
            packedValue = (byte)(packedValue | 0x20);
        }
        if (value6) {
            packedValue = (byte)(packedValue | 0x40);
        }
        buffer.write(packedValue);
    }

    public static void writeBooleans(DataOutput buffer, boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7) throws IOException {
        int packedValue;
        int n = packedValue = value0 ? 1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        if (value4) {
            packedValue = (byte)(packedValue | 0x10);
        }
        if (value5) {
            packedValue = (byte)(packedValue | 0x20);
        }
        if (value6) {
            packedValue = (byte)(packedValue | 0x40);
        }
        if (value7) {
            packedValue = (byte)(packedValue | 0xFFFFFF80);
        }
        buffer.write(packedValue);
    }

    public static void writeLongstr(DataOutput buffer, byte[] data) throws IOException {
        if (data != null) {
            EncodingUtils.writeUnsignedInteger(buffer, data.length);
            buffer.write(data);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeTimestamp(DataOutput buffer, long timestamp) throws IOException {
        EncodingUtils.writeLong(buffer, timestamp);
    }

    public static boolean[] readBooleans(DataInput buffer) throws IOException {
        byte packedValue = buffer.readByte();
        if (packedValue == 0) {
            return ALL_FALSE_ARRAY;
        }
        boolean[] result = new boolean[8];
        result[0] = (packedValue & 1) != 0;
        result[1] = (packedValue & 2) != 0;
        result[2] = (packedValue & 4) != 0;
        boolean bl = result[3] = (packedValue & 8) != 0;
        if ((packedValue & 0xF0) == 0) {
            result[0] = (packedValue & 1) != 0;
        }
        result[4] = (packedValue & 0x10) != 0;
        result[5] = (packedValue & 0x20) != 0;
        result[6] = (packedValue & 0x40) != 0;
        result[7] = (packedValue & 0x80) != 0;
        return result;
    }

    public static FieldTable readFieldTable(DataInput buffer) throws AMQFrameDecodingException, IOException {
        long length = (long)buffer.readInt() & 0xFFFFFFFFL;
        if (length == 0L) {
            return null;
        }
        return FieldTableFactory.newFieldTable(buffer, length);
    }

    public static Content readContent(DataInput buffer) throws AMQFrameDecodingException {
        return null;
    }

    public static AMQShortString readAMQShortString(DataInput buffer) throws IOException {
        return AMQShortString.readFromBuffer(buffer);
    }

    public static String readShortString(DataInput buffer) throws IOException {
        short length = (short)((short)buffer.readByte() & 0xFF);
        if (length == 0) {
            return null;
        }
        byte[] stringBytes = new byte[length];
        buffer.readFully(stringBytes, 0, length);
        char[] stringChars = new char[length];
        for (int i = 0; i < stringChars.length; ++i) {
            stringChars[i] = (char)stringBytes[i];
        }
        return new String(stringChars);
    }

    public static String readLongString(DataInput buffer) throws IOException {
        long length = (long)buffer.readInt() & 0xFFFFFFFFL;
        if (length == 0L) {
            return "";
        }
        byte[] stringBytes = new byte[(int)length];
        buffer.readFully(stringBytes, 0, (int)length);
        char[] stringChars = new char[(int)length];
        for (int i = 0; i < stringChars.length; ++i) {
            stringChars[i] = (char)stringBytes[i];
        }
        return new String(stringChars);
    }

    public static byte[] readLongstr(DataInput buffer) throws IOException {
        long length = (long)buffer.readInt() & 0xFFFFFFFFL;
        if (length == 0L) {
            return null;
        }
        byte[] result = new byte[(int)length];
        buffer.readFully(result);
        return result;
    }

    public static long readTimestamp(DataInput buffer) throws IOException {
        return buffer.readLong();
    }

    static byte[] hexToByteArray(String id) {
        String s = id.charAt(1) == 'x' ? id.substring(2) : id;
        int len = s.length();
        int byte_len = len / 2;
        byte[] b = new byte[byte_len];
        for (int i = 0; i < byte_len; ++i) {
            int ch = i * 2;
            byte b1 = Byte.parseByte(s.substring(ch, ch + 1), 16);
            byte b2 = Byte.parseByte(s.substring(ch + 1, ch + 2), 16);
            b[i] = (byte)(b1 * 16 + b2);
        }
        return b;
    }

    public static char[] convertToHexCharArray(byte[] from) {
        int length = from.length;
        char[] result_buff = new char[length * 2 + 2];
        result_buff[0] = 48;
        result_buff[1] = 120;
        int dest = 2;
        for (int i = 0; i < length; ++i) {
            int bite = from[i];
            if (bite < 0) {
                bite += 256;
            }
            result_buff[dest++] = hex_chars[bite >> 4];
            result_buff[dest++] = hex_chars[bite & 0xF];
        }
        return result_buff;
    }

    public static String convertToHexString(byte[] from) {
        return new String(EncodingUtils.convertToHexCharArray(from));
    }

    public static String convertToHexString(ByteBuffer bb) {
        int size = bb.limit();
        byte[] from = new byte[size];
        for (int i = 0; i < size; ++i) {
            from[i] = bb.get(i);
        }
        return new String(EncodingUtils.convertToHexCharArray(from));
    }

    public static void writeBoolean(DataOutput buffer, boolean aBoolean) throws IOException {
        buffer.write(aBoolean ? 1 : 0);
    }

    public static boolean readBoolean(DataInput buffer) throws IOException {
        byte packedValue = buffer.readByte();
        return packedValue == 1;
    }

    public static int encodedBooleanLength() {
        return 1;
    }

    public static void writeByte(DataOutput buffer, byte aByte) throws IOException {
        buffer.writeByte(aByte);
    }

    public static byte readByte(DataInput buffer) throws IOException {
        return buffer.readByte();
    }

    public static int encodedByteLength() {
        return 1;
    }

    public static void writeShort(DataOutput buffer, short aShort) throws IOException {
        buffer.writeShort(aShort);
    }

    public static short readShort(DataInput buffer) throws IOException {
        return buffer.readShort();
    }

    public static int encodedShortLength() {
        return 2;
    }

    public static void writeInteger(DataOutput buffer, int aInteger) throws IOException {
        buffer.writeInt(aInteger);
    }

    public static int readInteger(DataInput buffer) throws IOException {
        return buffer.readInt();
    }

    public static int encodedIntegerLength() {
        return 4;
    }

    public static void writeLong(DataOutput buffer, long aLong) throws IOException {
        buffer.writeLong(aLong);
    }

    public static long readLong(DataInput buffer) throws IOException {
        return buffer.readLong();
    }

    public static int encodedLongLength() {
        return 8;
    }

    public static void writeFloat(DataOutput buffer, float aFloat) throws IOException {
        buffer.writeFloat(aFloat);
    }

    public static float readFloat(DataInput buffer) throws IOException {
        return buffer.readFloat();
    }

    public static int encodedFloatLength() {
        return 4;
    }

    public static void writeDouble(DataOutput buffer, Double aDouble) throws IOException {
        buffer.writeDouble(aDouble);
    }

    public static double readDouble(DataInput buffer) throws IOException {
        return buffer.readDouble();
    }

    public static int encodedDoubleLength() {
        return 8;
    }

    public static byte[] readBytes(DataInput buffer) throws IOException {
        long length = (long)buffer.readInt() & 0xFFFFFFFFL;
        if (length == 0L) {
            return null;
        }
        byte[] dataBytes = new byte[(int)length];
        buffer.readFully(dataBytes, 0, (int)length);
        return dataBytes;
    }

    public static void writeBytes(DataOutput buffer, byte[] data) throws IOException {
        if (data != null) {
            EncodingUtils.writeUnsignedInteger(buffer, data.length);
            buffer.write(data);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static int encodedCharLength() {
        return EncodingUtils.encodedByteLength();
    }

    public static char readChar(DataInput buffer) throws IOException {
        return (char)buffer.readByte();
    }

    public static void writeChar(DataOutput buffer, char character) throws IOException {
        EncodingUtils.writeByte(buffer, (byte)character);
    }

    public static long readLongAsShortString(DataInput buffer) throws IOException {
        boolean isNegative;
        short length = (short)buffer.readUnsignedByte();
        short pos = 0;
        if (length == 0) {
            return 0L;
        }
        byte digit = buffer.readByte();
        long result = 0L;
        if (digit == 45) {
            isNegative = true;
            pos = (short)(pos + 1);
            digit = buffer.readByte();
        } else {
            isNegative = false;
        }
        result = digit - 48;
        pos = (short)(pos + 1);
        while (pos < length) {
            pos = (short)(pos + 1);
            digit = buffer.readByte();
            result = (result << 3) + (result << 1);
            result += (long)(digit - 48);
        }
        return result;
    }

    public static long readUnsignedInteger(DataInput buffer) throws IOException {
        long l = 0xFF & buffer.readByte();
        l <<= 8;
        l |= (long)(0xFF & buffer.readByte());
        l <<= 8;
        l |= (long)(0xFF & buffer.readByte());
        l <<= 8;
        return l |= (long)(0xFF & buffer.readByte());
    }
}

